/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.util;

import org.apache.isis.commons.internal.exceptions._Exceptions;
import org.apache.isis.viewer.common.model.components.ComponentType;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.Page;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.markup.html.WebMarkupContainer;

public final class Components {
    private Components() {
    }

    public static void permanentlyHide(MarkupContainer container, String ... ids) {
        for (String id : ids) {
            Components.permanentlyHideSingle(container, id);
        }
    }

    public static void permanentlyHide(MarkupContainer container, ComponentType ... componentIds) {
        for (ComponentType componentType : componentIds) {
            Components.permanentlyHideSingle(container, componentType.getId());
        }
    }

    private static void permanentlyHideSingle(MarkupContainer container, String id) {
        WebMarkupContainer invisible = new WebMarkupContainer(id);
        invisible.setVisible(false);
        container.addOrReplace(new Component[]{invisible});
    }

    public static void setVisible(MarkupContainer container, boolean visibility, String ... ids) {
        for (String id : ids) {
            Components.setVisible(container, visibility, id);
        }
    }

    public static void setVisible(MarkupContainer container, boolean visibility, ComponentType ... componentTypes) {
        for (ComponentType componentType : componentTypes) {
            Components.setVisible(container, visibility, componentType.getId());
        }
    }

    private static void setVisible(MarkupContainer container, boolean visibility, String wicketId) {
        Component childComponent = container.get(wicketId);
        childComponent.setVisible(visibility);
    }

    public static boolean isRenderedComponent(Component component) {
        return component.getOutputMarkupId() && !(component instanceof Page);
    }

    public static boolean hasPage(Component component) {
        return component.findParent(Page.class) != null;
    }

    public static void addToAjaxRequest(AjaxRequestTarget target, Component component) {
        if (target == null || component == null) {
            return;
        }
        try {
            target.add(new Component[]{component});
        }
        catch (IllegalArgumentException cause) {
            _Exceptions.FluentException.of((Exception)cause).suppressIfMessageContains("Cannot update component because its page is not the same");
        }
    }
}

