/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.util;

import de.agilecoders.wicket.core.markup.html.bootstrap.components.TooltipConfig;
import de.agilecoders.wicket.extensions.markup.html.bootstrap.confirmation.ConfirmationBehavior;
import de.agilecoders.wicket.extensions.markup.html.bootstrap.confirmation.ConfirmationConfig;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.isis.applib.services.i18n.TranslationService;
import org.apache.isis.core.metamodel.interactions.managed.ManagedAction;
import org.apache.isis.core.metamodel.spec.feature.ObjectAction;
import org.apache.isis.viewer.common.model.action.decorator.ActionUiDecorator;
import org.apache.isis.viewer.common.model.decorator.confirm.ConfirmDecorator;
import org.apache.isis.viewer.common.model.decorator.confirm.ConfirmUiModel;
import org.apache.isis.viewer.common.model.decorator.danger.DangerDecorator;
import org.apache.isis.viewer.common.model.decorator.disable.DisablingDecorator;
import org.apache.isis.viewer.common.model.decorator.disable.DisablingUiModel;
import org.apache.isis.viewer.common.model.decorator.icon.FontAwesomeUiModel;
import org.apache.isis.viewer.common.model.decorator.icon.IconDecorator;
import org.apache.isis.viewer.common.model.decorator.prototyping.PrototypingDecorator;
import org.apache.isis.viewer.common.model.decorator.prototyping.PrototypingUiModel;
import org.apache.isis.viewer.common.model.decorator.tooltip.TooltipDecorator;
import org.apache.isis.viewer.common.model.decorator.tooltip.TooltipUiModel;
import org.apache.isis.viewer.wicket.model.links.LinkAndLabel;
import org.apache.isis.viewer.wicket.ui.components.actionmenu.CssClassFaBehavior;
import org.apache.isis.viewer.wicket.ui.util.Tooltips;
import org.apache.isis.viewer.wicket.ui.util.Wkt;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.form.Button;
import org.apache.wicket.markup.html.link.AbstractLink;

public final class Decorators {
    private static final AtomicReference<Object> tooltip = new AtomicReference();
    private static final AtomicReference<Object> disable = new AtomicReference();
    private static final AtomicReference<Object> prototyping = new AtomicReference();
    private static final AtomicReference<Object> confirm = new AtomicReference();
    private static final AtomicReference<Object> danger = new AtomicReference();
    private static final AtomicReference<Object> icon = new AtomicReference();
    private static final AtomicReference<Object> missingIcon = new AtomicReference();
    private static final AtomicReference<Object> actionLink = new AtomicReference();

    private Decorators() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Tooltip getTooltip() {
        Object value = tooltip.get();
        if (value == null) {
            AtomicReference<Object> atomicReference = tooltip;
            synchronized (atomicReference) {
                value = tooltip.get();
                if (value == null) {
                    Tooltip actualValue = new Tooltip();
                    value = actualValue == null ? tooltip : actualValue;
                    tooltip.set(value);
                }
            }
        }
        return (Tooltip)(value == tooltip ? null : value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Disable getDisable() {
        Object value = disable.get();
        if (value == null) {
            AtomicReference<Object> atomicReference = disable;
            synchronized (atomicReference) {
                value = disable.get();
                if (value == null) {
                    Disable actualValue = new Disable();
                    value = actualValue == null ? disable : actualValue;
                    disable.set(value);
                }
            }
        }
        return (Disable)(value == disable ? null : value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Prototyping getPrototyping() {
        Object value = prototyping.get();
        if (value == null) {
            AtomicReference<Object> atomicReference = prototyping;
            synchronized (atomicReference) {
                value = prototyping.get();
                if (value == null) {
                    Prototyping actualValue = new Prototyping();
                    value = actualValue == null ? prototyping : actualValue;
                    prototyping.set(value);
                }
            }
        }
        return (Prototyping)(value == prototyping ? null : value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Confirm getConfirm() {
        Object value = confirm.get();
        if (value == null) {
            AtomicReference<Object> atomicReference = confirm;
            synchronized (atomicReference) {
                value = confirm.get();
                if (value == null) {
                    Confirm actualValue = new Confirm();
                    value = actualValue == null ? confirm : actualValue;
                    confirm.set(value);
                }
            }
        }
        return (Confirm)(value == confirm ? null : value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Danger getDanger() {
        Object value = danger.get();
        if (value == null) {
            AtomicReference<Object> atomicReference = danger;
            synchronized (atomicReference) {
                value = danger.get();
                if (value == null) {
                    Danger actualValue = new Danger();
                    value = actualValue == null ? danger : actualValue;
                    danger.set(value);
                }
            }
        }
        return (Danger)(value == danger ? null : value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IconDecoratorWkt getIcon() {
        Object value = icon.get();
        if (value == null) {
            AtomicReference<Object> atomicReference = icon;
            synchronized (atomicReference) {
                value = icon.get();
                if (value == null) {
                    IconDecoratorWkt actualValue = new IconDecoratorWkt();
                    value = actualValue == null ? icon : actualValue;
                    icon.set(value);
                }
            }
        }
        return (IconDecoratorWkt)(value == icon ? null : value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MissingIconDecorator getMissingIcon() {
        Object value = missingIcon.get();
        if (value == null) {
            AtomicReference<Object> atomicReference = missingIcon;
            synchronized (atomicReference) {
                value = missingIcon.get();
                if (value == null) {
                    MissingIconDecorator actualValue = new MissingIconDecorator();
                    value = actualValue == null ? missingIcon : actualValue;
                    missingIcon.set(value);
                }
            }
        }
        return (MissingIconDecorator)(value == missingIcon ? null : value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ActionLink getActionLink() {
        Object value = actionLink.get();
        if (value == null) {
            AtomicReference<Object> atomicReference = actionLink;
            synchronized (atomicReference) {
                value = actionLink.get();
                if (value == null) {
                    ActionLink actualValue = new ActionLink();
                    value = actualValue == null ? actionLink : actualValue;
                    actionLink.set(value);
                }
            }
        }
        return (ActionLink)((Object)(value == actionLink ? null : value));
    }

    public static final class ActionLink
    extends ActionUiDecorator<Component> {
        public ActionLink() {
            super((TooltipDecorator)Decorators.getTooltip(), (DisablingDecorator)Decorators.getDisable(), (ConfirmDecorator)Decorators.getConfirm(), (PrototypingDecorator)Decorators.getPrototyping(), (IconDecorator)Decorators.getIcon());
        }

        private <T extends Component> void commonDecorateMenuItem(T uiComponent, LinkAndLabel linkAndLabel, TranslationService translationService) {
            AbstractLink actionLinkUiComponent = linkAndLabel.getUiComponent();
            ObjectAction actionMeta = linkAndLabel.getManagedAction().getAction();
            linkAndLabel.getDisableUiModel().ifPresent(disableUiModel -> {
                this.getDisableDecorator().decorate((Object)uiComponent, disableUiModel);
                this.getTooltipDecorator().decorate((Object)uiComponent, TooltipUiModel.ofBody((String)disableUiModel.getReason()));
            });
            if (!linkAndLabel.getDisableUiModel().isPresent()) {
                linkAndLabel.getDescription().ifPresent(describedAs -> this.getTooltipDecorator().decorate((Object)uiComponent, TooltipUiModel.ofBody((String)describedAs)));
                if (actionMeta.isImmediateConfirmationRequired()) {
                    ConfirmUiModel confirmUiModel = ConfirmUiModel.ofAreYouSure((TranslationService)translationService, (ConfirmUiModel.Placement)ConfirmUiModel.Placement.BOTTOM);
                    this.getConfirmDecorator().decorate((Object)actionLinkUiComponent, confirmUiModel);
                }
            }
            if (actionMeta.isPrototype()) {
                this.getPrototypingDecorator().decorate((Object)actionLinkUiComponent, PrototypingUiModel.of((ManagedAction)linkAndLabel.getManagedAction()));
            }
        }

        public void decorateMenuItem(Component uiComponent, LinkAndLabel linkAndLabel, TranslationService translationService) {
            Wkt.cssAppend(uiComponent, linkAndLabel.getFeatureIdentifier());
            this.commonDecorateMenuItem(uiComponent, linkAndLabel, translationService);
            linkAndLabel.getAdditionalCssClass().ifPresent(cssClass -> Wkt.cssAppend(linkAndLabel.getUiComponent(), cssClass));
        }
    }

    public static final class MissingIconDecorator
    implements IconDecorator<Component, Component> {
        public Component decorate(Component uiComponent, Optional<FontAwesomeUiModel> fontAwesome) {
            if (!fontAwesome.isPresent()) {
                Wkt.cssAppend(uiComponent, "menuLinkSpacer");
            }
            return uiComponent;
        }
    }

    public static final class IconDecoratorWkt
    implements IconDecorator<Component, Component> {
        public Component decorate(Component uiComponent, Optional<FontAwesomeUiModel> fontAwesome) {
            if (fontAwesome.isPresent()) {
                uiComponent.add(new Behavior[]{new CssClassFaBehavior(fontAwesome.get())});
            }
            return uiComponent;
        }
    }

    public static final class Danger
    implements DangerDecorator<Component> {
        public void decorate(Component uiComponent) {
            Wkt.cssAppend(uiComponent, "btn-danger");
        }
    }

    public static final class Confirm
    implements ConfirmDecorator<Component> {
        public void decorate(Component uiComponent, ConfirmUiModel confirmUiModel) {
            ConfirmationConfig confirmationConfig = new ConfirmationConfig().withTitle(confirmUiModel.getTitle()).withBtnOkLabel(confirmUiModel.getOkLabel()).withBtnCancelLabel(confirmUiModel.getCancelLabel()).withBtnOkClass("btn btn-danger").withBtnCancelClass("btn btn-secondary").withPlacement(TooltipConfig.Placement.valueOf((String)confirmUiModel.getPlacement().name().toLowerCase()));
            uiComponent.add(new Behavior[]{new ConfirmationBehavior(confirmationConfig)});
            if (uiComponent instanceof Button) {
                Decorators.getDanger().decorate(uiComponent);
            }
        }
    }

    public static final class Prototyping
    implements PrototypingDecorator<Component, Component> {
        public Component decorate(Component uiComponent, PrototypingUiModel prototypingUiModel) {
            Wkt.cssAppend(uiComponent, "prototype");
            return uiComponent;
        }
    }

    public static final class Disable
    implements DisablingDecorator<Component> {
        public void decorate(Component uiComponent, DisablingUiModel disableUiModel) {
            TooltipUiModel tooltipUiModel = TooltipUiModel.ofBody((String)disableUiModel.getReason());
            Decorators.getTooltip().decorate(uiComponent, tooltipUiModel);
            Wkt.cssAppend(uiComponent, "disabled");
            uiComponent.setEnabled(false);
        }
    }

    public static final class Tooltip
    implements TooltipDecorator<Component> {
        public void decorate(Component uiComponent, TooltipUiModel tooltipUiModel) {
            Tooltips.addTooltip(uiComponent, tooltipUiModel);
        }
    }
}

