/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.util;

import de.agilecoders.wicket.core.markup.html.bootstrap.components.PopoverBehavior;
import de.agilecoders.wicket.core.markup.html.bootstrap.components.PopoverConfig;
import de.agilecoders.wicket.core.markup.html.bootstrap.components.TooltipConfig;
import java.io.Serializable;
import lombok.NonNull;
import org.apache.isis.commons.internal.base._Strings;
import org.apache.isis.viewer.common.model.decorator.tooltip.TooltipUiModel;
import org.apache.isis.viewer.wicket.ui.util.ExtendedPopoverConfig;
import org.apache.isis.viewer.wicket.ui.util.Wkt;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.head.CssHeaderItem;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.request.resource.CssResourceReference;
import org.apache.wicket.request.resource.ResourceReference;
import org.springframework.lang.Nullable;

public final class Tooltips {
    public static void renderHead(IHeaderResponse response) {
        response.render((HeaderItem)CssHeaderItem.forReference((ResourceReference)new CssResourceReference(Tooltips.class, "isis-tooltips.css")));
    }

    public static void addTooltip(@NonNull Component target, @Nullable TooltipUiModel tooltipUiModel) {
        if (target == null) {
            throw new NullPointerException("target is marked non-null but is null");
        }
        if (tooltipUiModel == null || _Strings.isEmpty((CharSequence)tooltipUiModel.getBody())) {
            return;
        }
        IModel labelModel = (IModel)tooltipUiModel.getLabel().map(label -> Model.of((Serializable)((Object)label))).orElseGet(() -> Model.of());
        Model bodyModel = Model.of((Serializable)((Object)tooltipUiModel.getBody()));
        PopoverBehavior tooltipBehavior = Tooltips.createTooltipBehavior((IModel<String>)labelModel, (IModel<String>)bodyModel);
        Wkt.cssAppend(target, "isis-component-with-tooltip");
        target.add(new Behavior[]{tooltipBehavior});
    }

    public static void clearTooltip(Component target) {
        target.getBehaviors(PopoverBehavior.class).forEach(xva$0 -> target.remove(new Behavior[]{xva$0}));
    }

    public static void addTooltip(@NonNull Component target, @Nullable String body) {
        if (target == null) {
            throw new NullPointerException("target is marked non-null but is null");
        }
        Tooltips.addTooltip(target, _Strings.isEmpty((CharSequence)body) ? null : TooltipUiModel.ofBody((String)body));
    }

    public static void addTooltip(@NonNull Component target, @Nullable String label, @Nullable String body) {
        if (target == null) {
            throw new NullPointerException("target is marked non-null but is null");
        }
        Tooltips.addTooltip(target, _Strings.isEmpty((CharSequence)body) ? null : TooltipUiModel.of((String)label, (String)body));
    }

    private static PopoverBehavior createTooltipBehavior(IModel<String> label, IModel<String> body) {
        return new PopoverBehavior(label, body, Tooltips.createTooltipConfig());
    }

    private static PopoverConfig createTooltipConfig() {
        return new ExtendedPopoverConfig().withBoundary(ExtendedPopoverConfig.PopoverBoundary.viewport).withTrigger(TooltipConfig.OpenTrigger.hover).withPlacement((TooltipConfig.IPlacement)TooltipConfig.Placement.bottom).withAnimation(true);
    }

    private Tooltips() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

