/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.util;

import de.agilecoders.wicket.core.markup.html.bootstrap.behavior.CssClassNameAppender;
import de.agilecoders.wicket.core.markup.html.bootstrap.button.Buttons;
import de.agilecoders.wicket.core.util.Attributes;
import de.agilecoders.wicket.extensions.markup.html.bootstrap.form.checkboxx.CheckBoxX;
import de.agilecoders.wicket.extensions.markup.html.bootstrap.form.checkboxx.CheckBoxXConfig;
import de.agilecoders.wicket.jquery.IKey;
import de.agilecoders.wicket.jquery.Key;
import java.io.Serializable;
import java.util.List;
import lombok.NonNull;
import org.apache.isis.applib.Identifier;
import org.apache.isis.commons.internal.base._Strings;
import org.apache.isis.commons.internal.debug._Probe;
import org.apache.isis.commons.internal.functions._Functions;
import org.apache.isis.viewer.wicket.model.isis.WicketViewerSettings;
import org.apache.isis.viewer.wicket.ui.panels.PanelUtil;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.ajax.AbstractDefaultAjaxBehavior;
import org.apache.wicket.ajax.AjaxEventBehavior;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.attributes.AjaxRequestAttributes;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.ajax.markup.html.form.AjaxButton;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.extensions.ajax.markup.html.IndicatingAjaxButton;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.JavaScriptContentHeaderItem;
import org.apache.wicket.markup.head.OnDomReadyHeaderItem;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.TextArea;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.markup.html.image.Image;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.markup.html.panel.Fragment;
import org.apache.wicket.markup.repeater.Item;
import org.apache.wicket.markup.repeater.OddEvenItem;
import org.apache.wicket.model.IModel;
import org.apache.wicket.request.resource.ResourceReference;
import org.apache.wicket.util.convert.IConverter;
import org.apache.wicket.validation.IValidationError;
import org.apache.wicket.validation.ValidationError;
import org.danekja.java.util.function.serializable.SerializableBiConsumer;
import org.danekja.java.util.function.serializable.SerializableBooleanSupplier;
import org.danekja.java.util.function.serializable.SerializableConsumer;
import org.springframework.lang.Nullable;

public final class Wkt {
    public static <T extends Component> T add(MarkupContainer container, T component) {
        container.addOrReplace(new Component[]{component});
        return component;
    }

    public static <T extends Behavior> T add(MarkupContainer container, T component) {
        container.add(new Behavior[]{component});
        return component;
    }

    public static Behavior behaviorOnClick(final SerializableConsumer<AjaxRequestTarget> onClick) {
        return new AjaxEventBehavior("click"){
            private static final long serialVersionUID = 1L;

            protected void onEvent(AjaxRequestTarget target) {
                _Probe.entryPoint((_Probe.EntryPoint)_Probe.EntryPoint.USER_INTERACTION, (String)"Wicket Ajax Request, originating from User clicking on an editable Property (to start inline editing)or an Action (to enter param negotiaton or directly execute the Action).");
                onClick.accept((Object)target);
            }
        };
    }

    public static Behavior behaviorFireOnEscapeKey(final SerializableConsumer<AjaxRequestTarget> onRespond) {
        return new AbstractDefaultAjaxBehavior(){
            private static final long serialVersionUID = 1L;
            private static final String PRE_JS = "$(document).ready( function() { \n  $(document).bind('keyup', function(evt) { \n    if (evt.keyCode == 27) { \n";
            private static final String POST_JS = "      evt.preventDefault(); \n       } \n  }); \n});";

            public void renderHead(Component component, IHeaderResponse response) {
                super.renderHead(component, response);
                String javascript = PRE_JS + this.getCallbackScript() + POST_JS;
                response.render((HeaderItem)JavaScriptContentHeaderItem.forScript((CharSequence)javascript, null, null));
            }

            protected void respond(AjaxRequestTarget target) {
                onRespond.accept((Object)target);
            }
        };
    }

    public static Behavior behaviorReplaceDisabledTagWithReadonlyTag() {
        return new ReplaceDisabledTagWithReadonlyTagBehavior();
    }

    public static Behavior behaviorAddOnClick(MarkupContainer markupContainer, SerializableConsumer<AjaxRequestTarget> onClick) {
        return Wkt.add(markupContainer, Wkt.behaviorOnClick(onClick));
    }

    public static Behavior behaviorAddFireOnEscapeKey(MarkupContainer markupContainer, SerializableConsumer<AjaxRequestTarget> onRespond) {
        return Wkt.add(markupContainer, Wkt.behaviorFireOnEscapeKey(onRespond));
    }

    public static void behaviorAddReplaceDisabledTagWithReadonlyTag(Component component) {
        if (component.getBehaviors(ReplaceDisabledTagWithReadonlyTagBehavior.class).isEmpty()) {
            component.add(new Behavior[]{new ReplaceDisabledTagWithReadonlyTagBehavior()});
        }
    }

    public static AjaxButton button(String id, IModel<String> labelModel, final SerializableBiConsumer<AjaxButton, AjaxRequestTarget> onClick) {
        return new AjaxButton(id, labelModel){
            private static final long serialVersionUID = 1L;

            public void onSubmit(AjaxRequestTarget target) {
                onClick.accept((Object)this, (Object)target);
            }
        };
    }

    public static AjaxButton buttonOk(String id, IModel<String> labelModel, final WicketViewerSettings settings, final SerializableBiConsumer<AjaxButton, AjaxRequestTarget> onClick) {
        return settings.isUseIndicatorForFormSubmit() ? new IndicatingAjaxButton(id, labelModel){
            private static final long serialVersionUID = 1L;

            public void onSubmit(AjaxRequestTarget target) {
                onClick.accept((Object)this, (Object)target);
            }

            protected void updateAjaxAttributes(AjaxRequestAttributes attributes) {
                if (settings.isPreventDoubleClickForFormSubmit()) {
                    PanelUtil.disableBeforeReenableOnComplete(attributes, (Component)this);
                }
            }

            protected void onError(AjaxRequestTarget target) {
                target.add(new Component[]{this.getForm()});
            }
        } : new AjaxButton(id, labelModel){
            private static final long serialVersionUID = 1L;

            public void onSubmit(AjaxRequestTarget target) {
                onClick.accept((Object)this, (Object)target);
            }

            protected void updateAjaxAttributes(AjaxRequestAttributes attributes) {
                if (settings.isPreventDoubleClickForFormSubmit()) {
                    PanelUtil.disableBeforeReenableOnComplete(attributes, (Component)this);
                }
            }

            protected void onError(AjaxRequestTarget target) {
                target.add(new Component[]{this.getForm()});
            }
        };
    }

    public static AjaxButton buttonAdd(MarkupContainer markupContainer, String id, IModel<String> labelModel, SerializableBiConsumer<AjaxButton, AjaxRequestTarget> onClick) {
        return Wkt.add(markupContainer, Wkt.button(id, labelModel, onClick));
    }

    public static AjaxButton buttonAddOk(MarkupContainer markupContainer, String id, IModel<String> labelModel, WicketViewerSettings settings, SerializableBiConsumer<AjaxButton, AjaxRequestTarget> onClick) {
        return Wkt.add(markupContainer, Wkt.buttonOk(id, labelModel, settings, onClick));
    }

    public static CheckBoxX checkbox(String id, IModel<Boolean> checkedModel, boolean required, CheckBoxXConfig.Sizes size) {
        final CheckBoxXConfig config = new CheckBoxXConfig(){
            private static final long serialVersionUID = 1L;
            {
                this.put((IKey)new Key("tabindex"), "0");
            }
        }.withSize(size).withEnclosedLabel(false).withIconChecked("<i class='fa fa-fw fa-check'></i>").withIconNull("<i class='fa fa-fw fa-square'></i>").withThreeState(!required);
        CheckBoxX checkBox = new CheckBoxX(id, checkedModel){
            private static final long serialVersionUID = 1L;

            public CheckBoxXConfig getConfig() {
                return config;
            }

            protected void onComponentTag(ComponentTag tag) {
                super.onComponentTag(tag);
                tag.put("type", (CharSequence)"xx");
            }
        };
        checkBox.setOutputMarkupId(true);
        return checkBox;
    }

    public static WebMarkupContainer container(String id) {
        WebMarkupContainer component = new WebMarkupContainer(id);
        component.setOutputMarkupId(true);
        return component;
    }

    public static WebMarkupContainer containerWithVisibility(String id, final SerializableBooleanSupplier isVisible) {
        WebMarkupContainer component = new WebMarkupContainer(id){
            private static final long serialVersionUID = 1L;

            public boolean isVisible() {
                return isVisible.getAsBoolean();
            }
        };
        component.setOutputMarkupId(true);
        return component;
    }

    public static WebMarkupContainer containerAdd(MarkupContainer container, String id) {
        return Wkt.add(container, Wkt.container(id));
    }

    public static ComponentTag cssAppend(ComponentTag tag, @Nullable String cssClass) {
        if (_Strings.isNotEmpty((CharSequence)cssClass)) {
            tag.append("class", (CharSequence)cssClass, " ");
        }
        return tag;
    }

    public static <T extends Component> T cssAppend(T component, @Nullable String cssClass) {
        if (_Strings.isNotEmpty((CharSequence)cssClass)) {
            component.add(new Behavior[]{new CssClassNameAppender(new String[]{cssClass})});
        }
        return component;
    }

    public static <T extends Component> T cssAppend(T component, @Nullable IModel<String> cssClassModel) {
        if (cssClassModel != null) {
            component.add(new Behavior[]{new CssClassNameAppender(cssClassModel)});
        }
        return component;
    }

    public static <T extends Component> T cssAppend(T component, Identifier identifier) {
        return Wkt.cssAppend(component, Wkt.cssNormalize(identifier));
    }

    public static <T extends Component> T cssReplace(T component, @Nullable String cssClass) {
        component.add(new Behavior[]{AttributeModifier.replace((String)"class", (Serializable)((Object)_Strings.nullToEmpty((String)cssClass)))});
        return component;
    }

    public static String cssNormalize(Identifier identifier) {
        StringBuilder sb = new StringBuilder();
        sb.append("isis-");
        sb.append(identifier.getLogicalType().getLogicalTypeName());
        if (_Strings.isNullOrEmpty((CharSequence)identifier.getMemberLogicalName())) {
            sb.append("-");
            sb.append(identifier.getMemberLogicalName());
        }
        return Wkt.cssNormalize(sb.toString());
    }

    public static String cssNormalize(String cssClass) {
        String trimmed = _Strings.blankToNullOrTrim((String)cssClass);
        return _Strings.isNullOrEmpty((CharSequence)trimmed) ? null : cssClass.replaceAll("\\.", "-").replaceAll("[^A-Za-z0-9- ]", "").replaceAll("\\s+", "-");
    }

    public static Fragment fragmentAddNoTab(MarkupContainer container, String id, String markupId) {
        return new Fragment(id, markupId, container){
            private static final long serialVersionUID = 1L;

            protected void onComponentTag(ComponentTag tag) {
                super.onComponentTag(tag);
                tag.put("tabindex", (CharSequence)"-1");
            }
        };
    }

    public static Image imageCachable(String id, ResourceReference imageResource) {
        return new Image(id, imageResource, new ResourceReference[0]){
            private static final long serialVersionUID = 1L;

            protected boolean shouldAddAntiCacheParameter() {
                return false;
            }
        };
    }

    public static Image imageAddCachable(MarkupContainer container, String id, ResourceReference imageResource) {
        return Wkt.add(container, Wkt.imageCachable(id, imageResource));
    }

    public static Label label(String id, String label) {
        return new Label(id, (Serializable)((Object)label));
    }

    public static Label label(String id, IModel<String> labelModel) {
        return new Label(id, labelModel);
    }

    public static Label labelNoTab(String id, IModel<String> labelModel) {
        return new Label(id, labelModel){
            private static final long serialVersionUID = 1L;

            protected void onComponentTag(ComponentTag tag) {
                super.onComponentTag(tag);
                tag.put("tabindex", (CharSequence)"-1");
            }
        };
    }

    public static <T> Label labelWithConverter(String id, IModel<T> model, final Class<T> type, final IConverter<T> converter) {
        return new Label(id, model){
            private static final long serialVersionUID = 1L;

            public <C> IConverter<C> getConverter(Class<C> cType) {
                return cType == type ? converter : super.getConverter(cType);
            }
        };
    }

    public static Label labelAdd(MarkupContainer container, String id, String label) {
        return Wkt.add(container, Wkt.label(id, label));
    }

    public static Label labelAdd(MarkupContainer container, String id, IModel<String> labelModel) {
        return Wkt.add(container, new Label(id, labelModel));
    }

    public static Label labelAddNoTab(MarkupContainer container, String id, IModel<String> labelModel) {
        return Wkt.add(container, Wkt.labelNoTab(id, labelModel));
    }

    public static <T> Label labelAddWithConverter(MarkupContainer container, String id, IModel<T> model, Class<T> type, IConverter<T> converter) {
        return Wkt.add(container, Wkt.labelWithConverter(id, model, type, converter));
    }

    public static AjaxLink<Void> link(String id, final SerializableConsumer<AjaxRequestTarget> onClick) {
        return new AjaxLink<Void>(id){
            private static final long serialVersionUID = 1L;

            public void onClick(AjaxRequestTarget target) {
                onClick.accept((Object)target);
            }

            protected void onComponentTag(ComponentTag tag) {
                super.onComponentTag(tag);
                Buttons.fixDisabledState((Component)this, (ComponentTag)tag);
            }
        };
    }

    public static AjaxLink<Void> linkAdd(MarkupContainer container, String id, SerializableConsumer<AjaxRequestTarget> onClick) {
        return Wkt.add(container, Wkt.link(id, onClick));
    }

    public static <T> ListView<T> listView(String id, List<T> list, final SerializableConsumer<ListItem<T>> itemPopulator) {
        return new ListView<T>(id, list){
            private static final long serialVersionUID = 1L;

            protected void populateItem(ListItem<T> item) {
                itemPopulator.accept(item);
            }
        };
    }

    public static <T> ListView<T> listView(String id, IModel<? extends List<T>> listModel, final SerializableConsumer<ListItem<T>> itemPopulator) {
        return new ListView<T>(id, listModel){
            private static final long serialVersionUID = 1L;

            protected void populateItem(ListItem<T> item) {
                itemPopulator.accept(item);
            }
        };
    }

    public static <T> ListView<T> listViewAdd(MarkupContainer container, String id, List<T> list, SerializableConsumer<ListItem<T>> itemPopulator) {
        return Wkt.add(container, Wkt.listView(id, list, itemPopulator));
    }

    public static <T> ListView<T> listViewAdd(MarkupContainer container, String id, IModel<? extends List<T>> listModel, SerializableConsumer<ListItem<T>> itemPopulator) {
        return Wkt.add(container, Wkt.listView(id, listModel, itemPopulator));
    }

    public static <T> Item<T> oddEvenItem(String id, int index, final IModel<T> model, final _Functions.SerializableFunction<T, String> cssClassProvider) {
        return new OddEvenItem<T>(id, index, model){
            private static final long serialVersionUID = 1L;

            protected void onComponentTag(ComponentTag tag) {
                super.onComponentTag(tag);
                Wkt.cssAppend(tag, (String)cssClassProvider.apply(model.getObject()));
            }
        };
    }

    public static TextArea<String> textAreaNoTab(String id, IModel<String> textModel) {
        return new TextArea<String>(id, textModel){
            private static final long serialVersionUID = 1L;

            protected void onComponentTag(ComponentTag tag) {
                super.onComponentTag(tag);
                tag.put("tabindex", (CharSequence)"-1");
            }
        };
    }

    public static TextArea<String> textAreaAddNoTab(MarkupContainer container, String id, IModel<String> textModel) {
        return Wkt.add(container, Wkt.textAreaNoTab(id, textModel));
    }

    public static <T> TextField<T> textFieldWithConverter(String id, IModel<T> model, final Class<T> type, final @Nullable IConverter<T> converter) {
        return converter != null ? new TextField<T>(id, model, type){
            private static final long serialVersionUID = 1L;

            public <C> IConverter<C> getConverter(Class<C> cType) {
                return cType == type ? converter : super.getConverter(cType);
            }

            public void error(IValidationError error) {
                if (error instanceof ValidationError) {
                    this.error((Serializable)((Object)((ValidationError)error).getMessage()));
                } else {
                    super.error(error);
                }
            }
        } : new TextField(id, model, type);
    }

    public static <T> TextField<T> passwordFieldWithConverter(String id, IModel<T> model, final Class<T> type, final @NonNull IConverter<T> converter) {
        if (converter == null) {
            throw new NullPointerException("converter is marked non-null but is null");
        }
        return new TextField<T>(id, model, type){
            private static final long serialVersionUID = 1L;

            public <C> IConverter<C> getConverter(Class<C> cType) {
                return cType == type ? converter : super.getConverter(cType);
            }

            public void error(IValidationError error) {
                if (error instanceof ValidationError) {
                    this.error((Serializable)((Object)((ValidationError)error).getMessage()));
                } else {
                    super.error(error);
                }
            }

            protected void onComponentTag(ComponentTag tag) {
                Attributes.set((ComponentTag)tag, (String)"type", (String)"password");
                super.onComponentTag(tag);
            }

            protected String[] getInputTypes() {
                return new String[]{"password"};
            }
        };
    }

    public static void focusOnMarkerAttribute(MarkupContainer container, AjaxRequestTarget target) {
        container.streamChildren().filter(child -> child.getMarkupAttributes().containsKey((Object)"data-isis-focus")).findFirst().ifPresent(child -> target.focusComponent(child));
    }

    public static void javaScriptAdd(AjaxRequestTarget target, EventTopic topic, String containerId) {
        target.appendJavaScript((CharSequence)Wkt.javaScriptFor(topic, containerId));
    }

    public static void javaScriptAdd(IHeaderResponse response, EventTopic topic, String containerId) {
        response.render((HeaderItem)OnDomReadyHeaderItem.forScript((CharSequence)Wkt.javaScriptFor(topic, containerId)));
    }

    private static String javaScriptFor(EventTopic topic, String containerId) {
        return _Strings.isNotEmpty((CharSequence)containerId) ? String.format("Wicket.Event.publish(Isis.Topic.%s, '%s')", topic.name(), containerId) : String.format("Wicket.Event.publish(Isis.Topic.%s)", topic.name());
    }

    private Wkt() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static enum EventTopic {
        FOCUS_FIRST_PROPERTY,
        FOCUS_FIRST_PARAMETER,
        OPEN_SELECT2,
        CLOSE_SELECT2;

    }

    private static class ReplaceDisabledTagWithReadonlyTagBehavior
    extends Behavior {
        private static final long serialVersionUID = 1L;

        private ReplaceDisabledTagWithReadonlyTagBehavior() {
        }

        public void onComponentTag(Component component, ComponentTag tag) {
            super.onComponentTag(component, tag);
            if (component.isEnabled()) {
                return;
            }
            tag.remove("disabled");
            tag.put("readonly", (CharSequence)"readonly");
        }
    }
}

