/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.util;

import java.io.Serializable;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.annotation.Nullable;
import lombok.NonNull;
import org.apache.isis.applib.services.i18n.TranslationService;
import org.apache.isis.commons.internal.base._Strings;
import org.apache.isis.core.metamodel.spec.feature.ObjectAction;
import org.apache.isis.viewer.common.model.decorator.confirm.ConfirmUiModel;
import org.apache.isis.viewer.common.model.decorator.icon.FontAwesomeUiModel;
import org.apache.isis.viewer.wicket.model.links.LinkAndLabel;
import org.apache.isis.viewer.wicket.ui.components.widgets.linkandlabel.ActionLink;
import org.apache.isis.viewer.wicket.ui.util.Decorators;
import org.apache.isis.viewer.wicket.ui.util.Tooltips;
import org.apache.isis.viewer.wicket.ui.util.Wkt;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.Page;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.link.AbstractLink;
import org.apache.wicket.markup.html.link.BookmarkablePageLink;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.request.mapper.parameter.PageParameters;

public final class WktLinks {
    public static <T extends Page> AbstractLink newBookmarkablePageLink(String linkId, PageParameters pageParameters, Class<T> pageClass) {
        return new BookmarkablePageLink(linkId, pageClass, pageParameters);
    }

    public static AbstractLink asAdditionalLink(String titleId, LinkAndLabel linkAndLabel) {
        AbstractLink link = linkAndLabel.getUiComponent();
        ObjectAction action = linkAndLabel.getManagedAction().getAction();
        Tooltips.addTooltip((Component)link, link instanceof ActionLink && _Strings.isNotEmpty((CharSequence)((ActionLink)link).getReasonDisabledIfAny()) ? ((ActionLink)link).getReasonDisabledIfAny() : (String)linkAndLabel.getDescription().orElse(null));
        if (ObjectAction.Util.returnsBlobOrClob((ObjectAction)action)) {
            Wkt.cssAppend(link, "noVeil");
        }
        if (action.isPrototype()) {
            Wkt.cssAppend(link, "prototype");
        }
        Wkt.cssAppend(link, linkAndLabel.getFeatureIdentifier());
        if (action.getSemantics().isAreYouSure()) {
            if (action.getParameterCount() == 0) {
                boolean hasDisabledReason;
                boolean bl = hasDisabledReason = link instanceof ActionLink ? _Strings.isNotEmpty((CharSequence)((ActionLink)link).getReasonDisabledIfAny()) : false;
                if (!hasDisabledReason) {
                    TranslationService translationService = linkAndLabel.getAction().getMetaModelContext().getTranslationService();
                    ConfirmUiModel confirmUiModel = ConfirmUiModel.ofAreYouSure((TranslationService)translationService, (ConfirmUiModel.Placement)ConfirmUiModel.Placement.BOTTOM);
                    Decorators.getConfirm().decorate((Component)link, confirmUiModel);
                }
            }
            Decorators.getDanger().decorate((Component)link);
        }
        linkAndLabel.getAdditionalCssClass().ifPresent(cssClass -> Wkt.cssAppend(link, cssClass));
        Label viewTitleLabel = Wkt.labelAdd((MarkupContainer)link, titleId, (IModel<String>)((IModel & Serializable)() -> ((LinkAndLabel)linkAndLabel).getFriendlyName()));
        Optional fontAwesome = linkAndLabel.getFontAwesomeUiModel();
        Decorators.getIcon().decorate((Component)viewTitleLabel, (Optional<FontAwesomeUiModel>)fontAwesome);
        Decorators.getMissingIcon().decorate((Component)viewTitleLabel, (Optional<FontAwesomeUiModel>)fontAwesome);
        return link;
    }

    public static <T, R extends MarkupContainer> R listItemAsDropdownLink(@NonNull ListItem<T> item, @NonNull R container, @NonNull String titleId, @NonNull Function<T, IModel<String>> titleProvider, @NonNull String iconId, @Nullable Function<T, IModel<String>> iconProvider, @Nullable BiFunction<T, Label, IModel<String>> cssFactory) {
        if (item == null) {
            throw new NullPointerException("item is marked non-null but is null");
        }
        if (container == null) {
            throw new NullPointerException("container is marked non-null but is null");
        }
        if (titleId == null) {
            throw new NullPointerException("titleId is marked non-null but is null");
        }
        if (titleProvider == null) {
            throw new NullPointerException("titleProvider is marked non-null but is null");
        }
        if (iconId == null) {
            throw new NullPointerException("iconId is marked non-null but is null");
        }
        Object t = item.getModelObject();
        Wkt.labelAdd(container, titleId, titleProvider.apply(t));
        Label viewItemIcon = Wkt.labelAdd(container, iconId, (IModel<String>)Optional.ofNullable(iconProvider).map(iconProv -> (IModel)iconProv.apply(t)).orElseGet(() -> Model.of((Serializable)((Object)""))));
        Optional.ofNullable(cssFactory).map(cssFact -> (IModel)cssFact.apply(t, viewItemIcon)).ifPresent(cssModel -> Wkt.cssAppend(viewItemIcon, (IModel<String>)cssModel));
        return container;
    }

    private WktLinks() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

