/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.rmi.value;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.io.Serializable;
import javax.jcr.Binary;
import javax.jcr.RepositoryException;

class SerializableBinary
implements Binary,
Serializable {
    private static final long serialVersionUID = -7742179594834275853L;
    private static final int BUFFER_SIZE = 65536;
    private transient long length = 0L;
    private transient byte[] data = null;
    private transient File file = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SerializableBinary(InputStream stream) throws IOException {
        OutputStream output = null;
        try {
            byte[] buffer = new byte[65536];
            int n = stream.read(buffer);
            while (n != -1) {
                this.length += (long)n;
                if (this.length < (long)buffer.length) {
                    n = stream.read(buffer, (int)this.length, buffer.length - (int)this.length);
                    continue;
                }
                if (this.file == null) {
                    this.file = File.createTempFile("jackrabbit-jcr-rmi-", null);
                    output = new FileOutputStream(this.file);
                    output.write(buffer);
                } else {
                    output.write(buffer, 0, n);
                }
                n = stream.read(buffer);
            }
            if (this.file == null) {
                this.data = new byte[(int)this.length];
                System.arraycopy(buffer, 0, this.data, 0, (int)this.length);
            }
        }
        finally {
            if (output != null) {
                output.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized int read(byte[] b, long position) throws RepositoryException {
        if (position < 0L || position >= this.length) {
            return -1;
        }
        if (this.data != null) {
            int n = Math.min(b.length, this.data.length - (int)position);
            System.arraycopy(this.data, (int)position, b, 0, n);
            return n;
        }
        if (this.file != null) {
            int n;
            RandomAccessFile random = new RandomAccessFile(this.file, "r");
            try {
                random.seek(position);
                n = random.read(b);
            }
            catch (Throwable throwable) {
                try {
                    random.close();
                    throw throwable;
                }
                catch (FileNotFoundException e) {
                    throw new RepositoryException("Binary file is missing", (Throwable)e);
                }
                catch (IOException e) {
                    throw new RepositoryException("Unable to read the binary", (Throwable)e);
                }
            }
            random.close();
            return n;
        }
        throw new IllegalStateException("This binary has been disposed");
    }

    public synchronized InputStream getStream() throws RepositoryException {
        if (this.data != null) {
            return new ByteArrayInputStream(this.data);
        }
        if (this.file != null) {
            try {
                return new FileInputStream(this.file);
            }
            catch (FileNotFoundException e) {
                throw new RepositoryException("Binary file is missing", (Throwable)e);
            }
        }
        throw new IllegalStateException("This binary has been disposed");
    }

    public long getSize() {
        return this.length;
    }

    public synchronized void dispose() {
        this.data = null;
        if (this.file != null) {
            this.file.delete();
            this.file = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void writeObject(ObjectOutputStream stream) throws IOException {
        stream.writeLong(this.length);
        if (this.data != null) {
            stream.write(this.data);
        } else if (this.file != null) {
            FileInputStream input = new FileInputStream(this.file);
            try {
                byte[] buffer = new byte[65536];
                int n = ((InputStream)input).read(buffer);
                while (n != -1) {
                    stream.write(buffer, 0, n);
                    n = ((InputStream)input).read(buffer);
                }
            }
            finally {
                ((InputStream)input).close();
            }
        } else {
            throw new IllegalStateException("This binary has been disposed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readObject(ObjectInputStream stream) throws IOException {
        this.length = stream.readLong();
        if (this.length <= 65536L) {
            this.data = new byte[(int)this.length];
            stream.readFully(this.data);
            this.file = null;
        } else {
            this.data = null;
            this.file = File.createTempFile("jackrabbit-jcr-rmi-", null);
            FileOutputStream output = new FileOutputStream(this.file);
            try {
                byte[] buffer = new byte[65536];
                long count = 0L;
                int n = stream.read(buffer);
                while (n != -1 && count < this.length) {
                    ((OutputStream)output).write(buffer, 0, n);
                    n = stream.read(buffer, 0, Math.min(buffer.length, (int)(this.length - (count += (long)n))));
                }
            }
            finally {
                ((OutputStream)output).close();
            }
        }
    }

    public void finalize() {
        this.dispose();
    }
}

