/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.test.api;

import java.security.AccessControlException;
import javax.jcr.LoginException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.jackrabbit.test.AbstractJCRTest;
import org.apache.jackrabbit.test.NotExecutableException;

public class ImpersonateTest
extends AbstractJCRTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testImpersonate() throws RepositoryException, NotExecutableException {
        Session session;
        try {
            session = this.superuser.impersonate(this.getHelper().getReadOnlyCredentials());
        }
        catch (LoginException e) {
            throw new NotExecutableException("impersonate threw LoginException");
        }
        try {
            String thePath = "";
            NodeIterator ni = session.getRootNode().getNodes();
            while (ni.hasNext()) {
                Node n = ni.nextNode();
                if (n.getPath().equals("/" + this.jcrSystem)) continue;
                thePath = n.getPath();
                break;
            }
            session.checkPermission(thePath, "read");
            try {
                session.checkPermission(thePath + "/" + this.nodeName1, "add_node");
                ImpersonateTest.fail((String)("add_node permission on \"" + thePath + "/" + this.nodeName1 + "\" granted to read-only Session"));
            }
            catch (AccessControlException accessControlException) {
                // empty catch block
            }
            try {
                session.checkPermission(thePath + "/" + this.propertyName1, "set_property");
                ImpersonateTest.fail((String)("set_property permission on \"" + thePath + "/" + this.propertyName1 + "\" granted to read-only Session"));
            }
            catch (AccessControlException accessControlException) {
                // empty catch block
            }
            try {
                session.checkPermission(thePath, "remove");
                ImpersonateTest.fail((String)("remove permission on \"" + thePath + "\" granted to read-only Session"));
            }
            catch (AccessControlException accessControlException) {
                // empty catch block
            }
        }
        finally {
            session.logout();
        }
    }
}

