/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.test.api;

import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import javax.jcr.version.VersionException;
import org.apache.jackrabbit.test.AbstractJCRTest;
import org.apache.jackrabbit.test.NotExecutableException;
import org.apache.jackrabbit.test.api.NodeMixinUtil;

public class NodeRemoveMixinTest
extends AbstractJCRTest {
    public void testRemoveSuccessfully() throws NotExecutableException, RepositoryException {
        Node node;
        Session session = this.testRootNode.getSession();
        String mixinName = NodeMixinUtil.getAddableMixinName(session, node = this.testRootNode.addNode(this.nodeName1, this.testNodeType));
        if (mixinName == null) {
            throw new NotExecutableException("No testable mixin node type found");
        }
        node.addMixin(mixinName);
        this.testRootNode.getSession().save();
        try {
            node.removeMixin(mixinName);
        }
        catch (ConstraintViolationException e) {
            throw new NotExecutableException("Repository does not support remove of mixin.");
        }
        try {
            Property mixinProps = node.getProperty(this.jcrMixinTypes);
            NodeRemoveMixinTest.assertTrue((String)("Node.removeMixin(String mixinName) did not remove mixin from property " + this.jcrMixinTypes + "."), (mixinProps.getValues().length == 0 ? 1 : 0) != 0);
        }
        catch (PathNotFoundException pathNotFoundException) {
            // empty catch block
        }
        this.testRootNode.getSession().save();
        NodeRemoveMixinTest.assertTrue((String)"removeMixin(String mixinName) did not remove mixin.", (node.getMixinNodeTypes().length == 0 ? 1 : 0) != 0);
    }

    public void testNotAssigned() throws NotExecutableException, RepositoryException {
        Node node;
        Session session = this.testRootNode.getSession();
        String mixinName = NodeMixinUtil.getAddableMixinName(session, node = this.testRootNode.addNode(this.nodeName1, this.testNodeType));
        if (mixinName == null) {
            throw new NotExecutableException("No testable mixin node type found");
        }
        node.addMixin(mixinName);
        this.testRootNode.getSession().save();
        String notAssignedMixin = NodeMixinUtil.getNotAssignedMixinName(session, node);
        if (notAssignedMixin == null) {
            throw new NotExecutableException("No testable mixin node type found");
        }
        try {
            node.removeMixin(notAssignedMixin);
            NodeRemoveMixinTest.fail((String)"Node.removeMixin(String mixinName) must throw a NoSuchNodeTypeException if Node does not have the specified mixin.");
        }
        catch (NoSuchNodeTypeException noSuchNodeTypeException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testLocked() throws ConstraintViolationException, NotExecutableException, RepositoryException {
        Session session = this.testRootNode.getSession();
        if (!this.isSupported("option.locking.supported")) {
            throw new NotExecutableException("Locking is not supported.");
        }
        Node node = this.testRootNode.addNode(this.nodeName1, this.testNodeType);
        this.ensureMixinType(node, this.mixLockable);
        this.testRootNode.getSession().save();
        String mixinName = NodeMixinUtil.getAddableMixinName(session, node);
        if (mixinName == null) {
            throw new NotExecutableException("No testable mixin node type found");
        }
        node.addMixin(mixinName);
        this.testRootNode.getSession().save();
        String pathRelToRoot = node.getPath().substring(1);
        Session session2 = this.getHelper().getSuperuserSession();
        try {
            Node node2 = session2.getRootNode().getNode(pathRelToRoot);
            node2.lock(true, true);
            try {
                node.removeMixin(mixinName);
                node.save();
                NodeRemoveMixinTest.fail((String)"Node.removeMixin(String mixinName) must throw a LockException if the node is locked.");
            }
            catch (LockException lockException) {
                // empty catch block
            }
            node2.unlock();
        }
        finally {
            session2.logout();
        }
    }

    public void testCheckedIn() throws ConstraintViolationException, NotExecutableException, RepositoryException {
        Session session = this.testRootNode.getSession();
        if (!this.isSupported("option.versioning.supported")) {
            throw new NotExecutableException("Versioning is not supported.");
        }
        Node node = this.testRootNode.addNode(this.nodeName1, this.testNodeType);
        this.ensureMixinType(node, this.mixVersionable);
        this.testRootNode.getSession().save();
        String mixinName = NodeMixinUtil.getAddableMixinName(session, node);
        if (mixinName == null || node.isNodeType(mixinName)) {
            throw new NotExecutableException("No testable mixin node type found");
        }
        node.addMixin(mixinName);
        this.testRootNode.getSession().save();
        node.checkin();
        try {
            node.removeMixin(mixinName);
            NodeRemoveMixinTest.fail((String)"Node.removeMixin(String mixinName) must throw a VersionException if the node is checked-in.");
        }
        catch (VersionException versionException) {
            // empty catch block
        }
    }
}

