/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.test.api;

import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.jackrabbit.test.AbstractJCRTest;

public class PropertyTypeTest
extends AbstractJCRTest {
    @Override
    protected void setUp() throws Exception {
        this.isReadOnly = true;
        super.setUp();
    }

    public void testType() throws RepositoryException {
        Session session = this.getHelper().getReadOnlySession();
        try {
            Node root = session.getRootNode().getNode(this.testPath);
            this.typeCheckChildren(root);
        }
        finally {
            session.logout();
        }
    }

    private void typeCheckChildren(Node parentNode) throws RepositoryException {
        NodeIterator nodes = parentNode.getNodes();
        while (nodes.hasNext()) {
            Node node = nodes.nextNode();
            PropertyIterator props = node.getProperties();
            while (props.hasNext()) {
                Property prop = props.nextProperty();
                int reqType = prop.getDefinition().getRequiredType();
                int type = 0;
                boolean isEmptyMultipleArray = false;
                if (prop.getDefinition().isMultiple()) {
                    if (prop.getValues().length > 0) {
                        type = prop.getValues()[0].getType();
                    } else {
                        isEmptyMultipleArray = true;
                    }
                } else {
                    type = prop.getValue().getType();
                }
                if (isEmptyMultipleArray || reqType == 0) continue;
                PropertyTypeTest.assertFalse((String)"The type of a property must not be UNDEFINED", (type == 0 ? 1 : 0) != 0);
                PropertyTypeTest.assertEquals((String)"The type of a property has to match the type of the property definition.", (int)type, (int)reqType);
            }
            this.typeCheckChildren(node);
        }
    }
}

