/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.test.api;

import javax.jcr.AccessDeniedException;
import javax.jcr.InvalidItemStateException;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.lock.LockException;
import javax.jcr.version.VersionException;
import org.apache.jackrabbit.test.AbstractJCRTest;
import org.apache.jackrabbit.test.NotExecutableException;

public class SessionRemoveItemTest
extends AbstractJCRTest {
    private Session adminSession;
    private Session readOnlySession;
    private Node removeNode;
    private String nPath;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.adminSession = this.superuser;
        this.readOnlySession = this.getHelper().getReadOnlySession();
        this.removeNode = this.testRootNode.addNode(this.nodeName1, this.testNodeType);
        this.testRootNode.getSession().save();
        this.nPath = this.removeNode.getPath();
    }

    @Override
    protected void tearDown() throws Exception {
        if (this.readOnlySession != null) {
            this.readOnlySession.logout();
        }
        super.tearDown();
    }

    public void testRemoveItem() throws RepositoryException {
        this.adminSession.removeItem(this.nPath);
        SessionRemoveItemTest.assertFalse((boolean)this.adminSession.nodeExists(this.nPath));
    }

    public void testRemoveItem2() throws RepositoryException {
        this.adminSession.removeItem(this.nPath);
        try {
            this.removeNode.getParent();
            SessionRemoveItemTest.fail((String)"Cannot retrieve the parent from a transiently removed item.");
        }
        catch (InvalidItemStateException invalidItemStateException) {
            // empty catch block
        }
    }

    public void testRemoveItem3() throws RepositoryException {
        this.adminSession.removeItem(this.nPath);
        this.readOnlySession.refresh(false);
        SessionRemoveItemTest.assertTrue((boolean)this.readOnlySession.nodeExists(this.nPath));
    }

    public void testRemoveItem4() throws RepositoryException {
        try {
            this.readOnlySession.refresh(false);
            this.readOnlySession.removeItem(this.nPath);
            this.readOnlySession.save();
            SessionRemoveItemTest.fail((String)"A read-only session must not be allowed to remove an item");
        }
        catch (AccessDeniedException accessDeniedException) {
            // empty catch block
        }
    }

    public void testRemoveLockedNode() throws RepositoryException, NotExecutableException {
        this.ensureLockingSupported();
        this.ensureMixinType(this.removeNode, this.mixLockable);
        this.removeNode.save();
        this.removeNode.lock(true, true);
        Session testSession = null;
        try {
            testSession = this.getHelper().getReadWriteSession();
            testSession.removeItem(this.nPath);
            testSession.save();
        }
        finally {
            if (testSession != null) {
                testSession.logout();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRemoveLockedChildItem() throws RepositoryException, NotExecutableException {
        Node childN = this.removeNode.addNode(this.nodeName2);
        Value v = this.getJcrValue(this.superuser, "propertyvalue2", "propertytype2", "propvalue2");
        Property childP = this.removeNode.setProperty(this.propertyName2, v);
        this.removeNode.save();
        this.ensureMixinType(this.removeNode, this.mixLockable);
        this.removeNode.save();
        this.removeNode.lock(true, true);
        Session testSession = null;
        try {
            testSession = this.getHelper().getReadWriteSession();
            try {
                testSession.removeItem(childN.getPath());
                testSession.save();
                SessionRemoveItemTest.fail((String)"Locked child node cannot be removed by another session.");
            }
            catch (LockException lockException) {
                // empty catch block
            }
            try {
                testSession.removeItem(childP.getPath());
                testSession.save();
                SessionRemoveItemTest.fail((String)"Locked child node cannot be removed by another session.");
            }
            catch (LockException lockException) {
                // empty catch block
            }
        }
        finally {
            if (testSession != null) {
                testSession.logout();
            }
            this.removeNode.unlock();
        }
    }

    public void testRemoveCheckedInItem() throws RepositoryException, NotExecutableException {
        Node childN = this.removeNode.addNode(this.nodeName2);
        Value v = this.getJcrValue(this.superuser, "propertyvalue2", "propertytype2", "propvalue2");
        Property childP = this.removeNode.setProperty(this.propertyName2, v);
        this.removeNode.save();
        this.ensureMixinType(this.removeNode, this.mixVersionable);
        this.removeNode.save();
        this.removeNode.checkin();
        try {
            this.adminSession.removeItem(childP.getPath());
            this.adminSession.save();
            SessionRemoveItemTest.fail((String)"child property of a checked-in node cannot be removed.");
        }
        catch (VersionException versionException) {
            // empty catch block
        }
        try {
            this.adminSession.removeItem(childN.getPath());
            this.adminSession.save();
            SessionRemoveItemTest.fail((String)"child node of a checked-in node cannot be removed.");
        }
        catch (VersionException versionException) {
            // empty catch block
        }
    }
}

