/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.test.api;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Calendar;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.version.VersionException;
import org.apache.jackrabbit.test.AbstractJCRTest;
import org.apache.jackrabbit.test.NotExecutableException;

public class SetValueVersionExceptionTest
extends AbstractJCRTest {
    private Session session;
    private Node node;
    private Property property;
    private Property multiProperty;
    private Value initialValue;
    private Value[] initialValues;
    private Value modifiedValue;
    private Value[] modifiedValues;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.session = this.getHelper().getReadOnlySession();
        this.initialValue = this.session.getValueFactory().createValue("abc");
        this.modifiedValue = this.session.getValueFactory().createValue("def");
        this.initialValues = new Value[]{this.initialValue};
        this.modifiedValues = new Value[]{this.initialValue, this.modifiedValue};
        if (!this.isSupported("option.versioning.supported")) {
            throw new NotExecutableException("Versioning is not supported.");
        }
        this.node = this.testRootNode.addNode(this.nodeName1, this.testNodeType);
        this.ensureMixinType(this.node, this.mixVersionable);
        this.property = this.node.setProperty(this.propertyName1, this.initialValue);
        this.multiProperty = this.node.setProperty(this.propertyName2, this.initialValues);
        this.testRootNode.getSession().save();
        this.node.checkin();
    }

    @Override
    protected void tearDown() throws Exception {
        try {
            this.superuser.refresh(false);
            this.node.checkout();
        }
        finally {
            if (this.session != null) {
                this.session.logout();
                this.session = null;
            }
            this.node = null;
            this.property = null;
            this.multiProperty = null;
            this.initialValue = null;
            this.initialValues = null;
            this.modifiedValue = null;
            this.modifiedValues = null;
            super.tearDown();
        }
    }

    public void testValue() throws RepositoryException {
        try {
            this.property.setValue(this.modifiedValue);
            this.node.save();
            SetValueVersionExceptionTest.fail((String)"Property.setValue(Value) must throw a VersionException immediately or on save if the parent node of this property is checked-in.");
        }
        catch (VersionException versionException) {
            // empty catch block
        }
    }

    public void testValueArray() throws RepositoryException {
        try {
            this.multiProperty.setValue(this.modifiedValues);
            this.node.save();
            SetValueVersionExceptionTest.fail((String)"Property.setValue(Value[]) must throw a VersionException immediately or on save if the parent node of this property is checked-in.");
        }
        catch (VersionException versionException) {
            // empty catch block
        }
    }

    public void testString() throws RepositoryException {
        try {
            this.property.setValue(this.modifiedValue.getString());
            this.node.save();
            SetValueVersionExceptionTest.fail((String)"Property.setValue(String) must throw a VersionException immediately or on save if the parent node of this property is checked-in.");
        }
        catch (VersionException versionException) {
            // empty catch block
        }
    }

    public void testStringArray() throws RepositoryException {
        try {
            String[] values = new String[]{};
            this.multiProperty.setValue(values);
            this.node.save();
            SetValueVersionExceptionTest.fail((String)"Property.setValue(String[]) must throw a VersionException immediately or on save if the parent node of this property is checked-in.");
        }
        catch (VersionException versionException) {
            // empty catch block
        }
    }

    public void testInputStream() throws RepositoryException {
        try {
            byte[] bytes = new byte[]{123};
            ByteArrayInputStream value = new ByteArrayInputStream(bytes);
            this.property.setValue((InputStream)value);
            this.node.save();
            SetValueVersionExceptionTest.fail((String)"Property.setValue(InputStream) must throw a VersionException immediately or on save if the parent node of this property is checked-in.");
        }
        catch (VersionException versionException) {
            // empty catch block
        }
    }

    public void testLong() throws RepositoryException {
        try {
            this.property.setValue(123L);
            this.node.save();
            SetValueVersionExceptionTest.fail((String)"Property.setValue(long) must throw a VersionException immediately or on save if the parent node of this property is checked-in.");
        }
        catch (VersionException versionException) {
            // empty catch block
        }
    }

    public void testDouble() throws RepositoryException {
        try {
            this.property.setValue(1.23);
            this.node.save();
            SetValueVersionExceptionTest.fail((String)"Property.setValue(double) must throw a VersionException immediately or on save if the parent node of this property is checked-in.");
        }
        catch (VersionException versionException) {
            // empty catch block
        }
    }

    public void testCalendar() throws RepositoryException {
        try {
            this.property.setValue(Calendar.getInstance());
            this.node.save();
            SetValueVersionExceptionTest.fail((String)"Property.setValue(Calendar) must throw a VersionException immediately or on save if the parent node of this property is checked-in.");
        }
        catch (VersionException versionException) {
            // empty catch block
        }
    }

    public void testBoolean() throws RepositoryException {
        try {
            this.property.setValue(true);
            this.node.save();
            SetValueVersionExceptionTest.fail((String)"Property.setValue(boolean) must throw a VersionException immediately or on save if the parent node of this property is checked-in.");
        }
        catch (VersionException versionException) {
            // empty catch block
        }
    }

    public void testNode() throws NotExecutableException, RepositoryException {
        String nodeType3 = this.getProperty("nodetype3");
        Node referenceableNode = nodeType3 == null ? this.testRootNode.addNode(this.nodeName3) : this.testRootNode.addNode(this.nodeName3, nodeType3);
        this.ensureMixinType(referenceableNode, this.mixReferenceable);
        this.testRootNode.getSession().save();
        String refPropName = this.getProperty("propertyname3");
        String nodeType = this.getProperty("nodetype2");
        Node node = this.testRootNode.addNode(this.nodeName4, nodeType);
        this.ensureMixinType(node, this.mixVersionable);
        this.ensureCanSetProperty(node, refPropName, node.getSession().getValueFactory().createValue(referenceableNode));
        Property property = node.setProperty(refPropName, referenceableNode);
        this.testRootNode.getSession().save();
        node.checkin();
        try {
            property.setValue(node);
            node.save();
            SetValueVersionExceptionTest.fail((String)"Property.setValue(Node) must throw a VersionException immediately or on save if the parent node of this property is checked-in.");
        }
        catch (VersionException versionException) {
            // empty catch block
        }
        this.superuser.refresh(false);
        node.checkout();
    }
}

