/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.test.api;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Calendar;
import javax.jcr.Binary;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.PropertyType;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import javax.jcr.ValueFormatException;
import org.apache.jackrabbit.test.AbstractJCRTest;
import org.apache.jackrabbit.test.NotExecutableException;
import org.apache.jackrabbit.test.api.util.InputStreamWrapper;

public class ValueFactoryTest
extends AbstractJCRTest {
    private Session session;
    private ValueFactory valueFactory;
    private static final boolean booleanValue = false;
    private Calendar dateValue = null;
    private static final double doubleValue = 3.1414926;
    private static final long longValue = Long.MAX_VALUE;
    private Node referenceNode = null;
    private static final String stringValue = "a string";
    private static String nameValue = "aName";
    private static String pathValue = "/a/Path[1]";
    private byte[] binaryValue = null;
    private String dateValueFail = nameValue;
    private static final String doubleValueFail = nameValue;
    private static final String longValueFail = nameValue;
    private static String nameValueFail;
    private static String pathValueFail;
    private static int[] types;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.session = this.getHelper().getReadWriteSession();
        try {
            this.valueFactory = this.session.getValueFactory();
        }
        catch (UnsupportedRepositoryOperationException e) {
            String message = "ValueFactory Test not executable: " + e.getMessage();
            throw new NotExecutableException(message);
        }
        nameValue = this.testRootNode.getName();
        pathValue = this.testRootNode.getPath();
        this.dateValue = Calendar.getInstance();
        this.binaryValue = this.createRandomString(10).getBytes();
        this.referenceNode = this.createReferenceableNode(this.nodeName1);
    }

    @Override
    protected void tearDown() throws Exception {
        if (this.session != null) {
            this.session.logout();
            this.session = null;
        }
        this.valueFactory = null;
        this.referenceNode = null;
        super.tearDown();
    }

    public Node createReferenceableNode(String name) throws RepositoryException {
        try {
            Node node = this.testRootNode.getNode(name);
            node.remove();
            this.session.save();
        }
        catch (PathNotFoundException node) {
            // empty catch block
        }
        Node n1 = this.testRootNode.addNode(name, this.testNodeType);
        if (n1.canAddMixin(this.mixReferenceable)) {
            n1.addMixin(this.mixReferenceable);
            this.testRootNode.getSession().save();
            return n1;
        }
        return null;
    }

    public void testValueType() throws RepositoryException {
        Value value = null;
        int type = -1;
        block13: for (int i = 0; i < types.length; ++i) {
            switch (types[i]) {
                case 2: {
                    try {
                        ByteArrayInputStream in = new ByteArrayInputStream(this.binaryValue);
                        value = this.valueFactory.createValue((InputStream)in);
                        this.session.save();
                        type = value.getType();
                        in.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    ValueFactoryTest.assertTrue((String)("Type of created value not correct: Expected: " + PropertyType.nameFromValue((int)2) + " but was: " + PropertyType.nameFromValue((int)type)), (2 == type ? 1 : 0) != 0);
                    continue block13;
                }
                case 6: {
                    value = this.valueFactory.createValue(false);
                    this.session.save();
                    type = value.getType();
                    ValueFactoryTest.assertTrue((String)("Type of created value not correct: Expected: " + PropertyType.nameFromValue((int)6) + " but was: " + PropertyType.nameFromValue((int)type)), (6 == type ? 1 : 0) != 0);
                    continue block13;
                }
                case 5: {
                    value = this.valueFactory.createValue(this.dateValue);
                    this.session.save();
                    type = value.getType();
                    ValueFactoryTest.assertTrue((String)("Type of created value not correct: Expected: " + PropertyType.nameFromValue((int)5) + " but was: " + PropertyType.nameFromValue((int)type)), (5 == type ? 1 : 0) != 0);
                    continue block13;
                }
                case 4: {
                    value = this.valueFactory.createValue(3.1414926);
                    this.session.save();
                    type = value.getType();
                    ValueFactoryTest.assertTrue((String)("Type of created value not correct: Expected: " + PropertyType.nameFromValue((int)4) + " but was: " + PropertyType.nameFromValue((int)type)), (4 == type ? 1 : 0) != 0);
                    continue block13;
                }
                case 3: {
                    value = this.valueFactory.createValue(Long.MAX_VALUE);
                    this.session.save();
                    type = value.getType();
                    ValueFactoryTest.assertTrue((String)("Type of created value not correct: Expected: " + PropertyType.nameFromValue((int)3) + " but was: " + PropertyType.nameFromValue((int)type)), (3 == type ? 1 : 0) != 0);
                    continue block13;
                }
                case 7: {
                    value = this.valueFactory.createValue(nameValue, 7);
                    this.session.save();
                    type = value.getType();
                    ValueFactoryTest.assertTrue((String)("Type of created value not correct: Expected: " + PropertyType.nameFromValue((int)7) + " but was: " + PropertyType.nameFromValue((int)type)), (7 == type ? 1 : 0) != 0);
                    continue block13;
                }
                case 8: {
                    value = this.valueFactory.createValue(pathValue, 8);
                    this.session.save();
                    type = value.getType();
                    ValueFactoryTest.assertTrue((String)("Type of created value not correct: Expected: " + PropertyType.nameFromValue((int)8) + " but was: " + PropertyType.nameFromValue((int)type)), (8 == type ? 1 : 0) != 0);
                    continue block13;
                }
                case 9: {
                    if (this.referenceNode == null) continue block13;
                    value = this.valueFactory.createValue(this.referenceNode);
                    this.session.save();
                    type = value.getType();
                    ValueFactoryTest.assertTrue((String)("Type of created value not correct: Expected: " + PropertyType.nameFromValue((int)9) + " but was: " + PropertyType.nameFromValue((int)type)), (9 == type ? 1 : 0) != 0);
                    ValueFactoryTest.assertEquals((String)"Reference value does not contain the UUID of the referenced node.", (String)this.referenceNode.getUUID(), (String)value.getString());
                    continue block13;
                }
                case 1: {
                    value = this.valueFactory.createValue(stringValue);
                    this.session.save();
                    type = value.getType();
                    ValueFactoryTest.assertTrue((String)("Type of created value not correct: Expected: " + PropertyType.nameFromValue((int)1) + " but was: " + PropertyType.nameFromValue((int)type)), (1 == type ? 1 : 0) != 0);
                }
            }
        }
    }

    public void testValueFormatException() throws RepositoryException {
        Value value = null;
        block17: for (int i = 0; i < types.length; ++i) {
            switch (types[i]) {
                case 5: {
                    try {
                        value = this.valueFactory.createValue(this.dateValueFail, 5);
                        ValueFactoryTest.fail((String)("Conversion from String " + this.dateValueFail + " to a " + PropertyType.nameFromValue((int)types[i]) + " value should throw ValueFormatException."));
                    }
                    catch (ValueFormatException valueFormatException) {}
                    continue block17;
                }
                case 4: {
                    try {
                        value = this.valueFactory.createValue(doubleValueFail, 4);
                        ValueFactoryTest.fail((String)("Conversion from String " + doubleValueFail + " to a " + PropertyType.nameFromValue((int)types[i]) + " value should throw ValueFormatException."));
                    }
                    catch (ValueFormatException valueFormatException) {}
                    continue block17;
                }
                case 3: {
                    try {
                        value = this.valueFactory.createValue(longValueFail, 3);
                        ValueFactoryTest.fail((String)("Conversion from String " + longValueFail + " to a " + PropertyType.nameFromValue((int)types[i]) + " value should throw ValueFormatException."));
                    }
                    catch (ValueFormatException valueFormatException) {}
                    continue block17;
                }
                case 7: {
                    try {
                        value = this.valueFactory.createValue(nameValueFail, 7);
                        ValueFactoryTest.fail((String)("Conversion from String " + nameValueFail + " to a " + PropertyType.nameFromValue((int)types[i]) + " value should throw ValueFormatException."));
                    }
                    catch (ValueFormatException valueFormatException) {}
                    continue block17;
                }
                case 8: {
                    try {
                        value = this.valueFactory.createValue(pathValueFail, 8);
                        ValueFactoryTest.fail((String)("Conversion from String " + pathValueFail + " to a " + PropertyType.nameFromValue((int)types[i]) + " value should throw ValueFormatException."));
                    }
                    catch (ValueFormatException valueFormatException) {}
                    continue block17;
                }
            }
        }
    }

    public void testInputStream() throws RepositoryException {
        InputStreamWrapper in = new InputStreamWrapper(new ByteArrayInputStream(this.binaryValue));
        this.valueFactory.createValue((InputStream)in);
        ValueFactoryTest.assertTrue((String)"ValueFactory.createValue(InputStream) is expected to close the passed input stream", (boolean)in.isClosed());
        in = new InputStreamWrapper(new ByteArrayInputStream(this.binaryValue));
        Binary bin = this.valueFactory.createBinary((InputStream)in);
        ValueFactoryTest.assertTrue((String)"ValueFactory.createBinary(InputStream) is expected to close the passed input stream", (boolean)in.isClosed());
        bin.dispose();
    }

    static {
        pathValueFail = nameValueFail = ";pre fix::name;";
        types = new int[]{5, 4, 3, 7, 8, 9, 1, 2, 6};
    }
}

