/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.test.api;

import javax.jcr.RepositoryException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.version.VersionException;
import org.apache.jackrabbit.test.NotExecutableException;
import org.apache.jackrabbit.test.api.AbstractWorkspaceVersionableTest;

public class WorkspaceCopyVersionableTest
extends AbstractWorkspaceVersionableTest {
    @Override
    protected String getOtherWorkspaceName() throws NotExecutableException {
        return this.workspace.getName();
    }

    @Override
    protected void initNodesW2() throws RepositoryException {
    }

    public void testCopyNodesVersionableAndCheckedIn() throws RepositoryException, NotExecutableException {
        String dstAbsPath = this.node1.getPath() + "/" + this.node2.getName();
        this.workspace.copy(this.node2.getPath(), dstAbsPath);
        try {
            this.addMixinVersionableToNode(this.testRootNode, this.node1);
            this.node1.checkin();
        }
        catch (ConstraintViolationException ex) {
            throw new NotExecutableException("server does not support making the parent versionable: " + ex.getMessage());
        }
        try {
            this.workspace.copy(this.node2.getPath(), dstAbsPath + "/" + this.node2.getName());
            WorkspaceCopyVersionableTest.fail((String)"Copying a node to a node's versionable and checked-in nearest ancestor node of destAbsPath should throw VersionException.");
        }
        catch (VersionException versionException) {
            // empty catch block
        }
        try {
            this.workspace.copy(this.node2.getPath(), this.node1.getPath() + "/" + this.node2.getName());
            WorkspaceCopyVersionableTest.fail((String)"Copying a node to a versionable and checked-in parent node of destAbsPath should throw VersionException.");
        }
        catch (VersionException versionException) {
            // empty catch block
        }
    }
}

