/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.test.api.nodetype;

import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.nodetype.NodeDefinition;
import javax.jcr.nodetype.NodeType;
import org.apache.jackrabbit.test.AbstractJCRTest;
import org.apache.jackrabbit.test.NotExecutableException;
import org.apache.jackrabbit.test.api.nodetype.NodeTypeUtil;

public class CanAddChildNodeCallWithoutNodeTypeTest
extends AbstractJCRTest {
    private Session session;

    @Override
    protected void setUp() throws Exception {
        this.isReadOnly = true;
        super.setUp();
        this.session = this.getHelper().getReadOnlySession();
    }

    @Override
    protected void tearDown() throws Exception {
        if (this.session != null) {
            this.session.logout();
            this.session = null;
        }
        super.tearDown();
    }

    public void testDefinedWithDefault() throws NotExecutableException, RepositoryException {
        NodeDefinition nodeDef = NodeTypeUtil.locateChildNodeDef(this.session, true, true, false);
        if (nodeDef == null) {
            throw new NotExecutableException("No child node def with defaultPrimaryType found");
        }
        NodeType nodeType = nodeDef.getDeclaringNodeType();
        CanAddChildNodeCallWithoutNodeTypeTest.assertTrue((String)"NodeType.canAddChildNode(String childNodeName) must return true if child node def 'childNodeName' defines a defaultPrimaryType.", (boolean)nodeType.canAddChildNode(nodeDef.getName()));
    }

    public void testDefinedWithoutDefault() throws NotExecutableException, RepositoryException {
        NodeDefinition nodeDef = NodeTypeUtil.locateChildNodeDef(this.session, true, false, false);
        if (nodeDef == null) {
            throw new NotExecutableException("No child node def without defaultPrimaryType found");
        }
        NodeType nodeType = nodeDef.getDeclaringNodeType();
        CanAddChildNodeCallWithoutNodeTypeTest.assertFalse((String)"NodeType.canAddChildNode(String childNodeName) must return false if child node def 'childNodeName' does not define a defaultPrimaryType.", (boolean)nodeType.canAddChildNode(nodeDef.getName()));
    }

    public void testUndefined() throws NotExecutableException, RepositoryException {
        NodeDefinition nodeDef = NodeTypeUtil.locateChildNodeDef(this.session, false, true, false);
        if (nodeDef == null) {
            throw new NotExecutableException("No testable node type found.");
        }
        NodeType nodeType = nodeDef.getDeclaringNodeType();
        String undefinedName = NodeTypeUtil.getUndefinedChildNodeName(nodeType);
        CanAddChildNodeCallWithoutNodeTypeTest.assertFalse((String)"NodeType.canAddChildNode(String childNodeName) must return false if 'childNodeName' is a undefined child node def", (boolean)nodeType.canAddChildNode(undefinedName));
    }

    public void testResidualWithDefault() throws NotExecutableException, RepositoryException {
        NodeDefinition nodeDef = NodeTypeUtil.locateChildNodeDef(this.session, true, true, true);
        if (nodeDef == null) {
            throw new NotExecutableException("No residual child node def without a defaultPrimaryType found.");
        }
        NodeType nodeType = nodeDef.getDeclaringNodeType();
        String undefinedName = NodeTypeUtil.getUndefinedChildNodeName(nodeType);
        CanAddChildNodeCallWithoutNodeTypeTest.assertTrue((String)"NodeType.canAddChildNode(String childNodeName) must return true for a not defined childNodeName if NodeType has a residual child node definition with a defaultPrimaryType", (boolean)nodeType.canAddChildNode(undefinedName));
    }

    public void testResidualWithoutDefault() throws NotExecutableException, RepositoryException {
        NodeDefinition nodeDef = NodeTypeUtil.locateChildNodeDef(this.session, true, false, true);
        if (nodeDef == null) {
            throw new NotExecutableException("No residual child node def with a defaultPrimaryType found.");
        }
        NodeType nodeType = nodeDef.getDeclaringNodeType();
        String undefinedName = NodeTypeUtil.getUndefinedChildNodeName(nodeType);
        CanAddChildNodeCallWithoutNodeTypeTest.assertFalse((String)"NodeType.canAddChildNode(String childNodeName) must return false for a not defiend childNodeName if NodeType has a residual child node definition without a defaultPrimaryType", (boolean)nodeType.canAddChildNode(undefinedName));
    }
}

