/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.test.api.nodetype;

import javax.jcr.RangeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.NodeTypeIterator;
import javax.jcr.nodetype.NodeTypeManager;
import org.apache.jackrabbit.test.AbstractJCRTest;

public class NodeTypeManagerTest
extends AbstractJCRTest {
    private NodeTypeManager manager;
    private Session session;

    @Override
    protected void setUp() throws Exception {
        this.isReadOnly = true;
        super.setUp();
        this.session = this.getHelper().getReadOnlySession();
        this.manager = this.session.getWorkspace().getNodeTypeManager();
    }

    @Override
    protected void tearDown() throws Exception {
        if (this.session != null) {
            this.session.logout();
            this.session = null;
        }
        this.manager = null;
        super.tearDown();
    }

    public void testGetNodeType() throws RepositoryException {
        NodeType type = this.manager.getAllNodeTypes().nextNodeType();
        NodeTypeManagerTest.assertEquals((String)"getNodeType(String nodeTypeName) does not return correct NodeType", (String)this.manager.getNodeType(type.getName()).getName(), (String)type.getName());
        StringBuffer notExistingName = new StringBuffer("X");
        NodeTypeIterator types = this.manager.getAllNodeTypes();
        while (types.hasNext()) {
            notExistingName.append(types.nextNodeType().getName());
        }
        try {
            this.manager.getNodeType(notExistingName.toString().replaceAll(":", ""));
            NodeTypeManagerTest.fail((String)"getNodeType(String nodeTypeName) must throw a NoSuchNodeTypeException if no according NodeType does exist");
        }
        catch (NoSuchNodeTypeException noSuchNodeTypeException) {
            // empty catch block
        }
    }

    public void testGetAllNodeTypes() throws RepositoryException {
        long sizeAll = this.getSize((RangeIterator)this.manager.getAllNodeTypes());
        long sizePrimary = this.getSize((RangeIterator)this.manager.getPrimaryNodeTypes());
        long sizeMixin = this.getSize((RangeIterator)this.manager.getMixinNodeTypes());
        NodeTypeManagerTest.assertEquals((String)"sizeAll() must return all primary and mixin node types:", (long)(sizePrimary + sizeMixin), (long)sizeAll);
    }

    public void testGetPrimaryNodeTypes() throws RepositoryException {
        NodeTypeIterator types = this.manager.getPrimaryNodeTypes();
        while (types.hasNext()) {
            NodeTypeManagerTest.assertFalse((String)"getPrimaryNodeTypes() must not return mixin node types", (boolean)types.nextNodeType().isMixin());
        }
    }

    public void testGetMixinNodeTypes() throws RepositoryException {
        NodeTypeIterator types = this.manager.getMixinNodeTypes();
        while (types.hasNext()) {
            NodeTypeManagerTest.assertTrue((String)"getMixinNodeTypes() must return exclusively mixin node types", (boolean)types.nextNodeType().isMixin());
        }
    }
}

