/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.test.api.observation;

import java.util.ArrayList;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.observation.Event;
import org.apache.jackrabbit.test.api.observation.AbstractObservationTest;
import org.apache.jackrabbit.test.api.observation.EventResult;

public class PropertyAddedTest
extends AbstractObservationTest {
    public void testSystemGenerated() throws RepositoryException {
        EventResult result = new EventResult(this.log);
        this.addEventListener(result, 4);
        this.testRootNode.addNode(this.nodeName1, this.testNodeType);
        this.testRootNode.getSession().save();
        Event[] events = result.getEvents(5000L);
        this.removeEventListener(result);
        ArrayList<String> paths = new ArrayList<String>();
        for (int i = 0; i < events.length; ++i) {
            paths.add(events[i].getPath());
        }
        String jcrPrimaryTypePath = this.testRoot + "/" + this.nodeName1 + "/" + this.jcrPrimaryType;
        PropertyAddedTest.assertTrue((String)"No event generated for jcr:primaryType.", (boolean)paths.contains(jcrPrimaryTypePath));
    }

    public void testSinglePropertyAdded() throws RepositoryException {
        Node foo = this.testRootNode.addNode(this.nodeName1, this.testNodeType);
        this.testRootNode.getSession().save();
        EventResult result = new EventResult(this.log);
        this.addEventListener(result, 4);
        foo.setProperty(this.propertyName1, "test content");
        this.testRootNode.getSession().save();
        Event[] events = result.getEvents(5000L);
        this.removeEventListener(result);
        this.checkPropertyAdded(events, new String[]{this.nodeName1 + "/" + this.propertyName1});
    }

    public void testMultiPropertyAdded() throws RepositoryException {
        Node foo = this.testRootNode.addNode(this.nodeName1, this.testNodeType);
        this.testRootNode.getSession().save();
        EventResult result = new EventResult(this.log);
        this.addEventListener(result, 4);
        foo.setProperty(this.propertyName1, "foo");
        foo.setProperty(this.propertyName2, "bar");
        this.testRootNode.getSession().save();
        Event[] events = result.getEvents(5000L);
        this.removeEventListener(result);
        this.checkPropertyAdded(events, new String[]{this.nodeName1 + "/" + this.propertyName1, this.nodeName1 + "/" + this.propertyName2});
    }
}

