/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.test.api.query.qom;

import java.util.ArrayList;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.query.qom.DescendantNodeJoinCondition;
import javax.jcr.query.qom.JoinCondition;
import javax.jcr.query.qom.QueryObjectModel;
import org.apache.jackrabbit.test.api.query.qom.AbstractJoinTest;

public class DescendantNodeJoinConditionTest
extends AbstractJoinTest {
    private Node n1;
    private Node n2;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.n1 = this.testRootNode.addNode(this.nodeName1, this.testNodeType);
        this.n2 = this.n1.addNode(this.nodeName2, this.testNodeType);
        this.ensureMixinType(this.n2, this.mixReferenceable);
        this.superuser.save();
    }

    public void testInnerJoin() throws RepositoryException {
        DescendantNodeJoinCondition c = this.qf.descendantNodeJoinCondition("left", "right");
        QueryObjectModel qom = this.createQuery("jcr.join.type.inner", (JoinCondition)c);
        this.checkQOM(qom, new Node[][]{{this.n2, this.n1}});
    }

    public void testRightOuterJoin() throws RepositoryException {
        DescendantNodeJoinCondition c = this.qf.descendantNodeJoinCondition("left", "right");
        QueryObjectModel qom = this.createQuery("jcr.join.type.right.outer", (JoinCondition)c);
        this.checkQOM(qom, new Node[][]{{this.n2, this.n1}, {null, this.n2}});
    }

    public void testLeftOuterJoin() throws RepositoryException {
        DescendantNodeJoinCondition c = this.qf.descendantNodeJoinCondition("left", "right");
        QueryObjectModel qom = this.createQuery("jcr.join.type.left.outer", (JoinCondition)c);
        ArrayList<Node[]> result = new ArrayList<Node[]>();
        result.add(new Node[]{this.n2, this.n1});
        Node n = this.testRootNode;
        while (true) {
            if (n.isNodeType(this.testNodeType)) {
                result.add(new Node[]{this.n1, n});
                result.add(new Node[]{this.n2, n});
            }
            if (n.getDepth() == 0) break;
            n = n.getParent();
        }
        if (result.size() == 1) {
            result.add(new Node[]{this.n1, null});
        }
        this.checkQOM(qom, (Node[][])result.toArray((T[])new Node[result.size()][]));
    }
}

