/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.test.api.retention;

import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.retention.RetentionManager;
import javax.jcr.retention.RetentionPolicy;
import org.apache.jackrabbit.test.AbstractJCRTest;
import org.apache.jackrabbit.test.NotExecutableException;

public abstract class AbstractRetentionTest
extends AbstractJCRTest {
    protected RetentionManager retentionMgr;
    protected String testNodePath;

    @Override
    protected void setUp() throws Exception {
        this.checkSupportedOption("option.retention.supported");
        super.setUp();
        try {
            this.retentionMgr = AbstractRetentionTest.getRetentionManager(this.superuser);
        }
        catch (NotExecutableException e) {
            this.cleanUp();
            throw e;
        }
        this.testNodePath = this.testRootNode.getPath();
    }

    protected String getHoldName() throws RepositoryException, NotExecutableException {
        String holdName = this.getProperty("holdname");
        if (holdName == null) {
            throw new NotExecutableException();
        }
        return holdName;
    }

    protected RetentionPolicy getApplicableRetentionPolicy() throws NotExecutableException, RepositoryException {
        return this.superuser.getRetentionManager().getRetentionPolicy(this.getProperty("retentionpolicyholder"));
    }

    protected static RetentionManager getRetentionManager(Session s) throws RepositoryException, NotExecutableException {
        try {
            return s.getRetentionManager();
        }
        catch (UnsupportedRepositoryOperationException e) {
            throw new NotExecutableException();
        }
    }
}

