/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.test.api.security;

import javax.jcr.AccessDeniedException;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import org.apache.jackrabbit.test.api.security.AbstractAccessControlTest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RSessionAccessControlTest
extends AbstractAccessControlTest {
    private static Logger log = LoggerFactory.getLogger(RSessionAccessControlTest.class);
    private Session readOnlySession;
    private String testNodePath;
    private String testPropertyPath;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        Node n = this.testRootNode.addNode(this.nodeName1, this.testNodeType);
        this.testNodePath = n.getPath();
        Value v = this.getJcrValue(this.superuser, "propertyvalue1", "propertytype1", "test");
        Property p = n.setProperty(this.propertyName1, v);
        this.testPropertyPath = p.getPath();
        this.testRootNode.getSession().save();
        this.readOnlySession = this.getHelper().getReadOnlySession();
    }

    @Override
    protected void tearDown() throws Exception {
        if (this.readOnlySession != null) {
            this.readOnlySession.logout();
        }
        super.tearDown();
    }

    public void testSetProperty() throws RepositoryException {
        Node n = (Node)this.readOnlySession.getItem(this.testNodePath);
        try {
            n.setProperty(this.propertyName1, "otherValue");
            n.save();
            RSessionAccessControlTest.fail((String)"A read only session must not be allowed to modify a property value");
        }
        catch (AccessDeniedException accessDeniedException) {
            // empty catch block
        }
    }

    public void testSetValue() throws RepositoryException {
        Property p = (Property)this.readOnlySession.getItem(this.testPropertyPath);
        try {
            p.setValue("otherValue");
            p.save();
            RSessionAccessControlTest.fail((String)"A read only session must not be allowed to modify a property value");
        }
        catch (AccessDeniedException accessDeniedException) {
            // empty catch block
        }
    }

    public void testDeleteNode() throws Exception {
        Node n = (Node)this.readOnlySession.getItem(this.testNodePath);
        try {
            n.remove();
            this.readOnlySession.save();
            RSessionAccessControlTest.fail((String)"A read only session must not be allowed to remove a node");
        }
        catch (AccessDeniedException accessDeniedException) {
            // empty catch block
        }
    }

    public void testDeleteProperty() throws Exception {
        Property p = (Property)this.readOnlySession.getItem(this.testPropertyPath);
        try {
            p.remove();
            this.readOnlySession.save();
            RSessionAccessControlTest.fail((String)"A read only session must not be allowed to remove a property.");
        }
        catch (AccessDeniedException accessDeniedException) {
            // empty catch block
        }
    }

    public void testMoveNode() throws Exception {
        Node n = (Node)this.readOnlySession.getItem(this.testNodePath);
        String destPath = this.testRootNode.getPath() + "/" + this.nodeName2;
        try {
            this.readOnlySession.move(n.getPath(), destPath);
            this.readOnlySession.save();
            RSessionAccessControlTest.fail((String)"A read only session must not be allowed to move a node");
        }
        catch (AccessDeniedException e) {
            log.debug(e.getMessage());
        }
    }

    public void testWorkspaceMoveNode() throws Exception {
        Node n = (Node)this.readOnlySession.getItem(this.testNodePath);
        String destPath = this.testRootNode.getPath() + "/" + this.nodeName2;
        try {
            this.readOnlySession.getWorkspace().move(n.getPath(), destPath);
            RSessionAccessControlTest.fail((String)"A read only session must not be allowed to move a node");
        }
        catch (AccessDeniedException e) {
            log.debug(e.getMessage());
        }
    }

    public void testCopyNode() throws Exception {
        Node n = (Node)this.readOnlySession.getItem(this.testNodePath);
        String destPath = this.testRootNode.getPath() + "/" + this.nodeName2;
        try {
            this.readOnlySession.getWorkspace().copy(n.getPath(), destPath);
            RSessionAccessControlTest.fail((String)"A read only session must not be allowed to copy a node");
        }
        catch (AccessDeniedException e) {
            log.debug(e.getMessage());
        }
    }
}

