/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.test.api.version;

import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Workspace;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.NodeTypeManager;
import org.apache.jackrabbit.test.AbstractJCRTest;
import org.apache.jackrabbit.test.NotExecutableException;

public abstract class AbstractMergeTest
extends AbstractJCRTest {
    private static final String PROP_VERSIONABLE_NODE_TYPE = "versionableNodeType";
    protected String versionableNodeType;
    protected String nonVersionableNodeType;
    protected Session superuserW2;
    protected Workspace workspace;
    protected Workspace workspaceW2;
    protected Node testRootNodeW2;
    protected static final String CHANGED_STRING = "changed";

    @Override
    protected void setUp() throws Exception {
        NodeType nvNt;
        NodeType vNt;
        super.setUp();
        super.checkSupportedOption("option.versioning.supported");
        NodeTypeManager ntm = this.superuser.getWorkspace().getNodeTypeManager();
        this.versionableNodeType = this.getProperty(PROP_VERSIONABLE_NODE_TYPE);
        if (this.versionableNodeType == null) {
            AbstractMergeTest.fail((String)"Property 'versionableNodeType' is not defined.");
        }
        if (!(vNt = ntm.getNodeType(this.versionableNodeType)).isNodeType(this.mixVersionable)) {
            AbstractMergeTest.fail((String)"Property 'versionableNodeType' does not define a versionable nodetype.");
        }
        this.nonVersionableNodeType = this.testNodeType;
        if (this.nonVersionableNodeType == null) {
            AbstractMergeTest.fail((String)("Property '" + this.testNodeType + "' is not defined."));
        }
        if ((nvNt = ntm.getNodeType(this.nonVersionableNodeType)).isNodeType(this.mixVersionable)) {
            AbstractMergeTest.fail((String)("Property '" + this.testNodeType + "' does define a versionable nodetype."));
        }
        this.superuserW2 = this.getHelper().getSuperuserSession(this.workspaceName);
        this.workspace = this.superuser.getWorkspace();
        this.workspaceW2 = this.superuserW2.getWorkspace();
        this.testRootNodeW2 = this.cleanUpTestRoot(this.superuserW2);
        this.initNodes();
    }

    @Override
    protected void tearDown() throws Exception {
        if (this.superuserW2 != null) {
            try {
                if (!this.isReadOnly) {
                    this.cleanUpTestRoot(this.superuserW2);
                }
            }
            finally {
                this.superuserW2.logout();
                this.superuserW2 = null;
            }
        }
        this.workspace = null;
        this.workspaceW2 = null;
        this.testRootNodeW2 = null;
        super.tearDown();
    }

    abstract void initNodes() throws RepositoryException, NotExecutableException;
}

