/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.test.api.version;

import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.version.VersionManager;
import org.apache.jackrabbit.test.NotExecutableException;
import org.apache.jackrabbit.test.api.version.AbstractMergeTest;

public class MergeActivityTest
extends AbstractMergeTest {
    String newValue;
    Node activityNode;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    @Override
    protected void tearDown() throws Exception {
        if (this.activityNode != null) {
            this.superuser.getWorkspace().getVersionManager().removeActivity(this.activityNode);
            this.activityNode = null;
        }
        super.tearDown();
    }

    public void testMergeActivity() throws RepositoryException {
        String p1 = this.testRootNodeW2.getProperty(this.nodeName1 + "/" + this.propertyName1).getString();
        String p2 = this.testRootNodeW2.getProperty(this.nodeName2 + "/" + this.propertyName1).getString();
        MergeActivityTest.assertEquals((String)"Cloned node has wrong property on node 1.", (String)this.nodeName1, (String)p1);
        MergeActivityTest.assertEquals((String)"Cloned node has wrong property on node 2.", (String)this.nodeName2, (String)p2);
        VersionManager vm2 = this.testRootNodeW2.getSession().getWorkspace().getVersionManager();
        NodeIterator iter = vm2.merge(this.activityNode);
        if (iter.hasNext()) {
            StringBuffer failed = new StringBuffer();
            while (iter.hasNext()) {
                failed.append(iter.nextNode().getPath());
                failed.append(", ");
            }
            MergeActivityTest.fail((String)("Merge must not fail. failed nodes: " + failed));
            return;
        }
        p1 = this.testRootNodeW2.getProperty(this.nodeName1 + "/" + this.propertyName1).getString();
        p2 = this.testRootNodeW2.getProperty(this.nodeName2 + "/" + this.propertyName1).getString();
        MergeActivityTest.assertEquals((String)"Activity merge did not restore property on node 1.", (String)this.newValue, (String)p1);
        MergeActivityTest.assertEquals((String)"Activity merge did not restore property on node 2.", (String)this.newValue, (String)p2);
    }

    @Override
    protected void initNodes() throws RepositoryException, NotExecutableException {
        this.checkSupportedOption("option.activities.supported");
        VersionManager versionManager = this.testRootNode.getSession().getWorkspace().getVersionManager();
        Node node1 = this.testRootNode.addNode(this.nodeName1, this.versionableNodeType);
        node1.setProperty(this.propertyName1, this.nodeName1);
        String path1 = node1.getPath();
        Node node2 = this.testRootNode.addNode(this.nodeName2, this.versionableNodeType);
        node2.setProperty(this.propertyName1, this.nodeName2);
        String path2 = node2.getPath();
        this.testRootNode.getSession().save();
        versionManager.checkin(path1);
        versionManager.checkin(path2);
        this.log.println("test nodes created successfully on " + this.workspace.getName());
        this.workspaceW2.clone(this.workspace.getName(), path1, path1, true);
        this.workspaceW2.clone(this.workspace.getName(), path2, path2, true);
        this.testRootNodeW2 = (Node)this.superuserW2.getItem(this.testRoot);
        this.activityNode = versionManager.createActivity("foobar");
        versionManager.setActivity(this.activityNode);
        versionManager.checkout(path1);
        versionManager.checkout(path2);
        this.newValue = String.valueOf(System.currentTimeMillis());
        node1.setProperty(this.propertyName1, this.newValue);
        node2.setProperty(this.propertyName1, this.newValue);
        this.testRootNode.getSession().save();
        versionManager.checkin(path1);
        versionManager.checkin(path2);
    }
}

