/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.test.api.version;

import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.version.VersionManager;
import org.apache.jackrabbit.test.api.version.AbstractMergeTest;

public class MergeShallowTest
extends AbstractMergeTest {
    Node nodeToMerge;
    String newValue;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.nodeToMerge = this.testRootNodeW2.getNode(this.nodeName1);
    }

    @Override
    protected void tearDown() throws Exception {
        this.nodeToMerge = null;
        super.tearDown();
    }

    public void testMergeRecursive() throws RepositoryException {
        VersionManager vm2 = this.testRootNodeW2.getSession().getWorkspace().getVersionManager();
        NodeIterator iter = vm2.merge(this.nodeToMerge.getPath(), this.superuser.getWorkspace().getName(), true, false);
        if (iter.hasNext()) {
            StringBuffer failed = new StringBuffer();
            while (iter.hasNext()) {
                failed.append(iter.nextNode().getPath());
                failed.append(", ");
            }
            MergeShallowTest.fail((String)("Merge must not fail. failed nodes: " + failed));
            return;
        }
        String p1 = this.nodeToMerge.getProperty(this.propertyName1).getString();
        String p2 = this.nodeToMerge.getProperty(this.nodeName2 + "/" + this.propertyName1).getString();
        MergeShallowTest.assertEquals((String)"Recursive merge did not restore property on level 1.", (String)this.newValue, (String)p1);
        MergeShallowTest.assertEquals((String)"Recursive merge did not restore property on level 2.", (String)this.newValue, (String)p2);
    }

    public void testMergeShallow() throws RepositoryException {
        String oldP2 = this.nodeToMerge.getProperty(this.nodeName2 + "/" + this.propertyName1).getString();
        VersionManager vm2 = this.testRootNodeW2.getSession().getWorkspace().getVersionManager();
        NodeIterator iter = vm2.merge(this.nodeToMerge.getPath(), this.superuser.getWorkspace().getName(), true, true);
        if (iter.hasNext()) {
            StringBuffer failed = new StringBuffer();
            while (iter.hasNext()) {
                failed.append(iter.nextNode().getPath());
                failed.append(", ");
            }
            MergeShallowTest.fail((String)("Merge must not fail. failed nodes: " + failed));
            return;
        }
        String p1 = this.nodeToMerge.getProperty(this.propertyName1).getString();
        String p2 = this.nodeToMerge.getProperty(this.nodeName2 + "/" + this.propertyName1).getString();
        MergeShallowTest.assertEquals((String)"Shallow merge did not restore property on level 1.", (String)this.newValue, (String)p1);
        MergeShallowTest.assertEquals((String)"Shallow merge did restore property on level 2.", (String)oldP2, (String)p2);
    }

    @Override
    protected void initNodes() throws RepositoryException {
        VersionManager versionManager = this.testRootNode.getSession().getWorkspace().getVersionManager();
        Node topVNode = this.testRootNode.addNode(this.nodeName1, this.versionableNodeType);
        topVNode.setProperty(this.propertyName1, topVNode.getName());
        String path = topVNode.getPath();
        Node subNvNode = topVNode.addNode(this.nodeName2, this.versionableNodeType);
        subNvNode.setProperty(this.propertyName1, subNvNode.getName());
        String path2 = subNvNode.getPath();
        this.testRootNode.getSession().save();
        versionManager.checkin(path);
        versionManager.checkin(path2);
        this.log.println("test nodes created successfully on " + this.workspace.getName());
        this.workspaceW2.clone(this.workspace.getName(), topVNode.getPath(), topVNode.getPath(), true);
        this.log.println(topVNode.getPath() + " cloned on " + this.superuserW2.getWorkspace().getName() + " at " + topVNode.getPath());
        this.testRootNodeW2 = (Node)this.superuserW2.getItem(this.testRoot);
        versionManager.checkout(path);
        versionManager.checkout(path2);
        this.newValue = String.valueOf(System.currentTimeMillis());
        Node n1 = this.testRootNode.getNode(this.nodeName1);
        n1.setProperty(this.propertyName1, this.newValue);
        Node n2 = n1.getNode(this.nodeName2);
        n2.setProperty(this.propertyName1, this.newValue);
        this.testRootNode.getSession().save();
        VersionManager vm1 = this.testRootNode.getSession().getWorkspace().getVersionManager();
        vm1.checkpoint(n2.getPath());
        vm1.checkpoint(n1.getPath());
    }
}

