/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.test.api.version;

import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.version.VersionManager;
import org.apache.jackrabbit.test.api.version.AbstractMergeTest;

public class MergeSubNodeTest
extends AbstractMergeTest {
    Node nodeToMerge;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.nodeToMerge = this.testRootNodeW2.getNode(this.nodeName1);
        VersionManager versionManager = this.nodeToMerge.getSession().getWorkspace().getVersionManager();
        versionManager.checkout(this.nodeToMerge.getPath());
    }

    @Override
    protected void tearDown() throws Exception {
        this.nodeToMerge = null;
        super.tearDown();
    }

    public void disable_testRemoveNodeFromSourceWorkspaceAndMergeWithUpdate() throws RepositoryException {
        this.nodeToMerge.checkin();
        this.nodeToMerge.checkout();
        Node originalNode = this.testRootNode.getNode(this.nodeName1);
        Node originalSubNode = originalNode.getNode(this.nodeName2);
        originalSubNode.checkout();
        originalSubNode.checkin();
        this.nodeToMerge.merge(this.workspace.getName(), false);
        MergeSubNodeTest.assertFalse((String)("subNode1 not removed from " + this.workspaceW2.getName() + " as expected"), (boolean)this.nodeToMerge.hasNode(this.nodeName2));
        String originalBaseVersionUUID = originalNode.getBaseVersion().getUUID();
        String clonedBaseVersionUUID = this.nodeToMerge.getBaseVersion().getUUID();
        MergeSubNodeTest.assertTrue((String)"clonedNode has different version UUID than expected, it should be updated with the newNode version UUID", (boolean)originalBaseVersionUUID.equals(clonedBaseVersionUUID));
    }

    public void disable_testRemoveNodeFromSourceWorkspaceAndMergeWithUpdateJcr2() throws RepositoryException {
        VersionManager versionManager = this.nodeToMerge.getSession().getWorkspace().getVersionManager();
        String path = this.nodeToMerge.getPath();
        versionManager.checkin(path);
        versionManager.checkout(path);
        Node originalNode = this.testRootNode.getNode(this.nodeName1);
        Node originalSubNode = originalNode.getNode(this.nodeName2);
        VersionManager originalVersionManager = originalSubNode.getSession().getWorkspace().getVersionManager();
        String originalSubPath = originalSubNode.getPath();
        originalVersionManager.checkout(originalSubPath);
        originalVersionManager.checkin(originalSubPath);
        versionManager.merge(path, this.workspace.getName(), false);
        MergeSubNodeTest.assertFalse((String)("subNode1 not removed from " + this.workspaceW2.getName() + " as expected"), (boolean)this.nodeToMerge.hasNode(this.nodeName2));
        String originalBaseVersionId = originalVersionManager.getBaseVersion(originalNode.getPath()).getIdentifier();
        String clonedBaseVersionId = versionManager.getBaseVersion(path).getIdentifier();
        MergeSubNodeTest.assertTrue((String)"clonedNode has different version UUID than expected, it should be updated with the newNode version UUID", (boolean)originalBaseVersionId.equals(clonedBaseVersionId));
    }

    public void disable_testMergeNodeFromUpdatedSourceWorkspace() throws RepositoryException {
        Node originalNode = this.testRootNode.getNode(this.nodeName1);
        originalNode.checkout();
        originalNode.checkin();
        this.testRootNode.getSession().save();
        this.nodeToMerge.merge(this.workspace.getName(), false);
        String originalBaseVersionUUID = originalNode.getBaseVersion().getUUID();
        String clonedBaseVersionUUID = this.nodeToMerge.getBaseVersion().getUUID();
        MergeSubNodeTest.assertTrue((String)"clonedNode has different version UUID than expected, it should be updated with the newNode version UUID", (boolean)originalBaseVersionUUID.equals(clonedBaseVersionUUID));
    }

    public void disable_testMergeNodeFromUpdatedSourceWorkspaceJcr2() throws RepositoryException {
        Node originalNode = this.testRootNode.getNode(this.nodeName1);
        VersionManager originalVersionManager = originalNode.getSession().getWorkspace().getVersionManager();
        String originalPath = originalNode.getPath();
        originalVersionManager.checkout(originalPath);
        originalVersionManager.checkin(originalPath);
        this.testRootNode.getSession().save();
        VersionManager versionManager = this.nodeToMerge.getSession().getWorkspace().getVersionManager();
        String path = this.nodeToMerge.getPath();
        versionManager.merge(path, this.workspace.getName(), false);
        String originalBaseVersionId = originalVersionManager.getBaseVersion(originalPath).getIdentifier();
        String clonedBaseVersionId = versionManager.getBaseVersion(path).getIdentifier();
        MergeSubNodeTest.assertTrue((String)"clonedNode has different version UUID than expected, it should be updated with the newNode version UUID", (boolean)originalBaseVersionId.equals(clonedBaseVersionId));
    }

    public void testMergeNodeFromOlderSourceWorkspace() throws RepositoryException {
        this.nodeToMerge.checkin();
        this.nodeToMerge.checkout();
        String baseVersionUUIDbeforeMerge = this.nodeToMerge.getBaseVersion().getUUID();
        this.nodeToMerge.merge(this.workspace.getName(), false);
        MergeSubNodeTest.assertTrue((String)"clonedNode has different UUID than expected, it should be left unchanged", (boolean)baseVersionUUIDbeforeMerge.equals(this.nodeToMerge.getBaseVersion().getUUID()));
    }

    public void testMergeNodeFromOlderSourceWorkspaceJcr2() throws RepositoryException {
        VersionManager versionManager = this.nodeToMerge.getSession().getWorkspace().getVersionManager();
        String path = this.nodeToMerge.getPath();
        versionManager.checkin(path);
        versionManager.checkout(path);
        String baseVersionIdbeforeMerge = versionManager.getBaseVersion(path).getIdentifier();
        versionManager.merge(path, this.workspace.getName(), false);
        MergeSubNodeTest.assertTrue((String)"clonedNode has different UUID than expected, it should be left unchanged", (boolean)baseVersionIdbeforeMerge.equals(versionManager.getBaseVersion(path).getIdentifier()));
    }

    public void disable_testMergeNodeBestEffortTrue() throws RepositoryException {
        Node originalNode = this.testRootNode.getNode(this.nodeName1);
        originalNode.checkout();
        Node subNode = originalNode.getNode(this.nodeName2);
        subNode.checkout();
        subNode.setProperty(this.propertyName1, "changed");
        originalNode.setProperty(this.propertyName1, "changed");
        this.superuser.save();
        subNode.checkin();
        originalNode.checkin();
        Node subNodeW2 = this.nodeToMerge.getNode(this.nodeName2);
        subNodeW2.checkout();
        subNodeW2.setProperty(this.propertyName1, "changed");
        this.superuserW2.save();
        subNodeW2.checkin();
        this.nodeToMerge.checkout();
        this.nodeToMerge.merge(this.workspace.getName(), true);
        MergeSubNodeTest.assertTrue((boolean)subNodeW2.getProperty(this.propertyName1).getString().equals(""));
        MergeSubNodeTest.assertFalse((boolean)this.nodeToMerge.getProperty(this.propertyName1).getString().equals(this.nodeToMerge.getName()));
    }

    public void disable_testMergeNodeBestEffortTrueJcr2() throws RepositoryException {
        Node originalNode = this.testRootNode.getNode(this.nodeName1);
        VersionManager originalVersionManager = originalNode.getSession().getWorkspace().getVersionManager();
        String originalPath = originalNode.getPath();
        originalVersionManager.checkout(originalPath);
        Node subNode = originalNode.getNode(this.nodeName2);
        originalVersionManager.checkout(subNode.getPath());
        subNode.setProperty(this.propertyName1, "changed");
        originalNode.setProperty(this.propertyName1, "changed");
        this.superuser.save();
        originalVersionManager.checkin(subNode.getPath());
        originalVersionManager.checkin(originalPath);
        VersionManager versionManager = this.nodeToMerge.getSession().getWorkspace().getVersionManager();
        Node subNodeW2 = this.nodeToMerge.getNode(this.nodeName2);
        versionManager.checkout(subNodeW2.getPath());
        subNodeW2.setProperty(this.propertyName1, "changed");
        this.superuserW2.save();
        versionManager.checkin(subNodeW2.getPath());
        versionManager.checkout(this.nodeToMerge.getPath());
        versionManager.merge(this.nodeToMerge.getPath(), this.workspace.getName(), true);
        MergeSubNodeTest.assertTrue((boolean)subNodeW2.getProperty(this.propertyName1).getString().equals(""));
        MergeSubNodeTest.assertFalse((boolean)this.nodeToMerge.getProperty(this.propertyName1).getString().equals(this.nodeToMerge.getName()));
    }

    public void disable_testMergeNodeSubNodesMergeTest() throws RepositoryException {
        this.nodeToMerge.checkout();
        this.nodeToMerge.merge(this.workspace.getName(), true);
        NodeIterator ni = this.nodeToMerge.getNodes();
        while (ni.hasNext()) {
            Node n = ni.nextNode();
            if (n.getBaseVersion() == null) continue;
            MergeSubNodeTest.assertTrue((boolean)n.getProperty(this.propertyName1).getString().equals("changed"));
        }
    }

    public void disable_testMergeNodeSubNodesMergeTestJcr2() throws RepositoryException {
        VersionManager versionManager = this.nodeToMerge.getSession().getWorkspace().getVersionManager();
        String path = this.nodeToMerge.getPath();
        versionManager.checkout(path);
        versionManager.merge(path, this.workspace.getName(), true);
        NodeIterator ni = this.nodeToMerge.getNodes();
        while (ni.hasNext()) {
            Node n = ni.nextNode();
            if (versionManager.getBaseVersion(n.getPath()) == null) continue;
            MergeSubNodeTest.assertTrue((boolean)n.getProperty(this.propertyName1).getString().equals("changed"));
        }
    }

    @Override
    protected void initNodes() throws RepositoryException {
        Node topVNode = this.testRootNode.addNode(this.nodeName1, this.versionableNodeType);
        topVNode.setProperty(this.propertyName1, topVNode.getName());
        Node subNvNode = topVNode.addNode(this.nodeName2, this.versionableNodeType);
        subNvNode.setProperty(this.propertyName1, subNvNode.getName());
        this.testRootNode.getSession().save();
        this.log.println("test nodes created successfully on " + this.workspace.getName());
        this.workspaceW2.clone(this.workspace.getName(), topVNode.getPath(), topVNode.getPath(), true);
        this.log.println(topVNode.getPath() + " cloned on " + this.superuserW2.getWorkspace().getName() + " at " + topVNode.getPath());
        this.testRootNodeW2 = (Node)this.superuserW2.getItem(this.testRoot);
    }
}

