/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.test.api.version.simple;

import javax.jcr.InvalidItemStateException;
import javax.jcr.Item;
import javax.jcr.RepositoryException;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.version.Version;
import javax.jcr.version.VersionManager;
import org.apache.jackrabbit.test.api.version.simple.AbstractVersionTest;

public class CheckinTest
extends AbstractVersionTest {
    @Override
    protected void setUp() throws Exception {
        super.setUp();
        try {
            VersionManager versionManager = this.versionableNode.getSession().getWorkspace().getVersionManager();
            String path = this.versionableNode.getPath();
            versionManager.checkout(path);
        }
        catch (RepositoryException e) {
            this.cleanUp();
            throw e;
        }
    }

    public void testIsCheckedOut() throws RepositoryException {
        this.versionableNode.checkin();
        CheckinTest.assertTrue((String)"After calling Node.checkin() on a versionable node N, N.isCheckedOut() must return false", (!this.versionableNode.isCheckedOut() ? 1 : 0) != 0);
    }

    public void testIsCheckedOutJcr2() throws RepositoryException {
        VersionManager versionManager = this.versionableNode.getSession().getWorkspace().getVersionManager();
        String path = this.versionableNode.getPath();
        versionManager.checkin(path);
        CheckinTest.assertTrue((String)"VersionManager.isCheckedOut(P) must return false if the path P resolves to a checked-in node.", (!versionManager.isCheckedOut(path) ? 1 : 0) != 0);
    }

    public void testMultipleCheckinHasNoEffect() throws RepositoryException {
        Version v = this.versionableNode.checkin();
        try {
            Version v2 = this.versionableNode.checkin();
            CheckinTest.assertTrue((String)"Calling checkin() on a node that is already checked-in must not have an effect.", (boolean)v.isSame((Item)v2));
        }
        catch (RepositoryException e) {
            CheckinTest.fail((String)"Calling checkin() on a node that is already checked-in must not throw an exception.");
        }
    }

    public void testMultipleCheckinHasNoEffectJcr2() throws RepositoryException {
        VersionManager versionManager = this.versionableNode.getSession().getWorkspace().getVersionManager();
        String path = this.versionableNode.getPath();
        Version v = versionManager.checkin(path);
        try {
            Version v2 = versionManager.checkin(path);
            CheckinTest.assertTrue((String)"Calling VersionManager.checkin(P) must not have an if the path P resolves to a node that is already checked-in.", (boolean)v.isSame((Item)v2));
        }
        catch (RepositoryException e) {
            CheckinTest.fail((String)"Calling VersionManager.checkin(P) must not throw an exception if the path P resolves to a node that is already checked-in.");
        }
    }

    public void testCheckinWithPendingChanges() throws RepositoryException {
        try {
            this.versionableNode.setProperty(this.propertyName1, this.propertyValue);
            this.versionableNode.checkin();
            CheckinTest.fail((String)"InvalidItemStateException must be thrown on attempt to checkin a node having any unsaved changes pending.");
        }
        catch (InvalidItemStateException invalidItemStateException) {
            // empty catch block
        }
    }

    public void testCheckinWithPendingChangesJcr2() throws RepositoryException {
        try {
            this.versionableNode.setProperty(this.propertyName1, this.propertyValue);
            VersionManager versionManager = this.versionableNode.getSession().getWorkspace().getVersionManager();
            String path = this.versionableNode.getPath();
            versionManager.checkin(path);
            CheckinTest.fail((String)"InvalidItemStateException must be thrown on attempt to checkin a node having any unsaved changes pending.");
        }
        catch (InvalidItemStateException invalidItemStateException) {
            // empty catch block
        }
    }

    public void testIsNotCheckedOut() throws RepositoryException {
        this.versionableNode.checkin();
        boolean isCheckedOut = this.versionableNode.isCheckedOut();
        CheckinTest.assertFalse((String)"Node.isCheckedOut() must return false after Node.checkin().", (boolean)isCheckedOut);
    }

    public void testIsNotCheckedOutJcr2() throws RepositoryException {
        VersionManager versionManager = this.versionableNode.getSession().getWorkspace().getVersionManager();
        String path = this.versionableNode.getPath();
        versionManager.checkin(path);
        boolean isCheckedOut = versionManager.isCheckedOut(path);
        CheckinTest.assertFalse((String)"VersionManager.isCheckedOut(P) must return false after VersionManager.checkin(P).", (boolean)isCheckedOut);
    }

    public void testCheckinCreatesNewVersion() throws RepositoryException {
        long initialNumberOfVersions = this.getNumberOfVersions(this.versionableNode.getVersionHistory());
        this.versionableNode.checkin();
        long numberOfVersions = this.getNumberOfVersions(this.versionableNode.getVersionHistory());
        CheckinTest.assertTrue((String)"Checkin must create a new Version in the VersionHistory.", (numberOfVersions == initialNumberOfVersions + 1L ? 1 : 0) != 0);
    }

    public void testCheckinCreatesNewVersionJcr2() throws RepositoryException {
        VersionManager versionManager = this.versionableNode.getSession().getWorkspace().getVersionManager();
        String path = this.versionableNode.getPath();
        long initialNumberOfVersions = this.getNumberOfVersions(versionManager.getVersionHistory(path));
        versionManager.checkin(path);
        long numberOfVersions = this.getNumberOfVersions(versionManager.getVersionHistory(path));
        CheckinTest.assertTrue((String)"Checkin must create a new Version in the VersionHistory.", (numberOfVersions == initialNumberOfVersions + 1L ? 1 : 0) != 0);
    }

    public void testCheckinNonVersionableNode() throws RepositoryException {
        try {
            this.nonVersionableNode.checkin();
            CheckinTest.fail((String)"Node.checkin() on a non-versionable node must throw UnsupportedRepositoryOperationException");
        }
        catch (UnsupportedRepositoryOperationException unsupportedRepositoryOperationException) {
            // empty catch block
        }
    }

    public void testCheckinNonVersionableNodeJcr2() throws RepositoryException {
        try {
            VersionManager versionManager = this.nonVersionableNode.getSession().getWorkspace().getVersionManager();
            String path = this.nonVersionableNode.getPath();
            versionManager.checkin(path);
            CheckinTest.fail((String)"VersionManager.checkin(P) must throw UnsupportedRepositoryOperationException if the path P resolves to a non-versionable node.");
        }
        catch (UnsupportedRepositoryOperationException unsupportedRepositoryOperationException) {
            // empty catch block
        }
    }
}

