/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.jcr2spi.observation;

import java.util.HashMap;
import java.util.Map;
import javax.jcr.RepositoryException;
import javax.jcr.observation.Event;
import org.apache.jackrabbit.spi.IdFactory;
import org.apache.jackrabbit.spi.ItemId;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.NodeId;
import org.apache.jackrabbit.spi.PropertyId;
import org.apache.jackrabbit.spi.QValue;
import org.apache.jackrabbit.spi.commons.conversion.NamePathResolver;
import org.apache.jackrabbit.spi.commons.value.ValueFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class EventImpl
implements Event {
    private static final Logger log = LoggerFactory.getLogger(EventImpl.class);
    private final NamePathResolver resolver;
    private final IdFactory idFactory;
    private final org.apache.jackrabbit.spi.Event event;
    private String stringValue;

    EventImpl(org.apache.jackrabbit.spi.Event event, NamePathResolver resolver, IdFactory idFactory) {
        this.event = event;
        this.resolver = resolver;
        this.idFactory = idFactory;
    }

    public int getType() {
        return this.event.getType();
    }

    public String getPath() throws RepositoryException {
        return this.resolver.getJCRPath(this.event.getPath());
    }

    public String getUserID() {
        return this.event.getUserID();
    }

    public String getIdentifier() throws RepositoryException {
        ItemId itemId = this.event.getItemId();
        if (itemId == null) {
            return null;
        }
        NodeId nodeId = itemId.denotesNode() ? (NodeId)itemId : ((PropertyId)itemId).getParentId();
        return this.idFactory.toJcrIdentifier(nodeId);
    }

    public Map<String, String> getInfo() throws RepositoryException {
        HashMap<String, String> jcrInfo = new HashMap<String, String>();
        for (Map.Entry entry : this.event.getInfo().entrySet()) {
            Name key = (Name)entry.getKey();
            QValue value = (QValue)entry.getValue();
            String strValue = null;
            if (value != null) {
                strValue = ValueFormat.getJCRString((QValue)value, (NamePathResolver)this.resolver);
            }
            jcrInfo.put(this.resolver.getJCRName(key), strValue);
        }
        return jcrInfo;
    }

    public String getUserData() throws RepositoryException {
        return this.event.getUserData();
    }

    public long getDate() throws RepositoryException {
        return this.event.getDate();
    }

    public String toString() {
        if (this.stringValue == null) {
            StringBuffer sb = new StringBuffer();
            sb.append("Event: Path: ");
            try {
                sb.append(this.getPath());
            }
            catch (RepositoryException e) {
                log.error("Exception retrieving path: " + (Object)((Object)e));
                sb.append("[Error retrieving path]");
            }
            sb.append(", ").append(EventImpl.valueOf(this.getType())).append(": ");
            sb.append(", UserId: ").append(this.getUserID());
            this.stringValue = sb.toString();
        }
        return this.stringValue;
    }

    private static String valueOf(int eventType) {
        if (eventType == 1) {
            return "NodeAdded";
        }
        if (eventType == 2) {
            return "NodeRemoved";
        }
        if (eventType == 4) {
            return "PropertyAdded";
        }
        if (eventType == 16) {
            return "PropertyChanged";
        }
        if (eventType == 8) {
            return "PropertyRemoved";
        }
        if (eventType == 32) {
            return "NodeMoved";
        }
        if (eventType == 64) {
            return "Persist";
        }
        return "UnknownEventType";
    }
}

