/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.jcr2spi.operation;

import java.util.Iterator;
import javax.jcr.AccessDeniedException;
import javax.jcr.ItemExistsException;
import javax.jcr.RepositoryException;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import javax.jcr.version.VersionException;
import org.apache.jackrabbit.jcr2spi.hierarchy.NodeEntry;
import org.apache.jackrabbit.jcr2spi.operation.AbstractOperation;
import org.apache.jackrabbit.jcr2spi.operation.OperationVisitor;
import org.apache.jackrabbit.jcr2spi.state.NodeState;
import org.apache.jackrabbit.jcr2spi.version.VersionManager;
import org.apache.jackrabbit.spi.NodeId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Merge
extends AbstractOperation {
    private static Logger log = LoggerFactory.getLogger(Merge.class);
    private final NodeState nodeState;
    private final String srcWorkspaceName;
    private final boolean bestEffort;
    private final boolean isShallow;
    private final VersionManager mgr;
    private Iterator<NodeId> failedIds = null;

    private Merge(NodeState nodeState, String srcWorkspaceName, boolean bestEffort, boolean isShallow, VersionManager mgr) {
        this.nodeState = nodeState;
        this.srcWorkspaceName = srcWorkspaceName;
        this.bestEffort = bestEffort;
        this.isShallow = isShallow;
        this.mgr = mgr;
    }

    @Override
    public void accept(OperationVisitor visitor) throws RepositoryException, ConstraintViolationException, AccessDeniedException, ItemExistsException, NoSuchNodeTypeException, UnsupportedRepositoryOperationException, VersionException {
        assert (this.status == 0);
        visitor.visit(this);
    }

    @Override
    public void persisted() {
        assert (this.status == 0);
        this.status = 1;
        if (this.isActivityMerge()) {
            NodeEntry entry = this.nodeState.getNodeEntry();
            while (entry.getParent() != null) {
                entry = entry.getParent();
            }
            entry.invalidate(true);
        } else {
            try {
                NodeEntry vhe = this.mgr.getVersionHistoryEntry(this.nodeState);
                if (vhe != null) {
                    vhe.invalidate(true);
                }
            }
            catch (RepositoryException e) {
                log.warn("Error while retrieving VersionHistory entry:", (Object)e.getMessage());
            }
            this.nodeState.getHierarchyEntry().invalidate(true);
        }
    }

    public NodeId getNodeId() throws RepositoryException {
        return this.nodeState.getNodeEntry().getWorkspaceId();
    }

    public String getSourceWorkspaceName() {
        return this.srcWorkspaceName;
    }

    public boolean bestEffort() {
        return this.bestEffort;
    }

    public boolean isShallow() {
        return this.isShallow;
    }

    public boolean isActivityMerge() {
        return this.srcWorkspaceName == null;
    }

    public void setFailedIds(Iterator<NodeId> failedIds) {
        if (failedIds == null) {
            throw new IllegalArgumentException("IdIterator must not be null.");
        }
        if (this.failedIds != null) {
            throw new IllegalStateException("Merge operation has already been executed -> FailedIds already set.");
        }
        this.failedIds = failedIds;
    }

    public Iterator<NodeId> getFailedIds() {
        if (this.failedIds == null) {
            throw new IllegalStateException("Merge operation has not been executed yet.");
        }
        return this.failedIds;
    }

    public static Merge create(NodeState nodeState, String srcWorkspaceName, boolean bestEffort, boolean isShallow, VersionManager mgr) {
        return new Merge(nodeState, srcWorkspaceName, bestEffort, isShallow, mgr);
    }
}

