/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.jcr2spi.operation;

import java.util.ArrayList;
import javax.jcr.AccessDeniedException;
import javax.jcr.ItemExistsException;
import javax.jcr.RepositoryException;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.ValueFormatException;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.version.VersionException;
import org.apache.jackrabbit.jcr2spi.operation.AbstractOperation;
import org.apache.jackrabbit.jcr2spi.operation.Operation;
import org.apache.jackrabbit.jcr2spi.operation.OperationVisitor;
import org.apache.jackrabbit.jcr2spi.state.PropertyState;
import org.apache.jackrabbit.spi.PropertyId;
import org.apache.jackrabbit.spi.QValue;

public class SetPropertyValue
extends AbstractOperation {
    private final PropertyId propertyId;
    private final PropertyState propertyState;
    private final QValue[] values;
    private final int valueType;
    private final QValue[] oldValues;

    private SetPropertyValue(PropertyState propertyState, int valueType, QValue[] values) throws RepositoryException {
        this.propertyState = propertyState;
        this.propertyId = (PropertyId)propertyState.getId();
        this.valueType = valueType;
        this.values = values;
        this.oldValues = propertyState.getValues();
        this.addAffectedItemState(propertyState);
    }

    public void accept(OperationVisitor visitor) throws ValueFormatException, LockException, ConstraintViolationException, AccessDeniedException, ItemExistsException, UnsupportedRepositoryOperationException, VersionException, RepositoryException {
        assert (this.status == 0);
        visitor.visit(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void persisted() throws RepositoryException {
        assert (this.status == 0);
        this.status = 1;
        try {
            this.propertyState.getHierarchyEntry().complete(this);
        }
        finally {
            for (QValue v : this.oldValues) {
                v.discard();
            }
        }
    }

    public void undo() throws RepositoryException {
        assert (this.status == 0);
        this.status = 2;
        this.propertyState.getHierarchyEntry().complete(this);
    }

    public PropertyId getPropertyId() {
        return this.propertyId;
    }

    public PropertyState getPropertyState() {
        return this.propertyState;
    }

    public boolean isMultiValued() {
        return this.propertyState.isMultiValued();
    }

    public int getValueType() {
        return this.valueType;
    }

    public QValue[] getValues() {
        return this.values;
    }

    public static Operation create(PropertyState propState, QValue[] qValues, int valueType) throws RepositoryException {
        ArrayList<QValue> list = new ArrayList<QValue>();
        for (int i = 0; i < qValues.length; ++i) {
            if (qValues[i] == null) continue;
            list.add(qValues[i]);
        }
        QValue[] cleanValues = list.toArray(new QValue[list.size()]);
        SetPropertyValue sv = new SetPropertyValue(propState, valueType, cleanValues);
        return sv;
    }
}

