/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.jcr2spi.state;

import java.util.HashSet;
import java.util.Set;
import org.apache.jackrabbit.jcr2spi.state.ItemState;
import org.apache.jackrabbit.jcr2spi.state.ItemStateCreationListener;
import org.apache.jackrabbit.jcr2spi.state.ItemStateFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractItemStateFactory
implements ItemStateFactory {
    private static Logger log = LoggerFactory.getLogger(AbstractItemStateFactory.class);
    private final Set<ItemStateCreationListener> creationListeners = new HashSet<ItemStateCreationListener>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCreationListener(ItemStateCreationListener listener) {
        Set<ItemStateCreationListener> set = this.creationListeners;
        synchronized (set) {
            this.creationListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCreationListener(ItemStateCreationListener listener) {
        Set<ItemStateCreationListener> set = this.creationListeners;
        synchronized (set) {
            this.creationListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ItemStateCreationListener[] getListeners() {
        Set<ItemStateCreationListener> set = this.creationListeners;
        synchronized (set) {
            return this.creationListeners.toArray(new ItemStateCreationListener[this.creationListeners.size()]);
        }
    }

    void notifyCreated(ItemState createdState) {
        ItemStateCreationListener[] listeners = this.getListeners();
        for (int i = 0; i < listeners.length; ++i) {
            createdState.addListener(listeners[i]);
            listeners[i].created(createdState);
        }
    }

    void notifyUpdated(ItemState state, int previousStatus) {
        ItemStateCreationListener[] listeners = this.getListeners();
        for (int i = 0; i < listeners.length; ++i) {
            listeners[i].statusChanged(state, previousStatus);
        }
    }
}

