/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.jcr2spi.state;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import javax.jcr.InvalidItemStateException;
import javax.jcr.ItemNotFoundException;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.jcr2spi.hierarchy.HierarchyEntry;
import org.apache.jackrabbit.jcr2spi.hierarchy.NodeEntry;
import org.apache.jackrabbit.jcr2spi.nodetype.ItemDefinitionProvider;
import org.apache.jackrabbit.jcr2spi.state.ItemStateFactory;
import org.apache.jackrabbit.jcr2spi.state.ItemStateLifeCycleListener;
import org.apache.jackrabbit.jcr2spi.state.NodeState;
import org.apache.jackrabbit.jcr2spi.state.Status;
import org.apache.jackrabbit.spi.ItemId;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.Path;
import org.apache.jackrabbit.util.WeakIdentityCollection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ItemState {
    private static Logger log = LoggerFactory.getLogger(ItemState.class);
    private int status;
    private final HierarchyEntry hierarchyEntry;
    private final transient Collection<ItemStateLifeCycleListener> listeners = new WeakIdentityCollection(5);
    final ItemStateFactory isf;
    final ItemDefinitionProvider definitionProvider;

    protected ItemState(HierarchyEntry entry, ItemStateFactory isf, ItemDefinitionProvider definitionProvider) {
        this(ItemState.getInitialStatus(entry.getParent()), entry, isf, definitionProvider);
    }

    protected ItemState(int initialStatus, HierarchyEntry entry, ItemStateFactory isf, ItemDefinitionProvider definitionProvider) {
        if (entry == null) {
            throw new IllegalArgumentException("Cannot build ItemState from 'null' HierarchyEntry");
        }
        switch (initialStatus) {
            case 1: 
            case 3: 
            case 4: {
                this.status = initialStatus;
                break;
            }
            default: {
                String msg = "illegal status: " + initialStatus;
                log.debug(msg);
                throw new IllegalArgumentException(msg);
            }
        }
        this.hierarchyEntry = entry;
        this.isf = isf;
        this.definitionProvider = definitionProvider;
    }

    private static int getInitialStatus(NodeEntry parent) {
        int status = 1;
        while (parent != null) {
            if (parent.getStatus() == 3) {
                status = 3;
                break;
            }
            parent = parent.getParent();
        }
        return status;
    }

    public HierarchyEntry getHierarchyEntry() {
        return this.hierarchyEntry;
    }

    public boolean isValid() {
        return Status.isValid(this.getStatus()) || Status.isStale(this.getStatus());
    }

    public abstract boolean isNode();

    public Name getName() {
        return this.getHierarchyEntry().getName();
    }

    public abstract ItemId getId() throws RepositoryException;

    public abstract ItemId getWorkspaceId() throws RepositoryException;

    public Path getPath() throws RepositoryException {
        return this.getHierarchyEntry().getPath();
    }

    public NodeState getParent() throws ItemNotFoundException, RepositoryException {
        return this.getHierarchyEntry().getParent().getNodeState();
    }

    public final int getStatus() {
        this.getHierarchyEntry().calculateStatus();
        return this.status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStatus(int newStatus) {
        ItemStateLifeCycleListener[] la;
        int oldStatus = this.status;
        if (oldStatus == newStatus) {
            return;
        }
        if (oldStatus == 8) {
            throw new IllegalStateException("State is already in terminal status " + Status.getName(oldStatus));
        }
        if (!Status.isValidStatusChange(oldStatus, newStatus)) {
            throw new IllegalArgumentException("Invalid new status " + Status.getName(newStatus) + " for state with status " + Status.getName(oldStatus));
        }
        this.status = Status.getNewStatus(oldStatus, newStatus);
        Collection<ItemStateLifeCycleListener> collection = this.listeners;
        synchronized (collection) {
            la = this.listeners.toArray(new ItemStateLifeCycleListener[this.listeners.size()]);
        }
        for (int i = 0; i < la.length; ++i) {
            if (la[i] == null) continue;
            la[i].statusChanged(this, oldStatus);
        }
        if (this.status == 7) {
            this.status = 1;
        }
    }

    public abstract MergeResult merge(ItemState var1, boolean var2);

    public abstract boolean revert();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(ItemStateLifeCycleListener listener) {
        Collection<ItemStateLifeCycleListener> collection = this.listeners;
        synchronized (collection) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(ItemStateLifeCycleListener listener) {
        Collection<ItemStateLifeCycleListener> collection = this.listeners;
        synchronized (collection) {
            this.listeners.remove(listener);
        }
    }

    public Iterator<ItemStateLifeCycleListener> getListeners() {
        return Collections.unmodifiableCollection(this.listeners).iterator();
    }

    public void invalidate() {
        if (this.status == 1) {
            this.setStatus(0);
        } else {
            log.debug("Skip invalidation for item {} with status {}", (Object)this.getName(), (Object)Status.getName(this.status));
        }
    }

    void markModified() throws InvalidItemStateException {
        switch (this.status) {
            case 1: {
                this.setStatus(2);
                break;
            }
            case 2: {
                break;
            }
            case 4: {
                break;
            }
            case 5: 
            case 6: {
                throw new InvalidItemStateException("Cannot mark stale state modified.");
            }
            default: {
                String msg = "Cannot mark item state with status '" + Status.getName(this.status) + "' modified.";
                throw new InvalidItemStateException(msg);
            }
        }
    }

    protected class SimpleMergeResult
    implements MergeResult {
        private final boolean modified;

        public SimpleMergeResult(boolean modified) {
            this.modified = modified;
        }

        public boolean modified() {
            return this.modified;
        }

        public void dispose() {
        }
    }

    public static interface MergeResult {
        public boolean modified();

        public void dispose();
    }
}

