/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.jcr2spi;

import java.io.IOException;
import java.io.InputStream;
import java.security.AccessControlException;
import java.util.Map;
import javax.jcr.AccessDeniedException;
import javax.jcr.Credentials;
import javax.jcr.InvalidItemStateException;
import javax.jcr.InvalidSerializedDataException;
import javax.jcr.Item;
import javax.jcr.ItemExistsException;
import javax.jcr.ItemNotFoundException;
import javax.jcr.LoginException;
import javax.jcr.NamespaceException;
import javax.jcr.NoSuchWorkspaceException;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.ValueFactory;
import javax.jcr.Workspace;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.retention.RetentionManager;
import javax.jcr.security.AccessControlManager;
import javax.jcr.version.Version;
import javax.jcr.version.VersionException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.collections.map.ReferenceMap;
import org.apache.commons.io.IOUtils;
import org.apache.jackrabbit.commons.AbstractSession;
import org.apache.jackrabbit.jcr2spi.ItemCacheImpl;
import org.apache.jackrabbit.jcr2spi.ItemManager;
import org.apache.jackrabbit.jcr2spi.ItemManagerImpl;
import org.apache.jackrabbit.jcr2spi.ManagerProvider;
import org.apache.jackrabbit.jcr2spi.NodeImpl;
import org.apache.jackrabbit.jcr2spi.SessionListener;
import org.apache.jackrabbit.jcr2spi.WorkspaceImpl;
import org.apache.jackrabbit.jcr2spi.XASessionImpl;
import org.apache.jackrabbit.jcr2spi.config.CacheBehaviour;
import org.apache.jackrabbit.jcr2spi.config.RepositoryConfig;
import org.apache.jackrabbit.jcr2spi.hierarchy.HierarchyEntry;
import org.apache.jackrabbit.jcr2spi.hierarchy.HierarchyManager;
import org.apache.jackrabbit.jcr2spi.hierarchy.HierarchyManagerImpl;
import org.apache.jackrabbit.jcr2spi.hierarchy.NodeEntry;
import org.apache.jackrabbit.jcr2spi.lock.LockStateManager;
import org.apache.jackrabbit.jcr2spi.nodetype.EffectiveNodeTypeProvider;
import org.apache.jackrabbit.jcr2spi.nodetype.ItemDefinitionProvider;
import org.apache.jackrabbit.jcr2spi.nodetype.NodeTypeDefinitionProvider;
import org.apache.jackrabbit.jcr2spi.nodetype.NodeTypeManagerImpl;
import org.apache.jackrabbit.jcr2spi.operation.Move;
import org.apache.jackrabbit.jcr2spi.operation.Operation;
import org.apache.jackrabbit.jcr2spi.security.AccessManager;
import org.apache.jackrabbit.jcr2spi.state.ItemStateFactory;
import org.apache.jackrabbit.jcr2spi.state.ItemStateValidator;
import org.apache.jackrabbit.jcr2spi.state.NodeState;
import org.apache.jackrabbit.jcr2spi.state.PropertyState;
import org.apache.jackrabbit.jcr2spi.state.SessionItemStateManager;
import org.apache.jackrabbit.jcr2spi.state.UpdatableItemStateManager;
import org.apache.jackrabbit.jcr2spi.util.LogUtil;
import org.apache.jackrabbit.jcr2spi.version.VersionManager;
import org.apache.jackrabbit.jcr2spi.xml.ImportHandler;
import org.apache.jackrabbit.jcr2spi.xml.SessionImporter;
import org.apache.jackrabbit.spi.IdFactory;
import org.apache.jackrabbit.spi.ItemId;
import org.apache.jackrabbit.spi.NameFactory;
import org.apache.jackrabbit.spi.NodeId;
import org.apache.jackrabbit.spi.Path;
import org.apache.jackrabbit.spi.PathFactory;
import org.apache.jackrabbit.spi.QValueFactory;
import org.apache.jackrabbit.spi.SessionInfo;
import org.apache.jackrabbit.spi.XASessionInfo;
import org.apache.jackrabbit.spi.commons.conversion.DefaultNamePathResolver;
import org.apache.jackrabbit.spi.commons.conversion.IdentifierResolver;
import org.apache.jackrabbit.spi.commons.conversion.MalformedPathException;
import org.apache.jackrabbit.spi.commons.conversion.NameException;
import org.apache.jackrabbit.spi.commons.conversion.NamePathResolver;
import org.apache.jackrabbit.spi.commons.conversion.NameResolver;
import org.apache.jackrabbit.spi.commons.conversion.PathResolver;
import org.apache.jackrabbit.spi.commons.name.NameConstants;
import org.apache.jackrabbit.spi.commons.namespace.NamespaceResolver;
import org.apache.jackrabbit.spi.commons.value.ValueFactoryQImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class SessionImpl
extends AbstractSession
implements NamespaceResolver,
ManagerProvider {
    private static Logger log = LoggerFactory.getLogger(SessionImpl.class);
    private boolean alive = true;
    private final Map<SessionListener, SessionListener> listeners = new ReferenceMap(2, 2);
    private final Repository repository;
    private final RepositoryConfig config;
    private final WorkspaceImpl workspace;
    private final SessionInfo sessionInfo;
    private NamePathResolver npResolver;
    private final NodeTypeManagerImpl ntManager;
    private final ValueFactory valueFactory;
    private final SessionItemStateManager itemStateManager;
    private final ItemManager itemManager;
    private final ItemStateValidator validator;

    SessionImpl(SessionInfo sessionInfo, Repository repository, RepositoryConfig config) throws RepositoryException {
        this.repository = repository;
        this.config = config;
        this.sessionInfo = sessionInfo;
        this.workspace = this.createWorkspaceInstance(config, sessionInfo);
        IdResolver idResolver = new IdResolver();
        this.npResolver = new DefaultNamePathResolver((NamespaceResolver)this, (IdentifierResolver)idResolver, true);
        this.valueFactory = new ValueFactoryQImpl(config.getRepositoryService().getQValueFactory(), this.npResolver);
        this.ntManager = new NodeTypeManagerImpl(this.workspace.getNodeTypeRegistry(), this);
        this.validator = new ItemStateValidator(this, this.getPathFactory());
        this.itemStateManager = this.createSessionItemStateManager(this.workspace.getUpdatableItemStateManager(), this.workspace.getItemStateFactory());
        HierarchyManager hMgr = this.getHierarchyManager();
        this.itemManager = this.createItemManager(hMgr);
        if (hMgr instanceof HierarchyManagerImpl) {
            ((HierarchyManagerImpl)hMgr).setResolver(this.npResolver);
        }
    }

    public Repository getRepository() {
        return this.repository;
    }

    public String getUserID() {
        return this.sessionInfo.getUserID();
    }

    public Object getAttribute(String name) {
        return null;
    }

    public String[] getAttributeNames() {
        return new String[0];
    }

    public Workspace getWorkspace() {
        return this.workspace;
    }

    public Session impersonate(Credentials credentials) throws LoginException, RepositoryException {
        this.checkIsAlive();
        SessionInfo info = this.config.getRepositoryService().impersonate(this.sessionInfo, credentials);
        try {
            if (info instanceof XASessionInfo) {
                return new XASessionImpl((XASessionInfo)info, this.repository, this.config);
            }
            return new SessionImpl(info, this.repository, this.config);
        }
        catch (RepositoryException ex) {
            this.config.getRepositoryService().dispose(info);
            throw ex;
        }
    }

    public Node getRootNode() throws RepositoryException {
        this.checkIsAlive();
        NodeEntry re = this.getHierarchyManager().getRootEntry();
        return (Node)this.itemManager.getItem(re);
    }

    public Node getNodeByUUID(String uuid) throws ItemNotFoundException, RepositoryException {
        Node node = this.getNodeById(this.getIdFactory().createNodeId(uuid));
        if (node instanceof NodeImpl && ((NodeImpl)node).isNodeType(NameConstants.MIX_REFERENCEABLE)) {
            return node;
        }
        String mixReferenceable = this.getNameResolver().getJCRName(NameConstants.MIX_REFERENCEABLE);
        if (node.isNodeType(mixReferenceable)) {
            return node;
        }
        throw new ItemNotFoundException(uuid);
    }

    private Node getNodeById(NodeId id) throws ItemNotFoundException, RepositoryException {
        this.checkIsAlive();
        try {
            NodeEntry nodeEntry = this.getHierarchyManager().getNodeEntry(id);
            Item item = this.getItemManager().getItem(nodeEntry);
            if (item.isNode()) {
                return (Node)item;
            }
            log.error("NodeId '" + id + " does not point to a Node");
            throw new ItemNotFoundException(LogUtil.saveGetIdString((ItemId)id, this.getPathResolver()));
        }
        catch (AccessDeniedException e) {
            throw new ItemNotFoundException(LogUtil.saveGetIdString((ItemId)id, this.getPathResolver()));
        }
    }

    public Item getItem(String absPath) throws PathNotFoundException, RepositoryException {
        this.checkIsAlive();
        try {
            Path qPath = this.getQPath(absPath).getNormalizedPath();
            ItemManager itemMgr = this.getItemManager();
            if (itemMgr.nodeExists(qPath)) {
                return itemMgr.getNode(qPath);
            }
            return itemMgr.getProperty(qPath);
        }
        catch (AccessDeniedException ade) {
            throw new PathNotFoundException(absPath);
        }
    }

    public boolean itemExists(String absPath) throws RepositoryException {
        this.checkIsAlive();
        Path qPath = this.getQPath(absPath).getNormalizedPath();
        ItemManager itemMgr = this.getItemManager();
        return itemMgr.nodeExists(qPath) || itemMgr.propertyExists(qPath);
    }

    public void move(String srcAbsPath, String destAbsPath) throws ItemExistsException, PathNotFoundException, VersionException, ConstraintViolationException, LockException, RepositoryException {
        this.checkSupportedOption("level.2.supported");
        this.checkIsAlive();
        Path srcPath = this.getQPath(srcAbsPath);
        Path destPath = this.getQPath(destAbsPath);
        Operation op = Move.create(srcPath, destPath, this.getHierarchyManager(), this.getPathResolver(), true);
        this.itemStateManager.execute(op);
    }

    public void save() throws AccessDeniedException, ConstraintViolationException, InvalidItemStateException, VersionException, LockException, RepositoryException {
        this.checkSupportedOption("level.2.supported");
        this.getRootNode().save();
    }

    public void refresh(boolean keepChanges) throws RepositoryException {
        this.getRootNode().refresh(keepChanges);
    }

    public boolean hasPendingChanges() throws RepositoryException {
        this.checkIsAlive();
        return this.itemStateManager.hasPendingChanges();
    }

    public ValueFactory getValueFactory() throws UnsupportedRepositoryOperationException, RepositoryException {
        this.checkSupportedOption("level.2.supported");
        return this.getJcrValueFactory();
    }

    public void checkPermission(String absPath, String actions) throws AccessControlException, RepositoryException {
        if (!this.hasPermission(absPath, actions)) {
            throw new AccessControlException("Access control violation: path = " + absPath + ", actions = " + actions);
        }
    }

    public ContentHandler getImportContentHandler(String parentAbsPath, int uuidBehavior) throws PathNotFoundException, ConstraintViolationException, VersionException, LockException, RepositoryException {
        this.checkSupportedOption("level.2.supported");
        this.checkIsAlive();
        Path parentPath = this.getQPath(parentAbsPath);
        SessionImporter importer = new SessionImporter(parentPath, this, this.itemStateManager, uuidBehavior);
        return new ImportHandler(importer, this.getNamespaceResolver(), this.workspace.getNamespaceRegistry(), this.getNameFactory(), this.getPathFactory());
    }

    public void importXML(String parentAbsPath, InputStream in, int uuidBehavior) throws IOException, PathNotFoundException, ItemExistsException, ConstraintViolationException, VersionException, InvalidSerializedDataException, LockException, RepositoryException {
        ImportHandler handler = (ImportHandler)this.getImportContentHandler(parentAbsPath, uuidBehavior);
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setNamespaceAware(true);
            factory.setFeature("http://xml.org/sax/features/namespace-prefixes", false);
            SAXParser parser = factory.newSAXParser();
            parser.parse(new InputSource(in), (DefaultHandler)handler);
        }
        catch (SAXException se) {
            Exception e = se.getException();
            if (e != null && e instanceof RepositoryException) {
                throw (RepositoryException)((Object)e);
            }
            String msg = "failed to parse XML stream";
            log.debug(msg);
            throw new InvalidSerializedDataException(msg, (Throwable)se);
        }
        catch (ParserConfigurationException e) {
            throw new RepositoryException("SAX parser configuration error", (Throwable)e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)in);
        }
    }

    public void setNamespacePrefix(String prefix, String uri) throws RepositoryException {
        super.setNamespacePrefix(prefix, uri);
        this.npResolver = new DefaultNamePathResolver((NamespaceResolver)this, true);
    }

    public void logout() {
        if (!this.alive) {
            return;
        }
        this.notifyLoggingOut();
        this.itemStateManager.dispose();
        this.itemManager.dispose();
        this.workspace.dispose();
        this.alive = false;
        this.notifyLoggedOut();
    }

    public boolean isLive() {
        return this.alive;
    }

    public void addLockToken(String lt) {
        try {
            this.getLockStateManager().addLockToken(lt);
        }
        catch (RepositoryException e) {
            log.warn("Unable to add lock token '" + lt + "' to this session.", (Throwable)e);
        }
    }

    public String[] getLockTokens() {
        try {
            return this.getLockStateManager().getLockTokens();
        }
        catch (RepositoryException e) {
            log.warn("Unable to retrieve lock tokens for this session. (" + e.getMessage() + ")");
            return new String[0];
        }
    }

    public void removeLockToken(String lt) {
        try {
            this.getLockStateManager().removeLockToken(lt);
        }
        catch (RepositoryException e) {
            log.warn("Unable to remove lock token '" + lt + "' from this session. (" + e.getMessage() + ")");
        }
    }

    public AccessControlManager getAccessControlManager() throws RepositoryException {
        this.checkSupportedOption("option.access.control.supported");
        throw new UnsupportedRepositoryOperationException("JCR-1104");
    }

    public Node getNode(String absPath) throws RepositoryException {
        this.checkIsAlive();
        try {
            Path qPath = this.getQPath(absPath).getNormalizedPath();
            ItemManager itemMgr = this.getItemManager();
            return itemMgr.getNode(qPath);
        }
        catch (AccessDeniedException ade) {
            throw new PathNotFoundException(absPath);
        }
    }

    public Node getNodeByIdentifier(String id) throws RepositoryException {
        return this.getNodeById(this.getIdFactory().fromJcrIdentifier(id));
    }

    public Property getProperty(String absPath) throws RepositoryException {
        this.checkIsAlive();
        try {
            Path qPath = this.getQPath(absPath).getNormalizedPath();
            ItemManager itemMgr = this.getItemManager();
            return itemMgr.getProperty(qPath);
        }
        catch (AccessDeniedException ade) {
            throw new PathNotFoundException(absPath);
        }
    }

    public RetentionManager getRetentionManager() throws UnsupportedRepositoryOperationException, RepositoryException {
        this.checkSupportedOption("option.retention.supported");
        throw new UnsupportedRepositoryOperationException("JCR-1104");
    }

    public boolean hasCapability(String methodName, Object target, Object[] arguments) throws RepositoryException {
        return true;
    }

    public boolean hasPermission(String absPath, String actions) throws RepositoryException {
        boolean isGranted;
        this.checkIsAlive();
        String[] actionsArr = actions.split(",");
        Path targetPath = this.getQPath(absPath);
        if (this.itemManager.nodeExists(targetPath)) {
            NodeState nState = this.getHierarchyManager().getNodeState(targetPath);
            isGranted = this.getAccessManager().isGranted(nState, actionsArr);
        } else if (this.itemManager.propertyExists(targetPath)) {
            PropertyState pState = this.getHierarchyManager().getPropertyState(targetPath);
            isGranted = this.getAccessManager().isGranted(pState, actionsArr);
        } else {
            NodeState parentState = null;
            Path parentPath = targetPath;
            while (parentState == null) {
                if (!this.itemManager.nodeExists(parentPath = parentPath.getAncestor(1))) continue;
                parentState = this.getHierarchyManager().getNodeState(parentPath);
            }
            Path relPath = parentPath.computeRelativePath(targetPath);
            isGranted = this.getAccessManager().isGranted(parentState, relPath, actionsArr);
        }
        return isGranted;
    }

    public boolean nodeExists(String absPath) throws RepositoryException {
        this.checkIsAlive();
        Path qPath = this.getQPath(absPath).getNormalizedPath();
        ItemManager itemMgr = this.getItemManager();
        return itemMgr.nodeExists(qPath);
    }

    public boolean propertyExists(String absPath) throws RepositoryException {
        this.checkIsAlive();
        Path qPath = this.getQPath(absPath).getNormalizedPath();
        ItemManager itemMgr = this.getItemManager();
        return itemMgr.propertyExists(qPath);
    }

    public void removeItem(String absPath) throws RepositoryException {
        Item item = this.getItem(absPath);
        item.remove();
    }

    public String getPrefix(String uri) throws NamespaceException {
        try {
            return this.getNamespacePrefix(uri);
        }
        catch (NamespaceException e) {
            throw e;
        }
        catch (RepositoryException e) {
            throw new NamespaceException("Namespace not found: " + uri, (Throwable)e);
        }
    }

    public String getURI(String prefix) throws NamespaceException {
        try {
            return this.getNamespaceURI(prefix);
        }
        catch (NamespaceException e) {
            throw e;
        }
        catch (RepositoryException e) {
            throw new NamespaceException("Namespace not found: " + prefix, (Throwable)e);
        }
    }

    public void addListener(SessionListener listener) {
        if (!this.listeners.containsKey(listener)) {
            this.listeners.put(listener, listener);
        }
    }

    public void removeListener(SessionListener listener) {
        this.listeners.remove(listener);
    }

    private void notifyLoggingOut() {
        SessionListener[] la;
        for (SessionListener sl : la = this.listeners.values().toArray(new SessionListener[this.listeners.size()])) {
            if (sl == null) continue;
            sl.loggingOut((Session)this);
        }
    }

    private void notifyLoggedOut() {
        SessionListener[] la;
        for (SessionListener sl : la = this.listeners.values().toArray(new SessionListener[this.listeners.size()])) {
            if (sl == null) continue;
            sl.loggedOut((Session)this);
        }
    }

    protected WorkspaceImpl createWorkspaceInstance(RepositoryConfig config, SessionInfo sessionInfo) throws RepositoryException {
        return new WorkspaceImpl(sessionInfo.getWorkspaceName(), this, config, sessionInfo);
    }

    protected SessionItemStateManager createSessionItemStateManager(UpdatableItemStateManager workspaceStateManager, ItemStateFactory isf) throws RepositoryException {
        return new SessionItemStateManager(workspaceStateManager, this.getValidator(), this.getQValueFactory(), isf, this);
    }

    protected ItemManager createItemManager(HierarchyManager hierarchyManager) {
        ItemCacheImpl cache = new ItemCacheImpl(this.config.getItemCacheSize());
        ItemManagerImpl imgr = new ItemManagerImpl(hierarchyManager, this, cache);
        return imgr;
    }

    public NamePathResolver getNamePathResolver() {
        return this.npResolver;
    }

    public NameResolver getNameResolver() {
        return this.npResolver;
    }

    public PathResolver getPathResolver() {
        return this.npResolver;
    }

    public NamespaceResolver getNamespaceResolver() {
        return this;
    }

    public HierarchyManager getHierarchyManager() {
        return this.workspace.getHierarchyManager();
    }

    public LockStateManager getLockStateManager() {
        return this.workspace.getLockStateManager();
    }

    public AccessManager getAccessManager() {
        return this.workspace.getAccessManager();
    }

    public VersionManager getVersionStateManager() {
        return this.workspace.getVersionStateManager();
    }

    public ItemDefinitionProvider getItemDefinitionProvider() {
        return this.workspace.getItemDefinitionProvider();
    }

    public NodeTypeDefinitionProvider getNodeTypeDefinitionProvider() {
        return this.ntManager;
    }

    public EffectiveNodeTypeProvider getEffectiveNodeTypeProvider() {
        return this.workspace.getEffectiveNodeTypeProvider();
    }

    public QValueFactory getQValueFactory() throws RepositoryException {
        return this.config.getRepositoryService().getQValueFactory();
    }

    public ValueFactory getJcrValueFactory() throws RepositoryException {
        return this.valueFactory;
    }

    ItemManager getItemManager() {
        return this.itemManager;
    }

    public ItemStateValidator getValidator() {
        return this.validator;
    }

    public IdFactory getIdFactory() throws RepositoryException {
        return this.workspace.getIdFactory();
    }

    public NameFactory getNameFactory() throws RepositoryException {
        return this.workspace.getNameFactory();
    }

    PathFactory getPathFactory() throws RepositoryException {
        return this.workspace.getPathFactory();
    }

    SessionItemStateManager getSessionItemStateManager() {
        return this.itemStateManager;
    }

    NodeTypeManagerImpl getNodeTypeManager() {
        return this.ntManager;
    }

    CacheBehaviour getCacheBehaviour() {
        return this.config.getCacheBehaviour();
    }

    int getPollTimeout() {
        return this.config.getPollTimeout();
    }

    SessionImpl switchWorkspace(String workspaceName) throws AccessDeniedException, NoSuchWorkspaceException, RepositoryException {
        this.checkAccessibleWorkspace(workspaceName);
        SessionInfo info = this.config.getRepositoryService().obtain(this.sessionInfo, workspaceName);
        if (info instanceof XASessionInfo) {
            return new XASessionImpl((XASessionInfo)info, this.repository, this.config);
        }
        return new SessionImpl(info, this.repository, this.config);
    }

    Path getQPath(String absPath) throws RepositoryException {
        try {
            Path p = this.getPathResolver().getQPath(absPath);
            if (!p.isAbsolute()) {
                throw new RepositoryException("Not an absolute path: " + absPath);
            }
            return p;
        }
        catch (NameException mpe) {
            String msg = "Invalid path: " + absPath;
            log.debug(msg);
            throw new RepositoryException(msg, (Throwable)mpe);
        }
    }

    NodeState getVersionState(Version version) throws RepositoryException {
        NodeState nodeState;
        if (version.getSession() == this) {
            nodeState = (NodeState)((NodeImpl)version).getItemState();
        } else {
            Path p = this.getQPath(version.getPath());
            Path parentPath = p.getAncestor(1);
            HierarchyEntry parentEntry = this.getHierarchyManager().lookup(parentPath);
            if (parentEntry != null) {
                parentEntry.invalidate(false);
            }
            nodeState = this.getHierarchyManager().getNodeState(p);
        }
        return nodeState;
    }

    void checkIsAlive() throws RepositoryException {
        if (!this.alive) {
            throw new RepositoryException("This session has been closed.");
        }
    }

    boolean isSupportedOption(String option) {
        String desc = this.repository.getDescriptor(option);
        return desc == null ? true : Boolean.valueOf(desc);
    }

    void checkSupportedOption(String option) throws UnsupportedRepositoryOperationException, RepositoryException {
        if (!this.isSupportedOption(option)) {
            throw new UnsupportedRepositoryOperationException(option + " is not supported by this repository.");
        }
    }

    void checkHasPendingChanges() throws RepositoryException {
        if (this.hasPendingChanges()) {
            String msg = "Unable to perform operation. Session has pending changes.";
            log.debug(msg);
            throw new InvalidItemStateException(msg);
        }
    }

    void checkAccessibleWorkspace(String workspaceName) throws NoSuchWorkspaceException, RepositoryException {
        String[] wsps = this.workspace.getAccessibleWorkspaceNames();
        boolean accessible = false;
        for (int i = 0; i < wsps.length && !accessible; ++i) {
            accessible = wsps[i].equals(workspaceName);
        }
        if (!accessible) {
            throw new NoSuchWorkspaceException("Unknown workspace: '" + workspaceName + "'.");
        }
    }

    private final class IdResolver
    implements IdentifierResolver {
        private IdResolver() {
        }

        public Path getPath(String identifier) throws MalformedPathException {
            try {
                NodeId id = SessionImpl.this.getIdFactory().fromJcrIdentifier(identifier);
                return SessionImpl.this.getHierarchyManager().getNodeEntry(id).getPath();
            }
            catch (RepositoryException e) {
                throw new MalformedPathException("Invalid identifier '" + identifier + "'.");
            }
        }

        public void checkFormat(String identifier) throws MalformedPathException {
            try {
                SessionImpl.this.getIdFactory().fromJcrIdentifier(identifier);
            }
            catch (Exception e) {
                throw new MalformedPathException("Invalid identifier '" + identifier + "'.");
            }
        }
    }
}

