/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.jcr2spi.operation;

import javax.jcr.AccessDeniedException;
import javax.jcr.ItemExistsException;
import javax.jcr.NoSuchWorkspaceException;
import javax.jcr.RepositoryException;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.version.VersionException;
import org.apache.jackrabbit.jcr2spi.ManagerProvider;
import org.apache.jackrabbit.jcr2spi.hierarchy.HierarchyEntry;
import org.apache.jackrabbit.jcr2spi.operation.AbstractCopy;
import org.apache.jackrabbit.jcr2spi.operation.Operation;
import org.apache.jackrabbit.jcr2spi.operation.OperationVisitor;
import org.apache.jackrabbit.spi.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Clone
extends AbstractCopy {
    private static Logger log = LoggerFactory.getLogger(Clone.class);
    private final boolean removeExisting;

    private Clone(Path srcPath, Path destPath, String srcWorkspaceName, boolean removeExisting, ManagerProvider srcMgrProvider, ManagerProvider destMgrProvider) throws RepositoryException {
        super(srcPath, destPath, srcWorkspaceName, srcMgrProvider, destMgrProvider);
        this.removeExisting = removeExisting;
    }

    public void accept(OperationVisitor visitor) throws NoSuchWorkspaceException, LockException, ConstraintViolationException, AccessDeniedException, ItemExistsException, UnsupportedRepositoryOperationException, VersionException, RepositoryException {
        assert (this.status == 0);
        visitor.visit(this);
    }

    public void persisted() {
        assert (this.status == 0);
        if (this.removeExisting) {
            this.status = 1;
            HierarchyEntry he = this.destParentState.getHierarchyEntry();
            while (he.getParent() != null) {
                he = he.getParent();
            }
            he.invalidate(true);
        } else {
            super.persisted();
        }
    }

    public boolean isRemoveExisting() {
        return this.removeExisting;
    }

    public static Operation create(Path srcPath, Path destPath, String srcWorkspaceName, boolean removeExisting, ManagerProvider srcMgrProvider, ManagerProvider destMgrProvider) throws RepositoryException, ConstraintViolationException, AccessDeniedException, ItemExistsException, VersionException {
        Clone cl = new Clone(srcPath, destPath, srcWorkspaceName, removeExisting, srcMgrProvider, destMgrProvider);
        return cl;
    }
}

