/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.jcr2spi.operation;

import java.util.Iterator;
import javax.jcr.AccessDeniedException;
import javax.jcr.RepositoryException;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.version.VersionException;
import org.apache.jackrabbit.jcr2spi.hierarchy.NodeEntry;
import org.apache.jackrabbit.jcr2spi.hierarchy.PropertyEntry;
import org.apache.jackrabbit.jcr2spi.operation.AbstractRemove;
import org.apache.jackrabbit.jcr2spi.operation.Operation;
import org.apache.jackrabbit.jcr2spi.operation.OperationVisitor;
import org.apache.jackrabbit.jcr2spi.state.ItemState;
import org.apache.jackrabbit.jcr2spi.state.NodeState;
import org.apache.jackrabbit.jcr2spi.version.VersionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoveVersion
extends AbstractRemove {
    private static Logger log = LoggerFactory.getLogger(RemoveVersion.class);
    private NodeEntry versionableEntry = null;

    private RemoveVersion(ItemState removeState, NodeState parent, VersionManager mgr) throws RepositoryException {
        super(removeState, parent);
        try {
            this.versionableEntry = mgr.getVersionableNodeEntry((NodeState)removeState);
        }
        catch (RepositoryException e) {
            log.warn("Failed to retrieve the hierarchy entry of the versionable node.", (Throwable)e);
        }
    }

    public void accept(OperationVisitor visitor) throws AccessDeniedException, UnsupportedRepositoryOperationException, VersionException, RepositoryException {
        assert (this.status == 0);
        visitor.visit(this);
    }

    public void persisted() {
        assert (this.status == 0);
        this.status = 1;
        if (this.versionableEntry != null) {
            Iterator<PropertyEntry> propEntries = this.versionableEntry.getPropertyEntries();
            while (propEntries.hasNext()) {
                PropertyEntry pe = propEntries.next();
                pe.invalidate(false);
            }
            this.versionableEntry.invalidate(false);
        }
        this.parent.getNodeEntry().invalidate(true);
    }

    public static Operation create(NodeState versionState, NodeState vhState, VersionManager mgr) throws RepositoryException {
        RemoveVersion rm = new RemoveVersion(versionState, vhState, mgr);
        return rm;
    }
}

