/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.spi.commons.value;

import java.io.IOException;
import java.util.ArrayList;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.Path;
import org.apache.jackrabbit.spi.QValue;
import org.apache.jackrabbit.spi.QValueFactory;
import org.apache.jackrabbit.spi.commons.conversion.NamePathResolver;
import org.apache.jackrabbit.spi.commons.value.QValueValue;
import org.apache.jackrabbit.spi.commons.value.ValueFactoryQImpl;

public class ValueFormat {
    public static QValue getQValue(Value jcrValue, NamePathResolver resolver, QValueFactory factory) throws RepositoryException {
        if (jcrValue == null) {
            throw new IllegalArgumentException("null value");
        }
        if (jcrValue instanceof QValueValue) {
            return ((QValueValue)jcrValue).getQValue();
        }
        if (jcrValue.getType() == 2) {
            try {
                return factory.create(jcrValue.getStream());
            }
            catch (IOException e) {
                throw new RepositoryException((Throwable)e);
            }
        }
        if (jcrValue.getType() == 5) {
            return factory.create(jcrValue.getDate());
        }
        if (jcrValue.getType() == 4) {
            return factory.create(jcrValue.getDouble());
        }
        if (jcrValue.getType() == 3) {
            return factory.create(jcrValue.getLong());
        }
        return ValueFormat.getQValue(jcrValue.getString(), jcrValue.getType(), resolver, factory);
    }

    public static QValue[] getQValues(Value[] jcrValues, NamePathResolver resolver, QValueFactory factory) throws RepositoryException {
        if (jcrValues == null) {
            throw new IllegalArgumentException("null value");
        }
        ArrayList<QValue> qValues = new ArrayList<QValue>();
        for (int i = 0; i < jcrValues.length; ++i) {
            if (jcrValues[i] == null) continue;
            qValues.add(ValueFormat.getQValue(jcrValues[i], resolver, factory));
        }
        return qValues.toArray(new QValue[qValues.size()]);
    }

    public static QValue getQValue(String jcrValue, int propertyType, NamePathResolver resolver, QValueFactory factory) throws RepositoryException {
        QValue qValue;
        switch (propertyType) {
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: {
                qValue = factory.create(jcrValue, propertyType);
                break;
            }
            case 2: {
                qValue = factory.create(jcrValue.getBytes());
                break;
            }
            case 7: {
                Name qName = resolver.getQName(jcrValue);
                qValue = factory.create(qName);
                break;
            }
            case 8: {
                Path qPath = resolver.getQPath(jcrValue).getNormalizedPath();
                qValue = factory.create(qPath);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid property type.");
            }
        }
        return qValue;
    }

    public static Value getJCRValue(QValue qualifiedValue, NamePathResolver resolver, ValueFactory factory) throws RepositoryException {
        Value jcrValue;
        if (factory instanceof ValueFactoryQImpl) {
            return ((ValueFactoryQImpl)factory).createValue(qualifiedValue);
        }
        int propertyType = qualifiedValue.getType();
        switch (propertyType) {
            case 1: 
            case 9: {
                jcrValue = factory.createValue(qualifiedValue.getString(), propertyType);
                break;
            }
            case 8: {
                Path qPath = qualifiedValue.getPath();
                jcrValue = factory.createValue(resolver.getJCRPath(qPath), propertyType);
                break;
            }
            case 7: {
                Name qName = qualifiedValue.getName();
                jcrValue = factory.createValue(resolver.getJCRName(qName), propertyType);
                break;
            }
            case 6: {
                jcrValue = factory.createValue(qualifiedValue.getBoolean());
                break;
            }
            case 2: {
                jcrValue = factory.createValue(qualifiedValue.getStream());
                break;
            }
            case 5: {
                jcrValue = factory.createValue(qualifiedValue.getCalendar());
                break;
            }
            case 4: {
                jcrValue = factory.createValue(qualifiedValue.getDouble());
                break;
            }
            case 3: {
                jcrValue = factory.createValue(qualifiedValue.getLong());
                break;
            }
            default: {
                throw new RepositoryException("illegal internal value type");
            }
        }
        return jcrValue;
    }
}

