/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.extractor;

import java.io.IOException;
import java.io.Writer;
import org.xml.sax.Attributes;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

class ExtractorHandler
extends DefaultHandler
implements ErrorHandler {
    private static final char SPACE = ' ';
    private final Writer writer;
    private boolean space;

    public ExtractorHandler(Writer writer) {
        this.writer = writer;
        this.space = false;
    }

    public void startElement(String uri, String local, String name, Attributes attributes) throws SAXException {
        for (int i = 0; i < attributes.getLength(); ++i) {
            String value = attributes.getValue(i);
            this.characters(value.toCharArray(), 0, value.length());
        }
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        try {
            for (int i = 0; i < length; ++i) {
                if (Character.isSpaceChar(ch[start + i])) {
                    this.space = true;
                    continue;
                }
                if (this.space) {
                    this.writer.write(32);
                    this.space = false;
                }
                this.writer.write(ch[start + i]);
            }
            this.space = true;
        }
        catch (IOException e) {
            throw new SAXException(e.getMessage());
        }
    }

    public void warning(SAXParseException exception) {
    }

    public void error(SAXParseException exception) {
    }

    public void fatalError(SAXParseException exception) {
    }
}

