/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.extractor;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Document;
import javax.swing.text.rtf.RTFEditorKit;
import org.apache.jackrabbit.extractor.AbstractTextExtractor;

public class RTFTextExtractor
extends AbstractTextExtractor {
    public RTFTextExtractor() {
        super(new String[]{"application/rtf", "text/rtf"});
    }

    public Reader extractText(InputStream stream, String type, String encoding) throws IOException {
        try {
            RTFEditorKit rek = new RTFEditorKit();
            DefaultStyledDocument doc = new DefaultStyledDocument();
            rek.read(stream, (Document)doc, 0);
            String text = doc.getText(0, doc.getLength());
            StringReader stringReader = new StringReader(text);
            return stringReader;
        }
        catch (BadLocationException e) {
            throw new IOException(e.getMessage());
        }
        finally {
            stream.close();
        }
    }
}

