/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.commons;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import junit.framework.TestCase;
import org.apache.jackrabbit.oak.commons.IOUtils;

public class IOUtilsTest
extends TestCase {
    public void testReadFully() throws IOException {
        final Random r = new Random(1L);
        byte[] data = new byte[1000];
        final AtomicInteger readCount = new AtomicInteger();
        r.nextBytes(data);
        FilterInputStream in = new FilterInputStream(new ByteArrayInputStream(data)){

            @Override
            public int read(byte[] buffer, int off, int max) throws IOException {
                readCount.incrementAndGet();
                if (r.nextInt(10) == 0) {
                    return 0;
                }
                return this.in.read(buffer, off, Math.min(10, max));
            }
        };
        in.mark(10000);
        byte[] test = new byte[1000];
        IOUtilsTest.assertEquals((int)0, (int)IOUtils.readFully((InputStream)in, (byte[])test, (int)0, (int)0));
        IOUtilsTest.assertEquals((int)0, (int)readCount.get());
        IOUtilsTest.assertEquals((int)1000, (int)IOUtils.readFully((InputStream)in, (byte[])test, (int)0, (int)1000));
        IOUtilsTest.assertEquals(data, test);
        test = new byte[1001];
        in.reset();
        in.mark(10000);
        IOUtilsTest.assertEquals((int)1000, (int)IOUtils.readFully((InputStream)in, (byte[])test, (int)0, (int)1001));
        IOUtilsTest.assertEquals((int)0, (int)IOUtils.readFully((InputStream)in, (byte[])test, (int)0, (int)0));
    }

    public void testSkipFully() throws IOException {
        Random r = new Random(1L);
        byte[] data = new byte[1000];
        r.nextBytes(data);
        FilterInputStream in = new FilterInputStream(new ByteArrayInputStream(data)){

            @Override
            public int read(byte[] buffer, int off, int max) throws IOException {
                return this.in.read(buffer, off, Math.min(10, max));
            }
        };
        in.mark(10000);
        IOUtils.skipFully((InputStream)in, (long)1000L);
        IOUtilsTest.assertEquals((int)-1, (int)in.read());
        in.reset();
        try {
            IOUtils.skipFully((InputStream)in, (long)1001L);
            IOUtilsTest.fail();
        }
        catch (EOFException e) {
            // empty catch block
        }
    }

    public void testStringReadWrite() throws IOException {
        final Random r = new Random(1L);
        for (int i = 0; i < 100000; i += i / 10 + 1) {
            String s = "";
            for (int j = 0; j < 10; ++j) {
                String p = new String(new char[i]).replace('\u0000', 'a');
                s = s + p;
            }
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            IOUtils.writeString((OutputStream)out, (String)s);
            byte[] data = out.toByteArray();
            ByteArrayInputStream in = new ByteArrayInputStream(data){

                @Override
                public int read(byte[] b, int off, int len) {
                    if (r.nextBoolean()) {
                        len = r.nextInt(len);
                    }
                    return super.read(b, off, len);
                }
            };
            String t = IOUtils.readString((InputStream)in);
            IOUtilsTest.assertEquals((String)s, (String)t);
            IOUtilsTest.assertEquals((int)-1, (int)in.read());
        }
        try {
            ByteArrayInputStream in = new ByteArrayInputStream(new byte[]{1});
            IOUtils.readString((InputStream)in);
            IOUtilsTest.fail();
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
    }

    public void testBytesReadWrite() throws IOException {
        Random r = new Random();
        int iterations = 1000;
        while (iterations-- > 0) {
            int n = Math.abs(r.nextInt()) % 262144;
            byte[] buf = new byte[n];
            r.nextBytes(buf);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            IOUtils.writeBytes((OutputStream)out, (byte[])buf);
            byte[] buf1 = IOUtils.readBytes((InputStream)new ByteArrayInputStream(out.toByteArray()));
            IOUtilsTest.assertEquals(buf, buf1);
        }
    }

    public void testVarInt() throws IOException {
        IOUtilsTest.testVarInt(0, 1);
        IOUtilsTest.testVarInt(127, 1);
        IOUtilsTest.testVarInt(128, 2);
        IOUtilsTest.testVarInt(16383, 2);
        IOUtilsTest.testVarInt(16384, 3);
        IOUtilsTest.testVarInt(0x1FFFFF, 3);
        IOUtilsTest.testVarInt(0x200000, 4);
        IOUtilsTest.testVarInt(0xFFFFFFF, 4);
        IOUtilsTest.testVarInt(0x10000000, 5);
        IOUtilsTest.testVarInt(-1, 5);
        for (int x = 0; x < 131072; ++x) {
            IOUtilsTest.testVarInt(x, 0);
            IOUtilsTest.testVarInt(Integer.MIN_VALUE + x, 0);
            IOUtilsTest.testVarInt(Integer.MAX_VALUE - x, 5);
            IOUtilsTest.testVarInt(0x200000 + x - 100, 0);
            IOUtilsTest.testVarInt(0x10000000 + x - 100, 0);
        }
        Random r = new Random(1L);
        for (int i = 0; i < 100000; ++i) {
            IOUtilsTest.testVarInt(r.nextInt(), 0);
            IOUtilsTest.testVarInt(r.nextInt(10000000), 0);
        }
        ByteArrayInputStream in = new ByteArrayInputStream(new byte[]{-128, 0});
        IOUtilsTest.assertEquals((int)0, (int)IOUtils.readVarInt((InputStream)in));
        IOUtilsTest.assertEquals((int)-1, (int)((InputStream)in).read());
    }

    public void testVarLong() throws IOException {
        IOUtilsTest.testVarLong(0L, 1);
        IOUtilsTest.testVarLong(127L, 1);
        IOUtilsTest.testVarLong(128L, 2);
        IOUtilsTest.testVarLong(16383L, 2);
        IOUtilsTest.testVarLong(16384L, 3);
        IOUtilsTest.testVarLong(0x1FFFFFL, 3);
        IOUtilsTest.testVarLong(0x200000L, 4);
        IOUtilsTest.testVarLong(0xFFFFFFFL, 4);
        IOUtilsTest.testVarLong(0x10000000L, 5);
        IOUtilsTest.testVarLong(0x1FFFFFFFL, 5);
        IOUtilsTest.testVarLong(0x2000000000L, 6);
        IOUtilsTest.testVarLong(0x3FFFFFFFFFFL, 6);
        IOUtilsTest.testVarLong(0x40000000000L, 7);
        IOUtilsTest.testVarLong(0x1FFFFFFFFFFFFL, 7);
        IOUtilsTest.testVarLong(0x2000000000000L, 8);
        IOUtilsTest.testVarLong(0xFFFFFFFFFFFFFFL, 8);
        IOUtilsTest.testVarLong(0x100000000000000L, 9);
        IOUtilsTest.testVarLong(-1L, 10);
        for (int x = 0; x < 131072; ++x) {
            IOUtilsTest.testVarLong(x, 0);
            IOUtilsTest.testVarLong(Long.MIN_VALUE + (long)x, 0);
            IOUtilsTest.testVarLong(Long.MAX_VALUE - (long)x, 9);
            IOUtilsTest.testVarLong(0x200000 + x - 100, 0);
            IOUtilsTest.testVarLong(0x10000000 + x - 100, 0);
        }
        Random r = new Random(1L);
        for (int i = 0; i < 100000; ++i) {
            IOUtilsTest.testVarLong(r.nextLong(), 0);
            IOUtilsTest.testVarLong(r.nextInt(Integer.MAX_VALUE), 0);
        }
        ByteArrayInputStream in = new ByteArrayInputStream(new byte[]{-128, 0});
        IOUtilsTest.assertEquals((long)0L, (long)IOUtils.readVarLong((InputStream)in));
        IOUtilsTest.assertEquals((int)-1, (int)((InputStream)in).read());
    }

    public void testVarEOF() throws IOException {
        try {
            IOUtils.readVarInt((InputStream)new ByteArrayInputStream(new byte[0]));
            IOUtilsTest.fail();
        }
        catch (EOFException e) {
            // empty catch block
        }
        try {
            IOUtils.readVarLong((InputStream)new ByteArrayInputStream(new byte[0]));
            IOUtilsTest.fail();
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
    }

    private static void testVarInt(int x, int expectedLen) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        IOUtils.writeVarInt((OutputStream)out, (int)x);
        byte[] data = out.toByteArray();
        IOUtilsTest.assertTrue((data.length <= 5 ? 1 : 0) != 0);
        if (expectedLen > 0) {
            IOUtilsTest.assertEquals((int)expectedLen, (int)data.length);
        }
        ByteArrayInputStream in = new ByteArrayInputStream(data);
        int x2 = IOUtils.readVarInt((InputStream)in);
        IOUtilsTest.assertEquals((int)x, (int)x2);
        IOUtilsTest.assertEquals((int)-1, (int)in.read());
    }

    private static void testVarLong(long x, int expectedLen) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        IOUtils.writeVarLong((OutputStream)out, (long)x);
        byte[] data = out.toByteArray();
        IOUtilsTest.assertTrue((data.length <= 10 ? 1 : 0) != 0);
        if (expectedLen > 0) {
            IOUtilsTest.assertEquals((int)expectedLen, (int)data.length);
        }
        ByteArrayInputStream in = new ByteArrayInputStream(data);
        long x2 = IOUtils.readVarLong((InputStream)in);
        IOUtilsTest.assertEquals((long)x, (long)x2);
        IOUtilsTest.assertEquals((int)-1, (int)in.read());
    }

    public static void assertEquals(byte[] expected, byte[] got) {
        IOUtilsTest.assertEquals((int)expected.length, (int)got.length);
        for (int i = 0; i < got.length; ++i) {
            IOUtilsTest.assertEquals((byte)expected[i], (byte)got[i]);
        }
    }
}

