/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.commons;

import junit.framework.AssertionFailedError;
import junit.framework.TestCase;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.junit.Assert;
import org.junit.Test;

public class PathUtilsTest
extends TestCase {
    static boolean assertsEnabled;
    static final /* synthetic */ boolean $assertionsDisabled;

    @Test
    public void test() {
        try {
            PathUtils.getParentPath((String)"invalid/path/");
            if (assertsEnabled) {
                PathUtilsTest.fail();
            }
        }
        catch (AssertionFailedError e) {
            throw e;
        }
        catch (AssertionError e) {
            // empty catch block
        }
        try {
            PathUtils.getName((String)"invalid/path/");
            if (assertsEnabled) {
                PathUtilsTest.fail();
            }
        }
        catch (AssertionFailedError e) {
            throw e;
        }
        catch (AssertionError assertionError) {
            // empty catch block
        }
        PathUtilsTest.test("parent", "child");
        PathUtilsTest.test("x", "y");
    }

    @Test
    public void testGetDepth() {
        PathUtilsTest.assertEquals((int)0, (int)PathUtils.getDepth((String)"/"));
        PathUtilsTest.assertEquals((int)0, (int)PathUtils.getDepth((String)""));
        PathUtilsTest.assertEquals((int)1, (int)PathUtils.getDepth((String)"/a"));
        PathUtilsTest.assertEquals((int)1, (int)PathUtils.getDepth((String)"a"));
        PathUtilsTest.assertEquals((int)2, (int)PathUtils.getDepth((String)"/a/b"));
        PathUtilsTest.assertEquals((int)2, (int)PathUtils.getDepth((String)"a/b"));
    }

    private static int getElementCount(String path) {
        int count = 0;
        for (String p : PathUtils.elements((String)path)) {
            PathUtilsTest.assertFalse((boolean)PathUtils.isAbsolute((String)p));
            ++count;
        }
        return count;
    }

    private static String getElement(String path, int index) {
        int count = 0;
        for (String p : PathUtils.elements((String)path)) {
            if (index != count++) continue;
            return p;
        }
        PathUtilsTest.fail();
        return "";
    }

    private static void test(String parent, String child) {
        block20: {
            PathUtilsTest.assertEquals((int)0, (int)PathUtilsTest.getElementCount(""));
            PathUtilsTest.assertEquals((int)0, (int)PathUtilsTest.getElementCount("/"));
            PathUtilsTest.assertEquals((int)1, (int)PathUtilsTest.getElementCount(parent));
            PathUtilsTest.assertEquals((int)2, (int)PathUtilsTest.getElementCount(parent + "/" + child));
            PathUtilsTest.assertEquals((int)1, (int)PathUtilsTest.getElementCount("/" + parent));
            PathUtilsTest.assertEquals((int)2, (int)PathUtilsTest.getElementCount("/" + parent + "/" + child));
            PathUtilsTest.assertEquals((int)3, (int)PathUtilsTest.getElementCount("/" + parent + "/" + child + "/" + child));
            PathUtilsTest.assertEquals((String)parent, (String)PathUtilsTest.getElement(parent, 0));
            PathUtilsTest.assertEquals((String)parent, (String)PathUtilsTest.getElement(parent + "/" + child, 0));
            PathUtilsTest.assertEquals((String)child, (String)PathUtilsTest.getElement(parent + "/" + child, 1));
            PathUtilsTest.assertEquals((String)child, (String)PathUtilsTest.getElement(parent + "/" + child + "/" + child + "1", 1));
            PathUtilsTest.assertEquals((String)(child + "1"), (String)PathUtilsTest.getElement(parent + "/" + child + "/" + child + "1", 2));
            PathUtilsTest.assertEquals((String)(parent + "/" + child), (String)PathUtils.concat((String)parent, (String)child));
            try {
                PathUtilsTest.assertEquals((String)(parent + "/" + child), (String)PathUtils.concat((String)(parent + "/"), (String)("/" + child)));
                if (assertsEnabled) {
                    PathUtilsTest.fail();
                }
            }
            catch (AssertionFailedError e) {
                throw e;
            }
            catch (IllegalArgumentException e) {
                if (assertsEnabled) {
                    throw e;
                }
            }
            catch (AssertionError e) {
                if (assertsEnabled) break block20;
                throw e;
            }
        }
        try {
            PathUtilsTest.assertEquals((String)(parent + "/" + child), (String)PathUtils.concat((String)parent, (String)("/" + child)));
            PathUtilsTest.fail();
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        PathUtilsTest.assertEquals((String)(parent + "/" + child + "/" + child), (String)PathUtils.concat((String)parent, (String[])new String[]{child, child}));
        PathUtilsTest.assertEquals((String)(parent + "/" + child), (String)PathUtils.concat((String)parent, (String[])new String[]{"", child}));
        PathUtilsTest.assertEquals((String)(parent + "/" + child), (String)PathUtils.concat((String)parent, (String[])new String[]{child, ""}));
        PathUtilsTest.assertEquals((String)(child + "/" + child), (String)PathUtils.concat((String)"", (String[])new String[]{child, child}));
        PathUtilsTest.assertEquals((String)child, (String)PathUtils.concat((String)"", (String[])new String[]{child, ""}));
        PathUtilsTest.assertEquals((String)child, (String)PathUtils.concat((String)"", (String[])new String[]{"", child}));
        PathUtilsTest.assertEquals((String)child, (String)PathUtils.concat((String)"", (String)child));
        PathUtilsTest.assertEquals((String)("/" + child), (String)PathUtils.concat((String)"", (String)("/" + child)));
        PathUtilsTest.assertEquals((String)(parent + "/" + child), (String)PathUtils.concat((String)parent, (String)child));
        try {
            PathUtils.concat((String)("/" + parent), (String)("/" + child));
            PathUtilsTest.fail();
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            PathUtils.concat((String)"", (String)"//");
            if (assertsEnabled) {
                PathUtilsTest.fail();
            }
        }
        catch (AssertionFailedError e) {
            throw e;
        }
        catch (AssertionError e) {
            // empty catch block
        }
        try {
            PathUtils.concat((String)"/", (String)"/");
            if (assertsEnabled) {
                PathUtilsTest.fail();
            }
        }
        catch (AssertionFailedError e) {
            throw e;
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        PathUtilsTest.assertTrue((boolean)PathUtils.denotesRoot((String)"/"));
        PathUtilsTest.assertFalse((boolean)PathUtils.denotesRoot((String)("/" + parent)));
        PathUtilsTest.assertEquals((String)"", (String)PathUtils.getName((String)"/"));
        PathUtilsTest.assertEquals((String)parent, (String)PathUtils.getName((String)("/" + parent)));
        PathUtilsTest.assertEquals((String)child, (String)PathUtils.getName((String)("/" + parent + "/" + child)));
        PathUtilsTest.assertEquals((String)"/", (String)PathUtils.getParentPath((String)"/"));
        PathUtilsTest.assertEquals((String)"/", (String)PathUtils.getParentPath((String)("/" + parent)));
        PathUtilsTest.assertEquals((String)("/" + parent), (String)PathUtils.getParentPath((String)("/" + parent + "/" + child)));
        PathUtilsTest.assertEquals((String)"/", (String)PathUtils.getAncestorPath((String)"/", (int)1));
        PathUtilsTest.assertEquals((String)"/", (String)PathUtils.getAncestorPath((String)("/" + parent), (int)1));
        PathUtilsTest.assertEquals((String)("/" + parent), (String)PathUtils.getAncestorPath((String)("/" + parent + "/" + child), (int)1));
        PathUtilsTest.assertEquals((String)("/" + parent + "/" + child), (String)PathUtils.getAncestorPath((String)("/" + parent + "/" + child), (int)0));
        PathUtilsTest.assertEquals((String)"/", (String)PathUtils.getAncestorPath((String)("/" + parent + "/" + child), (int)2));
        PathUtilsTest.assertEquals((String)PathUtils.getParentPath((String)"/foo"), (String)PathUtils.getAncestorPath((String)"/foo", (int)1));
        PathUtilsTest.assertEquals((String)PathUtils.getParentPath((String)"/foo/bar"), (String)PathUtils.getAncestorPath((String)"/foo/bar", (int)1));
        PathUtilsTest.assertEquals((String)PathUtils.getParentPath((String)"foo/bar"), (String)PathUtils.getAncestorPath((String)"foo/bar", (int)1));
        PathUtilsTest.assertEquals((String)PathUtils.getParentPath((String)"foo"), (String)PathUtils.getAncestorPath((String)"foo", (int)1));
        PathUtilsTest.assertEquals((boolean)true, (boolean)PathUtils.isAbsolute((String)"/"));
        PathUtilsTest.assertEquals((boolean)false, (boolean)PathUtils.isAbsolute((String)parent));
        PathUtilsTest.assertEquals((boolean)true, (boolean)PathUtils.isAbsolute((String)("/" + parent)));
        PathUtilsTest.assertEquals((boolean)false, (boolean)PathUtils.isAbsolute((String)child));
        PathUtilsTest.assertEquals((boolean)true, (boolean)PathUtils.isAbsolute((String)("/" + parent + "/" + child)));
        PathUtilsTest.assertEquals((boolean)false, (boolean)PathUtils.isAbsolute((String)(parent + "/" + child)));
        PathUtilsTest.assertFalse((boolean)PathUtils.isAncestor((String)"/", (String)"/"));
        PathUtilsTest.assertFalse((boolean)PathUtils.isAncestor((String)("/" + parent), (String)("/" + parent)));
        PathUtilsTest.assertFalse((boolean)PathUtils.isAncestor((String)parent, (String)parent));
        PathUtilsTest.assertTrue((boolean)PathUtils.isAncestor((String)"/", (String)("/" + parent)));
        PathUtilsTest.assertTrue((boolean)PathUtils.isAncestor((String)parent, (String)(parent + "/" + child)));
        PathUtilsTest.assertFalse((boolean)PathUtils.isAncestor((String)"/", (String)(parent + "/" + child)));
        PathUtilsTest.assertTrue((boolean)PathUtils.isAncestor((String)("/" + parent), (String)("/" + parent + "/" + child)));
        PathUtilsTest.assertFalse((boolean)PathUtils.isAncestor((String)parent, (String)child));
        PathUtilsTest.assertFalse((boolean)PathUtils.isAncestor((String)("/" + parent), (String)("/" + parent + "123")));
        PathUtilsTest.assertFalse((boolean)PathUtils.isAncestor((String)("/" + parent), (String)("/" + parent + "123/foo")));
        PathUtilsTest.assertEquals((String)"", (String)PathUtils.relativize((String)"/", (String)"/"));
        PathUtilsTest.assertEquals((String)"", (String)PathUtils.relativize((String)("/" + parent), (String)("/" + parent)));
        PathUtilsTest.assertEquals((String)child, (String)PathUtils.relativize((String)("/" + parent), (String)("/" + parent + "/" + child)));
        PathUtilsTest.assertEquals((String)(parent + "/" + child), (String)PathUtils.relativize((String)"/", (String)("/" + parent + "/" + child)));
        try {
            PathUtils.relativize((String)"x/y", (String)"y/x");
            PathUtilsTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testMore() {
        String[] paths;
        for (String path : paths = new String[]{"", "/", "foo", "/foo", "foo/bar", "/foo/bar", "foo/bar/baz", "/foo/bar/baz", "x", "/x", "x/y", "/x/y", "x/y/z", "/x/y/z"}) {
            String parent = PathUtils.getParentPath((String)path);
            String name = PathUtils.getName((String)path);
            String concat = PathUtils.concat((String)parent, (String)name);
            PathUtilsTest.assertEquals((String)("original: " + path + " parent: " + parent + " name: " + name + " concat: " + concat), (String)path, (String)concat);
        }
    }

    public void testNextSlash() {
        String path = "/test/a";
        int n = PathUtils.getNextSlash((String)path, (int)0);
        PathUtilsTest.assertEquals((int)0, (int)n);
        n = PathUtils.getNextSlash((String)path, (int)(n + 1));
        PathUtilsTest.assertEquals((int)5, (int)n);
        n = PathUtils.getNextSlash((String)path, (int)(n + 1));
        PathUtilsTest.assertEquals((int)-1, (int)n);
    }

    public void testValidate() {
        for (String invalid : new String[]{"//", "//test", "/test/", "test/", "/test//", "/test//test", "//x", "/x/", "x/", "/x//", "/x//x"}) {
            try {
                PathUtils.validate((String)invalid);
                PathUtilsTest.fail((String)invalid);
            }
            catch (IllegalArgumentException e) {
                // empty catch block
            }
        }
        for (String valid : new String[]{"", "/", "test", "test/test", "/test", "/test/test", "x", "x/x", "/x", "/x/x"}) {
            PathUtils.validate((String)valid);
        }
        try {
            PathUtils.concat((String)"", (String[])new String[]{"/test", ""});
            PathUtilsTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testValidateEverything() {
        String invalid;
        block53: {
            block52: {
                invalid = "/test/test//test/test";
                try {
                    PathUtils.denotesRoot((String)invalid);
                    if (assertsEnabled) {
                        PathUtilsTest.fail();
                    }
                }
                catch (AssertionFailedError e) {
                    throw e;
                }
                catch (AssertionError e) {
                    // empty catch block
                }
                try {
                    PathUtils.concat((String)invalid, (String)"x");
                    if (assertsEnabled) {
                        PathUtilsTest.fail();
                    }
                }
                catch (AssertionFailedError e) {
                    throw e;
                }
                catch (AssertionError e) {
                    // empty catch block
                }
                try {
                    PathUtils.concat((String)"/x", (String)invalid);
                    if (assertsEnabled) {
                        PathUtilsTest.fail();
                    }
                }
                catch (AssertionFailedError e) {
                    throw e;
                }
                catch (IllegalArgumentException e) {
                    if (assertsEnabled) {
                        throw e;
                    }
                }
                catch (AssertionError e) {
                    if (assertsEnabled) break block52;
                    throw e;
                }
            }
            try {
                PathUtils.concat((String)"/x", (String[])new String[]{"y", invalid});
                if (assertsEnabled) {
                    PathUtilsTest.fail();
                }
            }
            catch (AssertionFailedError e) {
                throw e;
            }
            catch (IllegalArgumentException e) {
                if (assertsEnabled) {
                    throw e;
                }
            }
            catch (AssertionError e) {
                if (assertsEnabled) break block53;
                throw e;
            }
        }
        try {
            PathUtils.concat((String)invalid, (String[])new String[]{"y", "z"});
            if (assertsEnabled) {
                PathUtilsTest.fail();
            }
        }
        catch (AssertionFailedError e) {
            throw e;
        }
        catch (AssertionError e) {
            // empty catch block
        }
        try {
            PathUtils.getDepth((String)invalid);
            if (assertsEnabled) {
                PathUtilsTest.fail();
            }
        }
        catch (AssertionFailedError e) {
            throw e;
        }
        catch (AssertionError e) {
            // empty catch block
        }
        try {
            PathUtils.getName((String)invalid);
            if (assertsEnabled) {
                PathUtilsTest.fail();
            }
        }
        catch (AssertionFailedError e) {
            throw e;
        }
        catch (AssertionError e) {
            // empty catch block
        }
        try {
            PathUtils.getNextSlash((String)invalid, (int)0);
            if (assertsEnabled) {
                PathUtilsTest.fail();
            }
        }
        catch (AssertionFailedError e) {
            throw e;
        }
        catch (AssertionError e) {
            // empty catch block
        }
        try {
            PathUtils.getParentPath((String)invalid);
            if (assertsEnabled) {
                PathUtilsTest.fail();
            }
        }
        catch (AssertionFailedError e) {
            throw e;
        }
        catch (AssertionError e) {
            // empty catch block
        }
        try {
            PathUtils.isAbsolute((String)invalid);
            if (assertsEnabled) {
                PathUtilsTest.fail();
            }
        }
        catch (AssertionFailedError e) {
            throw e;
        }
        catch (AssertionError e) {
            // empty catch block
        }
        try {
            PathUtils.relativize((String)invalid, (String)invalid);
            if (assertsEnabled) {
                PathUtilsTest.fail();
            }
        }
        catch (AssertionFailedError e) {
            throw e;
        }
        catch (AssertionError e) {
            // empty catch block
        }
        try {
            PathUtils.relativize((String)"/test", (String)invalid);
            if (assertsEnabled) {
                PathUtilsTest.fail();
            }
        }
        catch (AssertionFailedError e) {
            throw e;
        }
        catch (AssertionError assertionError) {
            // empty catch block
        }
    }

    public void testPathElements() {
        String[] invalidPaths;
        for (String path : invalidPaths = new String[]{"//", "/a/", "a/", "/a//", "a//b"}) {
            try {
                PathUtils.elements((String)path);
                PathUtilsTest.fail();
            }
            catch (AssertionError e) {
                // empty catch block
            }
        }
    }

    public void testElements() {
        String path = "a/b/c";
        String[] elementsArray = path.split("/");
        Iterable elementsIterable = PathUtils.elements((String)path);
        int k = 0;
        for (String name : elementsIterable) {
            Assert.assertEquals((Object)elementsArray[k++], (Object)name);
        }
        PathUtilsTest.assertEquals((int)3, (int)k);
        k = 0;
        for (String name : elementsIterable) {
            Assert.assertEquals((Object)elementsArray[k++], (Object)name);
        }
        PathUtilsTest.assertEquals((int)3, (int)k);
    }

    static {
        boolean bl = $assertionsDisabled = !PathUtilsTest.class.desiredAssertionStatus();
        if (!$assertionsDisabled) {
            assertsEnabled = true;
            if (!true) {
                throw new AssertionError();
            }
        }
    }
}

