/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.commons;

import java.util.ArrayList;
import java.util.HashMap;
import org.apache.jackrabbit.oak.commons.PropertiesUtil;
import org.junit.Assert;
import org.junit.Test;

public class PropertiesUtilTest {
    @Test
    public void testToDouble() {
        Assert.assertEquals((double)2.0, (double)PropertiesUtil.toDouble(null, (double)2.0), (double)0.0);
        Assert.assertEquals((double)1.0, (double)PropertiesUtil.toDouble((Object)1.0, (double)2.0), (double)0.0);
        Assert.assertEquals((double)1.0, (double)PropertiesUtil.toDouble((Object)new Double(1.0), (double)2.0), (double)0.0);
        Assert.assertEquals((double)5.0, (double)PropertiesUtil.toDouble((Object)new Long(5L), (double)2.0), (double)0.0);
        Assert.assertEquals((double)2.0, (double)PropertiesUtil.toDouble((Object)"abc", (double)2.0), (double)0.0);
    }

    @Test
    public void testToBoolean() {
        Assert.assertEquals((Object)true, (Object)PropertiesUtil.toBoolean(null, (boolean)true));
        Assert.assertEquals((Object)false, (Object)PropertiesUtil.toBoolean((Object)1.0, (boolean)true));
        Assert.assertEquals((Object)false, (Object)PropertiesUtil.toBoolean((Object)false, (boolean)true));
        Assert.assertEquals((Object)false, (Object)PropertiesUtil.toBoolean((Object)"false", (boolean)true));
        Assert.assertEquals((Object)false, (Object)PropertiesUtil.toBoolean((Object)"abc", (boolean)true));
    }

    @Test
    public void testToInteger() {
        Assert.assertEquals((long)2L, (long)PropertiesUtil.toInteger(null, (int)2));
        Assert.assertEquals((long)2L, (long)PropertiesUtil.toInteger((Object)1.0, (int)2));
        Assert.assertEquals((long)2L, (long)PropertiesUtil.toInteger((Object)new Double(1.0), (int)2));
        Assert.assertEquals((long)5L, (long)PropertiesUtil.toInteger((Object)new Long(5L), (int)2));
        Assert.assertEquals((long)5L, (long)PropertiesUtil.toInteger((Object)new Integer(5), (int)2));
        Assert.assertEquals((long)2L, (long)PropertiesUtil.toInteger((Object)"abc", (int)2));
    }

    @Test
    public void testToLong() {
        Assert.assertEquals((long)2L, (long)PropertiesUtil.toLong(null, (long)2L));
        Assert.assertEquals((long)2L, (long)PropertiesUtil.toLong((Object)1.0, (long)2L));
        Assert.assertEquals((long)2L, (long)PropertiesUtil.toLong((Object)new Double(1.0), (long)2L));
        Assert.assertEquals((long)5L, (long)PropertiesUtil.toLong((Object)new Long(5L), (long)2L));
        Assert.assertEquals((long)5L, (long)PropertiesUtil.toLong((Object)new Integer(5), (long)2L));
        Assert.assertEquals((long)2L, (long)PropertiesUtil.toLong((Object)"abc", (long)2L));
    }

    @Test
    public void testToObject() {
        Assert.assertEquals((Object)"hallo", (Object)PropertiesUtil.toObject((Object)"hallo"));
        Assert.assertEquals((Object)"1", (Object)PropertiesUtil.toObject((Object)new String[]{"1", "2"}));
        Assert.assertEquals(null, (Object)PropertiesUtil.toObject(null));
        Assert.assertEquals(null, (Object)PropertiesUtil.toObject((Object)new String[0]));
        ArrayList<String> l = new ArrayList<String>();
        Assert.assertEquals(null, (Object)PropertiesUtil.toObject(l));
        l.add("1");
        Assert.assertEquals((Object)"1", (Object)PropertiesUtil.toObject(l));
        l.add("2");
        Assert.assertEquals((Object)"1", (Object)PropertiesUtil.toObject(l));
        HashMap m = new HashMap();
        Assert.assertEquals(m, (Object)PropertiesUtil.toObject(m));
    }

    @Test
    public void testToString() {
        Assert.assertEquals((Object)"hallo", (Object)PropertiesUtil.toString((Object)"hallo", null));
        Assert.assertEquals((Object)this.toString(), (Object)PropertiesUtil.toString(null, (String)this.toString()));
        HashMap<String, Integer> m = new HashMap<String, Integer>();
        m.put("1", 5);
        Assert.assertEquals((Object)((Object)m).toString(), (Object)PropertiesUtil.toString(m, (String)this.toString()));
    }

    @Test
    public void testToStringArray() {
        Object[] defaultValue = new String[]{"1"};
        Assert.assertArrayEquals(null, (Object[])PropertiesUtil.toStringArray((Object)5));
        Assert.assertArrayEquals(null, (Object[])PropertiesUtil.toStringArray(null));
        Assert.assertArrayEquals((Object[])defaultValue, (Object[])PropertiesUtil.toStringArray((Object)5, (String[])defaultValue));
        Assert.assertArrayEquals((Object[])defaultValue, (Object[])PropertiesUtil.toStringArray(null, (String[])defaultValue));
        Assert.assertArrayEquals((Object[])new String[]{"hallo"}, (Object[])PropertiesUtil.toStringArray((Object)"hallo", (String[])defaultValue));
        Assert.assertArrayEquals((Object[])new String[]{"hallo"}, (Object[])PropertiesUtil.toStringArray((Object)new String[]{"hallo"}, (String[])defaultValue));
        Assert.assertArrayEquals((Object[])new String[]{"hallo", "you"}, (Object[])PropertiesUtil.toStringArray((Object)new String[]{"hallo", "you"}, (String[])defaultValue));
        Assert.assertArrayEquals((Object[])new String[]{"5", "1"}, (Object[])PropertiesUtil.toStringArray((Object)new Integer[]{5, 1}, (String[])defaultValue));
        Assert.assertArrayEquals((Object[])new String[]{"5", "1"}, (Object[])PropertiesUtil.toStringArray((Object)new Integer[]{5, null, 1}, (String[])defaultValue));
        ArrayList<String> l = new ArrayList<String>();
        Assert.assertArrayEquals((Object[])new String[0], (Object[])PropertiesUtil.toStringArray(l, (String[])defaultValue));
        l.add("1");
        l.add("2");
        Assert.assertArrayEquals((Object[])new String[]{"1", "2"}, (Object[])PropertiesUtil.toStringArray(l, (String[])defaultValue));
        l.add(null);
        Assert.assertArrayEquals((Object[])new String[]{"1", "2"}, (Object[])PropertiesUtil.toStringArray(l, (String[])defaultValue));
        HashMap<String, Integer> m = new HashMap<String, Integer>();
        m.put("1", 5);
        Assert.assertArrayEquals((Object[])defaultValue, (Object[])PropertiesUtil.toStringArray(m, (String[])defaultValue));
    }

    @Test
    public void testPopulate() {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("string", "foo");
        props.put("bool", "true");
        props.put("integer", "7");
        props.put("aLong", "11");
        TestBeanA bean = new TestBeanA();
        PropertiesUtil.populate((Object)bean, props, (boolean)false);
        Assert.assertEquals((Object)"foo", (Object)bean.getString());
        Assert.assertTrue((boolean)bean.getBool());
        Assert.assertEquals((long)7L, (long)bean.getInteger());
        Assert.assertEquals((long)11L, (long)bean.getaLong());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testPopulateAndValidate() {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("something", "foo");
        TestBeanA bean = new TestBeanA();
        PropertiesUtil.populate((Object)bean, props, (boolean)true);
    }

    private static class TestBeanA {
        private String string;
        private Boolean bool;
        private int integer;
        private long aLong;

        private TestBeanA() {
        }

        public String getString() {
            return this.string;
        }

        public void setString(String string) {
            this.string = string;
        }

        public Boolean getBool() {
            return this.bool;
        }

        public void setBool(Boolean bool) {
            this.bool = bool;
        }

        public int getInteger() {
            return this.integer;
        }

        public void setInteger(int integer) {
            this.integer = integer;
        }

        public long getaLong() {
            return this.aLong;
        }

        public void setaLong(long aLong) {
            this.aLong = aLong;
        }
    }
}

