/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.commons;

public class StopWatch {
    private static final long NANOS_PER_SECOND = 1000000000L;
    private long start;
    private long lastLog;

    public StopWatch() {
        this.lastLog = this.start = System.nanoTime();
    }

    public long time() {
        return System.nanoTime() - this.start;
    }

    public String seconds() {
        double s = (double)this.time() / 1.0E9;
        return String.format("%.2f seconds", s);
    }

    public String operationsPerSecond(int operations) {
        long t = this.time();
        double s = (double)t / 1.0E9;
        if (t == 0L) {
            t = 1L;
        }
        int ops = (int)((long)operations * 1000000000L / t);
        return String.format("%.2f seconds (%d ops; %d op/s)", s, operations, ops);
    }

    public boolean log() {
        long t = System.nanoTime();
        if (t - this.lastLog > 5000000000L) {
            this.lastLog = t;
            return true;
        }
        return false;
    }

    public void reset() {
        this.start = System.nanoTime();
    }
}

