/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.commons;

import junit.framework.TestCase;
import org.apache.jackrabbit.oak.commons.IOUtilsTest;
import org.apache.jackrabbit.oak.commons.StringUtils;

public class StringUtilsTest
extends TestCase {
    public void testHex() {
        StringUtilsTest.assertEquals((String)"0123", (String)StringUtils.convertBytesToHex((byte[])new byte[]{1, 35}));
        StringUtilsTest.assertEquals((String)"89bd", (String)StringUtils.convertBytesToHex((byte[])new byte[]{-119, -67}));
        StringUtilsTest.assertEquals((String)"face", (String)StringUtils.convertBytesToHex((byte[])new byte[]{-6, -50}));
        IOUtilsTest.assertEquals(new byte[]{-6, -50}, StringUtils.convertHexToBytes((String)"face"));
        IOUtilsTest.assertEquals(new byte[]{-6, -50}, StringUtils.convertHexToBytes((String)"fAcE"));
        IOUtilsTest.assertEquals(new byte[]{-6, -50}, StringUtils.convertHexToBytes((String)"FaCe"));
        IOUtilsTest.assertEquals(new byte[]{9, -81}, StringUtils.convertHexToBytes((String)"09af"));
        for (String s : new String[]{"120", "1/", "9:", "fast", "a`", "ag", "0@", "aG"}) {
            try {
                StringUtils.convertHexToBytes((String)s);
                StringUtilsTest.fail();
            }
            catch (IllegalArgumentException e) {
                // empty catch block
            }
        }
    }
}

