/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.commons.cache;

import java.util.concurrent.atomic.AtomicInteger;
import junit.framework.Assert;
import org.apache.jackrabbit.oak.commons.cache.Cache;
import org.apache.jackrabbit.oak.commons.concurrent.Concurrent;
import org.junit.Test;

public class ConcurrentCacheTest
implements Cache.Backend<Integer, Data> {
    Cache<Integer, Data> cache = Cache.newInstance((Cache.Backend)this, (int)5);
    AtomicInteger counter = new AtomicInteger();
    volatile int value;

    @Test
    public void test() throws Exception {
        Concurrent.run("cache", new Concurrent.Task(){

            @Override
            public void call() throws Exception {
                int k = ConcurrentCacheTest.this.value++ % 10;
                Data v = (Data)ConcurrentCacheTest.this.cache.get((Object)k);
                Assert.assertEquals((int)k, (int)v.value);
            }
        });
    }

    public Data load(Integer key) {
        int start = this.counter.get();
        try {
            Thread.sleep(1L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (this.counter.getAndIncrement() != start) {
            throw new AssertionError((Object)"Concurrent load");
        }
        return new Data(key);
    }

    static class Data
    implements Cache.Value {
        int value;

        Data(int value) {
            this.value = value;
        }

        public int getMemory() {
            return 1;
        }
    }
}

