/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.commons.concurrent;

import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

public class Concurrent {
    private Concurrent() {
    }

    public static void run(String message, Task task) throws Exception {
        Concurrent.run(message, task, 2, 1000);
    }

    public static void run(String message, final Task task, int threadCount, int millis) throws Exception {
        final AtomicBoolean stopped = new AtomicBoolean();
        final AtomicReference exception = new AtomicReference();
        ArrayList<1> threads = new ArrayList<1>();
        final AtomicInteger counter = new AtomicInteger();
        for (int i = 0; i < threadCount; ++i) {
            Thread t = new Thread("Task " + i){

                @Override
                public void run() {
                    while (!stopped.get()) {
                        try {
                            task.call();
                            counter.incrementAndGet();
                        }
                        catch (Error e) {
                            exception.set(e);
                            stopped.set(true);
                        }
                        catch (Exception e) {
                            exception.set(e);
                            stopped.set(true);
                        }
                    }
                }
            };
            if (threadCount == 1) {
                long l = (long)millis + System.currentTimeMillis();
                while (System.currentTimeMillis() < l) {
                    task.call();
                    counter.incrementAndGet();
                }
                millis = 0;
                continue;
            }
            t.start();
            threads.add(t);
        }
        Throwable e = null;
        while (e == null && millis > 0) {
            Thread.sleep(10L);
            millis -= 10;
            e = (Throwable)exception.get();
        }
        stopped.set(true);
        for (Thread thread : threads) {
            thread.join();
        }
        if (e != null) {
            if (e instanceof Exception) {
                throw (Exception)e;
            }
            throw (Error)e;
        }
    }

    public static interface Task {
        public void call() throws Exception;
    }
}

