/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.commons.jmx;

import java.lang.management.ManagementFactory;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import junit.framework.Assert;
import org.apache.jackrabbit.oak.commons.jmx.AnnotatedStandardMBean;
import org.apache.jackrabbit.oak.commons.jmx.Description;
import org.apache.jackrabbit.oak.commons.jmx.Impact;
import org.apache.jackrabbit.oak.commons.jmx.ImpactOption;
import org.apache.jackrabbit.oak.commons.jmx.Name;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;

public class AnnotatedStandardMBeanTest {
    protected static ObjectName objectName;
    protected static MBeanServer server;

    @BeforeClass
    public static void init() throws Exception {
        AnnotatedStandardMBean object = new AnnotatedStandardMBean((Object)new Foo(), FooMBean.class);
        objectName = new ObjectName("abc:TYPE=Test");
        server = ManagementFactory.getPlatformMBeanServer();
        server.registerMBean(object, objectName);
    }

    @AfterClass
    public static void tearDown() throws Exception {
        server.unregisterMBean(objectName);
    }

    @Test
    public void test() throws Exception {
        MBeanInfo info = server.getMBeanInfo(objectName);
        Assert.assertEquals((String)"MBean desc.", (String)info.getDescription());
        MBeanAttributeInfo a0 = this.findAttribute(info, "Getter");
        Assert.assertEquals((String)"getter", (String)a0.getDescription());
        MBeanAttributeInfo a1 = this.findAttribute(info, "It");
        Assert.assertEquals((String)"is", (String)a1.getDescription());
        MBeanAttributeInfo a2 = this.findAttribute(info, "Setter");
        Assert.assertEquals((String)"setter", (String)a2.getDescription());
        MBeanOperationInfo op0 = info.getOperations()[0];
        Assert.assertEquals((String)"run", (String)op0.getDescription());
        Assert.assertEquals((int)0, (int)op0.getImpact());
        MBeanParameterInfo p0 = op0.getSignature()[0];
        Assert.assertEquals((String)"timeout", (String)p0.getName());
        Assert.assertEquals((String)"how long?", (String)p0.getDescription());
    }

    private MBeanAttributeInfo findAttribute(MBeanInfo info, String name) {
        for (MBeanAttributeInfo a : info.getAttributes()) {
            if (!a.getName().equals(name)) continue;
            return a;
        }
        return null;
    }

    public static class Foo
    implements FooMBean {
        @Override
        public String getGetter() {
            return null;
        }

        @Override
        public boolean isIt() {
            return false;
        }

        @Override
        public void setSetter(long s) {
        }

        @Override
        public void run(long timeout) {
        }
    }

    @Description(value="MBean desc.")
    public static interface FooMBean {
        @Description(value="getter")
        public String getGetter();

        @Description(value="is")
        public boolean isIt();

        @Description(value="setter")
        public void setSetter(long var1);

        @Description(value="run")
        @Impact(value=ImpactOption.INFO)
        public void run(@Name(value="timeout") @Description(value="how long?") long var1);
    }
}

