/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.commons.json;

import junit.framework.TestCase;
import org.apache.jackrabbit.oak.commons.StopWatch;
import org.apache.jackrabbit.oak.commons.json.JsopBuilder;
import org.apache.jackrabbit.oak.commons.json.JsopReader;
import org.apache.jackrabbit.oak.commons.json.JsopStream;
import org.apache.jackrabbit.oak.commons.json.JsopTokenizer;
import org.apache.jackrabbit.oak.commons.json.JsopWriter;

public class JsopStreamTest
extends TestCase {
    public static void main(String ... args) {
        for (int k = 0; k < 5; ++k) {
            String s = "Hello \"World\" Hello \"World\" Hello \"World\" Hello \"World\" Hello \"World\" Hello \"World\" ";
            StopWatch timer = new StopWatch();
            JsopBuilder w = k % 2 == 1 ? new JsopBuilder() : new JsopStream();
            for (int i = 0; i < 1000000; ++i) {
                w.value(s);
                if (i % 100 != 0) continue;
                w.resetWriter();
            }
            System.out.println(w.getClass() + ": " + timer.seconds());
        }
    }

    public void testNested() {
        JsopStream s = new JsopStream().key("x");
        JsopStream nested = new JsopStream().array().value(1L).value(null).value(true).value(false).value("Hello").endArray();
        s.append((JsopWriter)nested);
        JsopStreamTest.assertEquals((String)"\"x\":[1,null,true,false,\"Hello\"]", (String)s.toString());
    }

    public void testRawValue() {
        JsopStream s = new JsopStream().tag('+').key("x").object().key("y").array().value(1L).array().endArray().value(2L).endArray().endObject();
        JsopStreamTest.assertEquals((String)"+\"x\":{\"y\":[1,[],2]}", (String)s.toString());
        JsopStreamTest.testRawValue((JsopReader)s);
        JsopStreamTest.testRawValue((JsopReader)new JsopTokenizer(s.toString()));
    }

    private static void testRawValue(JsopReader s) {
        for (int i = 0; i < 3; ++i) {
            JsopStreamTest.assertFalse((boolean)s.matches(45));
            JsopStreamTest.assertTrue((boolean)s.matches(43));
            JsopStreamTest.assertEquals((String)"x", (String)s.read(1));
            s.read(58);
            JsopStreamTest.assertEquals((String)"{", (String)s.read(123));
            JsopStreamTest.assertEquals((String)"y", (String)s.readString());
            s.read(58);
            JsopStreamTest.assertEquals((String)"[1,[],2]", (String)s.readRawValue());
            s.read(125);
            s.read(0);
            s.resetReader();
        }
    }

    public void testJsopReader() {
        JsopStream s = new JsopStream().tag('+').key("x").object().key("y").value(1L).key("n").value("").key("z").encodedValue("n10").endObject();
        s.setLineLength(-1);
        JsopStreamTest.assertEquals((String)"+\"x\":{\"y\":1,\"n\":\"\",\"z\":n10}", (String)s.toString());
        JsopStreamTest.assertFalse((boolean)s.matches(45));
        JsopStreamTest.assertTrue((boolean)s.matches(43));
        JsopStreamTest.assertEquals((String)"x", (String)s.read(1));
        try {
            s.read(125);
            JsopStreamTest.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
        s.read(58);
        JsopStreamTest.assertEquals((String)"{", (String)s.read(123));
        JsopStreamTest.assertEquals((String)"y", (String)s.readString());
        s.read(58);
        JsopStreamTest.assertEquals((String)"1", (String)s.readRawValue());
        s.read(44);
        JsopStreamTest.assertEquals((String)"n", (String)s.readString());
        s.read(58);
        JsopStreamTest.assertEquals((String)"\"\"", (String)s.readRawValue());
        s.read(44);
        JsopStreamTest.assertEquals((String)"z", (String)s.readString());
        s.read(58);
        JsopStreamTest.assertEquals((String)"n10", (String)s.readRawValue());
        s.read(125);
    }

    public void testTokenizer() {
        JsopStreamTest.test("+ \"x\": {}", (JsopReader)new JsopStream().tag('+').key("x").object().endObject());
        JsopStreamTest.test("[\"-1\": -1, \"true\": true, \"false\": false, \"null\": null]", (JsopReader)new JsopStream().array().key("-1").value(-1L).key("true").value(true).key("false").value(false).key("null").value(null).endArray());
    }

    static void test(String expected, JsopReader t) {
        String j2 = JsopStreamTest.prettyPrint(t);
        JsopStreamTest.assertEquals((String)expected, (String)j2);
        j2 = JsopStreamTest.prettyPrint((JsopReader)new JsopTokenizer(j2));
        JsopStreamTest.assertEquals((String)expected, (String)j2);
    }

    public static String prettyPrint(JsopReader t) {
        StringBuilder buff = new StringBuilder();
        do {
            JsopStreamTest.prettyPrint(buff, t, "  ");
        } while (t.getTokenType() != 0);
        return buff.toString();
    }

    static String prettyPrint(StringBuilder buff, JsopReader t, String ident) {
        String space = "";
        boolean inArray = false;
        block10: while (true) {
            int token = t.read();
            switch (token) {
                case 0: {
                    return buff.toString();
                }
                case 1: {
                    buff.append(JsopBuilder.encode((String)t.getToken()));
                    continue block10;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    buff.append(t.getToken());
                    continue block10;
                }
                case 123: {
                    if (t.matches(125)) {
                        buff.append("{}");
                        continue block10;
                    }
                    space = space + ident;
                    buff.append("{\n").append(space);
                    continue block10;
                }
                case 125: {
                    space = space.substring(0, space.length() - ident.length());
                    buff.append('\n').append(space).append("}");
                    continue block10;
                }
                case 91: {
                    inArray = true;
                    buff.append("[");
                    continue block10;
                }
                case 93: {
                    inArray = false;
                    buff.append("]");
                    continue block10;
                }
                case 44: {
                    if (!inArray) {
                        buff.append(",\n").append(space);
                        continue block10;
                    }
                    buff.append(", ");
                    continue block10;
                }
            }
            buff.append((char)token).append(' ');
        }
    }

    public static void testBuilder() {
        JsopStream buff = new JsopStream();
        buff.tag('+').object().key("foo").value("bar").key("int").value(3L).key("decimal").encodedValue("3.0").key("obj").object().key("boolean").value(true).key("null").value(null).key("arr").array().array().value(1L).value("\u001f ~ \u007f \u0080").value("42").endArray().array().endArray().endArray().endObject().key("some").value("more").endObject();
        String json = buff.toString();
        JsopStreamTest.assertEquals((String)"+{\"foo\":\"bar\",\"int\":3,\"decimal\":3.0,\"obj\":{\"boolean\":true,\"null\":null,\"arr\":[[1,\"\\u001f ~ \\u007f \\u0080\",\"42\"],[]]},\"some\":\"more\"}", (String)json);
        buff.resetWriter();
        buff.array().object().key("x").value("1").endObject().newline().object().key("y").value("2").endObject().newline().endArray();
        json = buff.toString();
        JsopStreamTest.assertEquals((String)"[{\"x\":\"1\"}\n,{\"y\":\"2\"}\n]", (String)json);
        buff = new JsopStream();
        buff.tag('+').key("x").value("1").newline();
        buff.tag('+').key("y").value("2").newline();
        buff.tag('+').key("z").value(false).newline();
        json = buff.toString();
        JsopStreamTest.assertEquals((String)"+\"x\":\"1\"\n+\"y\":\"2\"\n+\"z\":false\n", (String)json);
    }
}

