/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.commons.json;

import junit.framework.TestCase;
import org.apache.jackrabbit.oak.commons.StopWatch;
import org.apache.jackrabbit.oak.commons.json.JsopBuilder;
import org.apache.jackrabbit.oak.commons.json.JsopTokenizer;

public class JsopTest
extends TestCase {
    public static void main(String ... args) {
        for (int k = 0; k < 5; ++k) {
            String s = "Hello \"World\" Hello \"World\" Hello \"World\" Hello \"World\" Hello \"World\" Hello \"World\" ";
            StopWatch timer = new StopWatch();
            int t2 = 0;
            for (int i = 0; i < 1000000; ++i) {
                t2 += JsopBuilder.encode((String)s).length();
            }
            System.out.println(timer.seconds() + " dummy: " + t2);
        }
    }

    public void testDataType() {
        String dateString = new JsopBuilder().key("string").value("/Date(0)/").key("date").encodedValue("\"\\/Date(0)\\/\"").toString();
        JsopTest.assertEquals((String)"\"string\":\"/Date(0)/\",\"date\":\"\\/Date(0)\\/\"", (String)dateString);
        JsopTokenizer t = new JsopTokenizer(dateString);
        JsopTest.assertEquals((String)"string", (String)t.readString());
        t.read(58);
        JsopTest.assertEquals((String)"/Date(0)/", (String)t.readString());
        JsopTest.assertEquals((String)"/Date(0)/", (String)t.getEscapedToken());
        t.read(44);
        JsopTest.assertEquals((String)"date", (String)t.readString());
        t.read(58);
        JsopTest.assertEquals((String)"/Date(0)/", (String)t.readString());
        JsopTest.assertEquals((String)"\\/Date(0)\\/", (String)t.getEscapedToken());
    }

    public void testNullTrueFalse() {
        JsopTokenizer t = new JsopTokenizer("null, 1, null, true, false");
        JsopTest.assertEquals(null, (String)t.read(5));
        JsopTest.assertEquals((String)",", (String)t.read(44));
        JsopTest.assertEquals((String)"1", (String)t.read(2));
        JsopTest.assertEquals((String)",", (String)t.read(44));
        JsopTest.assertEquals(null, (String)t.read(5));
        JsopTest.assertEquals((String)",", (String)t.read(44));
        JsopTest.assertEquals((String)"true", (String)t.read(3));
        JsopTest.assertEquals((String)",", (String)t.read(44));
        JsopTest.assertEquals((String)"false", (String)t.read(4));
        t = new JsopTokenizer("true, false");
        JsopTest.assertEquals((String)"true", (String)t.read(3));
        JsopTest.assertEquals((String)",", (String)t.read(44));
        JsopTest.assertEquals((String)"false", (String)t.read(4));
        t = new JsopTokenizer("false, true");
        JsopTest.assertEquals((String)"false", (String)t.read(4));
        JsopTest.assertEquals((String)",", (String)t.read(44));
        JsopTest.assertEquals((String)"true", (String)t.read(3));
    }

    public void testLineLength() {
        JsopBuilder buff = new JsopBuilder();
        buff.key("hello").value("world");
        JsopTest.assertEquals((String)"\"hello\":\"world\"", (String)buff.toString());
        JsopTest.assertEquals((int)15, (int)buff.length());
        buff = new JsopBuilder();
        buff.setLineLength(10);
        buff.key("hello").value("world");
        JsopTest.assertEquals((String)"\"hello\":\n\"world\"", (String)buff.toString());
        JsopTest.assertEquals((int)16, (int)buff.length());
    }

    public void testNumber() {
        JsopTokenizer t = new JsopTokenizer("9/3:-3-:-/- 3");
        JsopTest.assertEquals((String)"9", (String)t.read(2));
        t.read(47);
        JsopTest.assertEquals((String)"3", (String)t.read(2));
        t.read(58);
        JsopTest.assertEquals((String)"-3", (String)t.read(2));
        t.read(45);
        t.read(58);
        t.read(45);
        t.read(47);
        t.read(45);
        t.read(2);
    }

    public void testRawValue() {
        JsopTokenizer t = new JsopTokenizer("");
        try {
            t.readRawValue();
            JsopTest.fail();
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        t = new JsopTokenizer("[unclosed");
        try {
            t.readRawValue();
            JsopTest.fail();
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        t = new JsopTokenizer("{\"x\": [1], null, true, {\"y\": 1}, [1, 2], [], [[1]], +error+}");
        t.read(123);
        JsopTest.assertEquals((String)"x", (String)t.readString());
        t.read(58);
        JsopTest.assertEquals((String)"[1]", (String)t.readRawValue());
        t.read(44);
        JsopTest.assertEquals((String)"null", (String)t.readRawValue());
        t.read(44);
        JsopTest.assertEquals((String)"true", (String)t.readRawValue());
        t.read(44);
        JsopTest.assertEquals((String)"{\"y\": 1}", (String)t.readRawValue());
        t.read(44);
        JsopTest.assertEquals((String)"[1, 2]", (String)t.readRawValue());
        t.read(44);
        JsopTest.assertEquals((String)"[]", (String)t.readRawValue());
        t.read(44);
        JsopTest.assertEquals((String)"[[1]]", (String)t.readRawValue());
        t.read(44);
        try {
            t.readRawValue();
            JsopTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testTokenizer() {
        JsopTest.assertEquals((String)"test", (String)JsopTokenizer.decode((String)"test"));
        JsopTest.assertEquals((String)"test", (String)JsopTokenizer.decodeQuoted((String)"\"test\""));
        JsopTest.assertEquals((String)"hello\nworld", (String)JsopTokenizer.decodeQuoted((String)"\"hello\\nworld\""));
        try {
            JsopTokenizer.decodeQuoted((String)"test");
            JsopTest.fail();
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            JsopTokenizer.decode((String)"test\\");
            JsopTest.fail();
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            JsopTokenizer.decode((String)"wrong\\uxxxx");
            JsopTest.fail();
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            JsopTokenizer.decode((String)"wrong\\m");
            JsopTest.fail();
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        JsopTest.test("/error/", "\"\\");
        JsopTest.test("/error/1", ".1");
        JsopTest.assertEquals((String)"x", (String)new JsopTokenizer("x").toString());
        JsopTest.test("/id:truetrue/", "truetrue");
        JsopTest.test("/id:truer/", "truer");
        JsopTest.test("/id:falsehood/", "falsehood");
        JsopTest.test("/id:nil/", "nil");
        JsopTest.test("/id:nil/1", "nil 1");
        JsopTest.test("/error/", "\"invalid");
        JsopTest.test("- \"test/test\"", "-\"test\\/test\"");
        JsopTest.test(" {\n\"x\": 1,\n\"y\": 2\n}\n", "{\"x\":1, \"y\":2}");
        JsopTest.test("[true, false, null]", "[true, false, null]");
        JsopTest.test("\"\"", "\"\"");
        JsopTest.test("\"\\u0003\"", "\"\\u0003\"");
        JsopTest.test("\"\\u0012\"", "\"\\u0012\"");
        JsopTest.test("\"\\u0123\"", "\"\\u0123\"");
        JsopTest.test("\"\\u1234\"", "\"\\u1234\"");
        JsopTest.test("\"-\\\\-\\\"-\\b-\\f-\\n-\\r-\\t\"", "\"-\\\\-\\\"-\\b-\\f-\\n-\\r-\\t\"");
        JsopTest.test("\"-\\b-\\f-\\n-\\r-\\t\"", "\"-\b-\f-\n-\r-\t\"");
        JsopTest.test("[0, 12, -1, 0.1, -0.1, -2.3e1, 1e+1, 1.e-20]", "[0,12,-1,0.1,-0.1,-2.3e1,1e+1,1.e-20]");
        JsopTest.test("\"Hello\"", "\"Hello\"");
        JsopTest.test("[]", "[]");
        JsopTest.test(" {\n\n}\n", "{}");
        JsopTest.test(" {\n\"a\": /* test */ 10\n}\n", "{ \"a\": /* test */ 10}");
        JsopTest.test("+ - / ^ ", "+ - / ^");
        JsopTest.test("/*/ comment /*/ ", "/*/ comment /*/");
        JsopTest.test("/**/ /id:comment//**/ ", "/**/ comment /**/");
        JsopTokenizer t = new JsopTokenizer("{}123");
        JsopTest.assertFalse((boolean)t.matches(43));
        JsopTest.assertTrue((boolean)t.matches(123));
        t.read(125);
        try {
            t.read(43);
            JsopTest.fail();
        }
        catch (IllegalArgumentException e) {
            JsopTest.assertEquals((String)"{}123[*] expected: '+'", (String)e.getMessage());
        }
        try {
            t.read(1);
            JsopTest.fail();
        }
        catch (IllegalArgumentException e) {
            JsopTest.assertEquals((String)"{}123[*] expected: string", (String)e.getMessage());
        }
    }

    static void test(String expected, String json) {
        String j2 = JsopTest.prettyPrintWithErrors(json);
        JsopTest.assertEquals((String)expected, (String)j2);
    }

    static String prettyPrintWithErrors(String jsop) {
        StringBuilder buff = new StringBuilder();
        JsopTokenizer t = new JsopTokenizer(jsop);
        do {
            JsopTest.prettyPrint(buff, t, "");
        } while (t.getTokenType() != 0);
        return buff.toString();
    }

    static String prettyPrint(StringBuilder buff, JsopTokenizer t, String ident) {
        String space = "";
        boolean inArray = false;
        block21: while (true) {
            switch (t.read()) {
                case 0: {
                    return buff.toString();
                }
                case 1: {
                    buff.append(JsopBuilder.encode((String)t.getToken()));
                    continue block21;
                }
                case 2: {
                    buff.append(t.getToken());
                    continue block21;
                }
                case 3: {
                    buff.append("true");
                    continue block21;
                }
                case 4: {
                    buff.append("false");
                    continue block21;
                }
                case 5: {
                    buff.append("null");
                    continue block21;
                }
                case 6: {
                    buff.append("/error/");
                    continue block21;
                }
                case 7: {
                    buff.append("/id:").append(t.getToken()).append('/');
                    continue block21;
                }
                case 8: {
                    buff.append("/*").append(t.getToken()).append("*/ ");
                    continue block21;
                }
                case 123: {
                    space = space + ident;
                    buff.append(" {\n").append(space);
                    continue block21;
                }
                case 125: {
                    space = space.substring(0, space.length() - ident.length());
                    buff.append('\n').append(space).append("}\n").append(space);
                    continue block21;
                }
                case 91: {
                    inArray = true;
                    buff.append("[");
                    continue block21;
                }
                case 93: {
                    inArray = false;
                    buff.append("]");
                    continue block21;
                }
                case 44: {
                    if (!inArray) {
                        buff.append(",\n").append(space);
                        continue block21;
                    }
                    buff.append(", ");
                    continue block21;
                }
                case 58: {
                    buff.append(": ");
                    continue block21;
                }
                case 43: {
                    buff.append("+ ");
                    continue block21;
                }
                case 45: {
                    buff.append("- ");
                    continue block21;
                }
                case 94: {
                    buff.append("^ ");
                    continue block21;
                }
                case 47: {
                    buff.append("/ ");
                    continue block21;
                }
            }
            break;
        }
        throw new AssertionError((Object)("token type: " + t.getTokenType()));
    }

    public void testBuilder() {
        JsopBuilder buff = new JsopBuilder();
        buff.tag('+').object().key("foo").value("bar").key("int").value(3L).key("decimal").encodedValue("3.0").key("obj").object().key("boolean").value(true).key("null").value(null).key("arr").array().array().value(1L).value("\u001f ~ \u007f \u0080").value("42").endArray().array().endArray().endArray().endObject().key("some").value("more").endObject();
        String json = buff.toString();
        JsopTest.assertEquals((String)"+{\"foo\":\"bar\",\"int\":3,\"decimal\":3.0,\"obj\":{\"boolean\":true,\"null\":null,\"arr\":[[1,\"\\u001f ~ \\u007f \\u0080\",\"42\"],[]]},\"some\":\"more\"}", (String)json);
        buff.resetWriter();
        buff.array().object().key("x").value("1").endObject().newline().object().key("y").value("2").endObject().newline().endArray();
        json = buff.toString();
        JsopTest.assertEquals((String)"[{\"x\":\"1\"}\n,{\"y\":\"2\"}\n]", (String)json);
        buff = new JsopBuilder();
        buff.tag('+').key("x").value("1").newline();
        buff.tag('+').key("y").value("2").newline();
        json = buff.toString();
        JsopTest.assertEquals((String)"+\"x\":\"1\"\n+\"y\":\"2\"\n", (String)json);
    }

    public void testEscape() {
        JsopTest.assertEquals((String)"null", (String)JsopBuilder.encode(null));
        JsopBuilder buff = new JsopBuilder().key("back\\slash").value("\\").key("back\\\\slash").value("\\\\");
        JsopTest.assertEquals((String)"\"back\\\\slash\":\"\\\\\",\"back\\\\\\\\slash\":\"\\\\\\\\\"", (String)buff.toString());
    }

    public void testPrettyPrint() {
        JsopTest.assertEquals((String)"{}", (String)JsopBuilder.prettyPrint((String)"{}"));
        JsopTest.assertEquals((String)"{\n  \"a\": 1,\n  \"b\": \"Hello\"\n}", (String)JsopBuilder.prettyPrint((String)"{\"a\":1,\"b\":\"Hello\"}"));
        JsopTest.assertEquals((String)"{\n  \"a\": [1, 2]\n}", (String)JsopBuilder.prettyPrint((String)"{\"a\":[1, 2]}"));
    }

    public static String format(String json) {
        return JsopTest.prettyPrint(new StringBuilder(), new JsopTokenizer(json), "    ");
    }
}

