/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.commons.sort;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Scanner;
import org.apache.jackrabbit.oak.commons.sort.ExternalSort;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ExternalSortTest {
    private static final String TEST_FILE1_TXT = "test-file-1.txt";
    private static final String TEST_FILE2_TXT = "test-file-2.txt";
    private static final String TEST_FILE1_CSV = "test-file-1.csv";
    private static final String[] EXPECTED_SORT_RESULTS = new String[]{"a", "b", "b", "e", "f", "i", "m", "o", "u", "u", "x", "y", "z"};
    private static final String[] EXPECTED_MERGE_RESULTS = new String[]{"a", "a", "b", "c", "c", "d", "e", "e", "f", "g", "g", "h", "i", "j", "k"};
    private static final String[] EXPECTED_MERGE_DISTINCT_RESULTS = new String[]{"a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k"};
    private static final String[] EXPECTED_HEADER_RESULTS = new String[]{"HEADER, HEADER", "a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k"};
    private static final String[] EXPECTED_DISTINCT_RESULTS = new String[]{"a", "b", "e", "f", "i", "m", "o", "u", "x", "y", "z"};
    private static final String[] SAMPLE = new String[]{"f", "m", "b", "e", "i", "o", "u", "x", "a", "y", "z", "b", "u"};
    private File file1;
    private File file2;
    private File csvFile;
    private List<File> fileList;

    @Before
    public void setUp() throws Exception {
        this.fileList = new ArrayList<File>(3);
        this.file1 = new File(this.getClass().getResource(TEST_FILE1_TXT).toURI());
        this.file2 = new File(this.getClass().getResource(TEST_FILE2_TXT).toURI());
        this.csvFile = new File(this.getClass().getResource(TEST_FILE1_CSV).toURI());
        File tmpFile1 = new File(this.file1.getPath().toString() + ".tmp");
        File tmpFile2 = new File(this.file2.getPath().toString() + ".tmp");
        ExternalSortTest.copyFile(this.file1, tmpFile1);
        ExternalSortTest.copyFile(this.file2, tmpFile2);
        this.fileList.add(tmpFile1);
        this.fileList.add(tmpFile2);
    }

    @After
    public void tearDown() throws Exception {
        this.file1 = null;
        this.file2 = null;
        this.csvFile = null;
        for (File f : this.fileList) {
            f.delete();
        }
        this.fileList.clear();
        this.fileList = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copyFile(File sourceFile, File destFile) throws IOException {
        if (!destFile.exists()) {
            destFile.createNewFile();
        }
        FileChannel source = null;
        AbstractInterruptibleChannel destination = null;
        try {
            source = new FileInputStream(sourceFile).getChannel();
            destination = new FileOutputStream(destFile).getChannel();
            ((FileChannel)destination).transferFrom(source, 0L, source.size());
        }
        finally {
            if (source != null) {
                source.close();
            }
            if (destination != null) {
                destination.close();
            }
        }
    }

    @Test
    public void testEmptyFiles() throws Exception {
        File f1 = File.createTempFile("tmp", "unit");
        File f2 = File.createTempFile("tmp", "unit");
        ExternalSort.mergeSortedFiles((List)ExternalSort.sortInBatch((File)f1), (File)f2);
        if (f2.length() != 0L) {
            throw new RuntimeException("empty files should end up emtpy");
        }
    }

    @Test
    public void testMergeSortedFiles() throws Exception {
        String line;
        Comparator<String> cmp = new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return o1.compareTo(o2);
            }
        };
        File out = File.createTempFile("test_results", ".tmp", null);
        ExternalSort.mergeSortedFiles(this.fileList, (File)out, (Comparator)cmp, (Charset)Charset.defaultCharset(), (boolean)false);
        BufferedReader bf = new BufferedReader(new FileReader(out));
        ArrayList<String> result = new ArrayList<String>();
        while ((line = bf.readLine()) != null) {
            result.add(line);
        }
        bf.close();
        Assert.assertArrayEquals((String)Arrays.toString(result.toArray()), (Object[])EXPECTED_MERGE_RESULTS, (Object[])result.toArray());
    }

    @Test
    public void testMergeSortedFilesDistinct() throws Exception {
        String line;
        Comparator<String> cmp = new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return o1.compareTo(o2);
            }
        };
        File out = File.createTempFile("test_results", ".tmp", null);
        ExternalSort.mergeSortedFiles(this.fileList, (File)out, (Comparator)cmp, (Charset)Charset.defaultCharset(), (boolean)true);
        BufferedReader bf = new BufferedReader(new FileReader(out));
        ArrayList<String> result = new ArrayList<String>();
        while ((line = bf.readLine()) != null) {
            result.add(line);
        }
        bf.close();
        Assert.assertArrayEquals((String)Arrays.toString(result.toArray()), (Object[])EXPECTED_MERGE_DISTINCT_RESULTS, (Object[])result.toArray());
    }

    @Test
    public void testMergeSortedFilesAppend() throws Exception {
        String line;
        Comparator<String> cmp = new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return o1.compareTo(o2);
            }
        };
        File out = File.createTempFile("test_results", ".tmp", null);
        ExternalSortTest.writeStringToFile(out, "HEADER, HEADER\n");
        ExternalSort.mergeSortedFiles(this.fileList, (File)out, (Comparator)cmp, (Charset)Charset.defaultCharset(), (boolean)true, (boolean)true, (boolean)false);
        BufferedReader bf = new BufferedReader(new FileReader(out));
        ArrayList<String> result = new ArrayList<String>();
        while ((line = bf.readLine()) != null) {
            result.add(line);
        }
        bf.close();
        Assert.assertArrayEquals((String)Arrays.toString(result.toArray()), (Object[])EXPECTED_HEADER_RESULTS, (Object[])result.toArray());
    }

    @Test
    public void testSortAndSave() throws Exception {
        String line;
        List<String> sample = Arrays.asList(SAMPLE);
        Comparator<String> cmp = new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return o1.compareTo(o2);
            }
        };
        File f = ExternalSort.sortAndSave(sample, (Comparator)cmp, (Charset)Charset.defaultCharset(), null, (boolean)false, (boolean)false);
        Assert.assertNotNull((Object)f);
        Assert.assertTrue((boolean)f.exists());
        Assert.assertTrue((f.length() > 0L ? 1 : 0) != 0);
        BufferedReader bf = new BufferedReader(new FileReader(f));
        ArrayList<String> result = new ArrayList<String>();
        while ((line = bf.readLine()) != null) {
            result.add(line);
        }
        bf.close();
        Assert.assertArrayEquals((String)Arrays.toString(result.toArray()), (Object[])EXPECTED_SORT_RESULTS, (Object[])result.toArray());
    }

    @Test
    public void testSortAndSaveDistinct() throws Exception {
        String line;
        List<String> sample = Arrays.asList(SAMPLE);
        Comparator<String> cmp = new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return o1.compareTo(o2);
            }
        };
        File f = ExternalSort.sortAndSave(sample, (Comparator)cmp, (Charset)Charset.defaultCharset(), null, (boolean)true, (boolean)false);
        Assert.assertNotNull((Object)f);
        Assert.assertTrue((boolean)f.exists());
        Assert.assertTrue((f.length() > 0L ? 1 : 0) != 0);
        BufferedReader bf = new BufferedReader(new FileReader(f));
        ArrayList<String> result = new ArrayList<String>();
        while ((line = bf.readLine()) != null) {
            result.add(line);
        }
        bf.close();
        Assert.assertArrayEquals((String)Arrays.toString(result.toArray()), (Object[])EXPECTED_DISTINCT_RESULTS, (Object[])result.toArray());
    }

    @Test
    public void testSortInBatch() throws Exception {
        Comparator<String> cmp = new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return o1.compareTo(o2);
            }
        };
        List listOfFiles = ExternalSort.sortInBatch((File)this.csvFile, (Comparator)cmp, (int)1024, (long)0x800000L, (Charset)Charset.defaultCharset(), null, (boolean)false, (int)1, (boolean)false);
        Assert.assertEquals((long)1L, (long)listOfFiles.size());
        ArrayList<String> result = ExternalSortTest.readLines((File)listOfFiles.get(0));
        Assert.assertArrayEquals((String)Arrays.toString(result.toArray()), (Object[])EXPECTED_MERGE_DISTINCT_RESULTS, (Object[])result.toArray());
    }

    @Test
    public void testCSVSorting() throws Exception {
        this.testCSVSortingWithParams(false);
        this.testCSVSortingWithParams(true);
    }

    public void testCSVSortingWithParams(boolean usegzip) throws Exception {
        File out = File.createTempFile("test_results", ".tmp", null);
        Comparator<String> cmp = new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return o1.compareTo(o2);
            }
        };
        FileReader fr = new FileReader(this.csvFile);
        Scanner scan = new Scanner(fr);
        String head = scan.nextLine();
        ExternalSortTest.writeStringToFile(out, head + "\n");
        List listOfFiles = ExternalSort.sortInBatch((File)this.csvFile, (Comparator)cmp, (int)1024, (long)0x800000L, (Charset)Charset.defaultCharset(), null, (boolean)false, (int)1, (boolean)usegzip);
        ExternalSort.mergeSortedFiles((List)listOfFiles, (File)out, (Comparator)cmp, (Charset)Charset.defaultCharset(), (boolean)false, (boolean)true, (boolean)usegzip);
        ArrayList<String> result = ExternalSortTest.readLines(out);
        Assert.assertEquals((long)12L, (long)result.size());
        Assert.assertArrayEquals((String)Arrays.toString(result.toArray()), (Object[])EXPECTED_HEADER_RESULTS, (Object[])result.toArray());
    }

    public static ArrayList<String> readLines(File f) throws IOException {
        String line;
        BufferedReader r = new BufferedReader(new FileReader(f));
        ArrayList<String> answer = new ArrayList<String>();
        while ((line = r.readLine()) != null) {
            answer.add(line);
        }
        return answer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeStringToFile(File f, String s) throws IOException {
        FileOutputStream out = new FileOutputStream(f);
        try {
            out.write(s.getBytes());
        }
        finally {
            out.close();
        }
    }
}

