/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.jcr.query.qom;

import java.util.HashMap;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import javax.jcr.query.QueryResult;
import javax.jcr.query.qom.Column;
import javax.jcr.query.qom.Constraint;
import javax.jcr.query.qom.Ordering;
import javax.jcr.query.qom.QueryObjectModel;
import javax.jcr.query.qom.Source;
import org.apache.jackrabbit.oak.jcr.query.QueryManagerImpl;
import org.apache.jackrabbit.oak.jcr.query.qom.BindVariableValueImpl;
import org.apache.jackrabbit.oak.jcr.query.qom.ConstraintImpl;

public class QueryObjectModelImpl
implements QueryObjectModel {
    private final Source source;
    private final Constraint constraint;
    private final HashMap<String, Value> bindVariableMap = new HashMap();
    private final QueryManagerImpl queryManager;
    private final ValueFactory valueFactory;
    private final Ordering[] orderings;
    private final Column[] columns;
    private long limit = Long.MAX_VALUE;
    private long offset;
    private boolean parsed;
    private String storedQueryPath;

    public QueryObjectModelImpl(QueryManagerImpl queryManager, ValueFactory valueFactory, Source source, Constraint constraint, Ordering[] orderings, Column[] columns) {
        this.queryManager = queryManager;
        this.valueFactory = valueFactory;
        this.source = source;
        this.constraint = constraint;
        this.orderings = orderings;
        this.columns = columns;
    }

    public void bindVariables() {
        if (this.constraint != null) {
            ((ConstraintImpl)this.constraint).bindVariables(this);
        }
    }

    public Column[] getColumns() {
        return this.columns == null ? new Column[]{} : this.columns;
    }

    public Constraint getConstraint() {
        return this.constraint;
    }

    public Ordering[] getOrderings() {
        return this.orderings == null ? new Ordering[]{} : this.orderings;
    }

    public Source getSource() {
        return this.source;
    }

    public String[] getBindVariableNames() throws RepositoryException {
        this.parse();
        String[] names = new String[this.bindVariableMap.size()];
        this.bindVariableMap.keySet().toArray(names);
        return names;
    }

    public void setLimit(long limit) {
        this.limit = limit;
    }

    public void setOffset(long offset) {
        this.offset = offset;
    }

    public ValueFactory getValueFactory() {
        return this.valueFactory;
    }

    public void bindValue(String varName, Value value) throws RepositoryException {
        this.parse();
        if (!this.bindVariableMap.containsKey(varName)) {
            throw new IllegalArgumentException("Variable name " + varName + " is not a valid variable in this query");
        }
        this.bindVariableMap.put(varName, value);
    }

    private void parse() throws RepositoryException {
        String[] names;
        if (this.parsed) {
            return;
        }
        for (String n : names = this.queryManager.createQuery(this.getStatement(), "JCR-SQL2").getBindVariableNames()) {
            this.bindVariableMap.put(n, null);
        }
        this.parsed = true;
    }

    public QueryResult execute() throws RepositoryException {
        return this.queryManager.executeQuery(this.getStatement(), "JCR-SQL2", this.limit, this.offset, this.bindVariableMap);
    }

    public String getLanguage() {
        return "JCR-JQOM";
    }

    public String getStatement() {
        int i;
        StringBuilder buff = new StringBuilder();
        buff.append("select ");
        if (this.columns != null && this.columns.length > 0) {
            i = 0;
            for (Column column : this.columns) {
                if (i++ > 0) {
                    buff.append(", ");
                }
                buff.append(column);
            }
        } else {
            buff.append("*");
        }
        buff.append(" from ");
        buff.append(this.source);
        if (this.constraint != null) {
            buff.append(" where ");
            buff.append(this.constraint);
        }
        if (this.orderings != null && this.orderings.length > 0) {
            buff.append(" order by ");
            i = 0;
            for (Column column : this.orderings) {
                if (i++ > 0) {
                    buff.append(", ");
                }
                buff.append(column);
            }
        }
        return buff.toString();
    }

    public String getStoredQueryPath() throws RepositoryException {
        if (this.storedQueryPath == null) {
            throw new ItemNotFoundException("Not a stored query");
        }
        return this.storedQueryPath;
    }

    public Node storeAsNode(String absPath) throws RepositoryException {
        Node n = this.queryManager.createQuery(this.getStatement(), "JCR-JQOM").storeAsNode(absPath);
        this.storedQueryPath = n.getPath();
        return n;
    }

    public void addBindVariable(BindVariableValueImpl var) {
        this.bindVariableMap.put(var.getBindVariableName(), null);
    }

    public String toString() {
        return this.getStatement();
    }
}

