/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.jcr.session;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.DateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.api.stats.RepositoryStatistics;
import org.apache.jackrabbit.oak.api.AuthInfo;
import org.apache.jackrabbit.oak.api.jmx.SessionMBean;
import org.apache.jackrabbit.oak.jcr.delegate.SessionDelegate;
import org.apache.jackrabbit.oak.jcr.session.RefreshStrategy;
import org.apache.jackrabbit.oak.jcr.session.operation.SessionOperation;
import org.apache.jackrabbit.oak.stats.Clock;
import org.apache.jackrabbit.oak.stats.StatisticManager;

public class SessionStats
implements SessionMBean {
    static final int INIT_STACK_TRACE_THRESHOLD = Integer.getInteger("oak.sessionStats.initStackTraceThreshold", 1000);
    private final Exception initStackTrace;
    private final AtomicReference<RepositoryException> lastFailedSave = new AtomicReference();
    private final Counters counters;
    private final String sessionId;
    private final AuthInfo authInfo;
    private final Clock clock;
    private final RefreshStrategy refreshStrategy;
    private volatile SessionDelegate sessionDelegate;
    private Map<String, Object> attributes = Collections.emptyMap();

    public SessionStats(String sessionId, AuthInfo authInfo, Clock clock, RefreshStrategy refreshStrategy, SessionDelegate sessionDelegate, StatisticManager statisticManager) {
        this.counters = new Counters(clock);
        this.sessionId = sessionId;
        this.authInfo = authInfo;
        this.clock = clock;
        this.refreshStrategy = refreshStrategy;
        this.sessionDelegate = sessionDelegate;
        long activeSessionCount = statisticManager.getStatsCounter(RepositoryStatistics.Type.SESSION_COUNT).getCount();
        this.initStackTrace = activeSessionCount > (long)INIT_STACK_TRACE_THRESHOLD ? new Exception("The session was opened here:") : null;
    }

    public void close() {
        this.sessionDelegate = null;
    }

    public Counters getCounters() {
        return this.counters;
    }

    public void setAttributes(Map<String, Object> attributes) {
        this.attributes = attributes;
    }

    public void failedSave(RepositoryException repositoryException) {
        this.lastFailedSave.set(repositoryException);
    }

    public String toString() {
        return this.getAuthInfo().getUserID() + '@' + this.sessionId + '@' + this.getLoginTimeStamp();
    }

    public String getInitStackTrace() {
        return SessionStats.format(this.initStackTrace);
    }

    public AuthInfo getAuthInfo() {
        return this.authInfo;
    }

    public String getLoginTimeStamp() {
        return SessionStats.formatDate(this.counters.getLoginTime());
    }

    public String getLastReadAccess() {
        return SessionStats.formatDate(this.counters.getReadTime());
    }

    public long getReadCount() {
        return this.counters.getReadCount();
    }

    public double getReadRate() {
        return this.calculateRate(this.getReadCount());
    }

    public String getLastWriteAccess() {
        return SessionStats.formatDate(this.counters.getWriteTime());
    }

    public long getWriteCount() {
        return this.counters.getWriteCount();
    }

    public double getWriteRate() {
        return this.calculateRate(this.getWriteCount());
    }

    public String getLastRefresh() {
        return SessionStats.formatDate(this.counters.getRefreshTime());
    }

    public String getRefreshStrategy() {
        return this.refreshStrategy.toString();
    }

    public boolean getRefreshPending() {
        return this.refreshStrategy.needsRefresh(TimeUnit.SECONDS.convert(this.clock.getTime() - this.counters.accessTime, TimeUnit.MILLISECONDS));
    }

    public long getRefreshCount() {
        return this.counters.getRefreshCount();
    }

    public double getRefreshRate() {
        return this.calculateRate(this.getRefreshCount());
    }

    public String getLastSave() {
        return SessionStats.formatDate(this.counters.getSaveTime());
    }

    public long getSaveCount() {
        return this.counters.getSaveCount();
    }

    public double getSaveRate() {
        return this.calculateRate(this.getSaveCount());
    }

    public String[] getSessionAttributes() {
        String[] atts = new String[this.attributes.size()];
        int k = 0;
        for (Map.Entry<String, Object> attribute : this.attributes.entrySet()) {
            atts[k++] = attribute.getKey() + '=' + attribute.getValue();
        }
        return atts;
    }

    public String getLastFailedSave() {
        return SessionStats.format((Exception)((Object)this.lastFailedSave.get()));
    }

    public void refresh() {
        final SessionDelegate sd = this.sessionDelegate;
        if (sd != null) {
            sd.safePerform(new SessionOperation<Void>("MBean initiated refresh", true){

                @Override
                public Void perform() {
                    sd.refresh(true);
                    return null;
                }

                @Override
                public void checkPreconditions() throws RepositoryException {
                    sd.checkAlive();
                }
            });
            sd.refresh(true);
        }
    }

    private static String formatDate(Date date) {
        return date == null ? "" : DateFormat.getDateTimeInstance().format(date);
    }

    private static String format(Exception exception) {
        if (exception == null) {
            return "";
        }
        StringWriter writer = new StringWriter();
        exception.printStackTrace(new PrintWriter(writer));
        return writer.toString();
    }

    private double calculateRate(long count) {
        double dt = this.counters.getSecondsSinceLogin();
        if (dt > 0.0) {
            return (double)count / dt;
        }
        return Double.NaN;
    }

    public static class Counters {
        private final Clock clock;
        private final long loginTime;
        public long accessTime;
        public long readTime = 0L;
        public long writeTime = 0L;
        public long refreshTime = 0L;
        public long saveTime = 0L;
        public long readCount = 0L;
        public long writeCount = 0L;
        public long refreshCount = 0L;
        public long saveCount = 0L;

        public Counters(Clock clock) {
            long time = clock.getTime();
            this.clock = clock;
            this.loginTime = time;
            this.accessTime = time;
        }

        public Date getLoginTime() {
            return new Date(this.loginTime);
        }

        public Date getReadTime() {
            return Counters.getTime(this.readTime);
        }

        public long getReadCount() {
            return this.readCount;
        }

        public Date getWriteTime() {
            return Counters.getTime(this.writeTime);
        }

        public long getWriteCount() {
            return this.writeCount;
        }

        public Date getRefreshTime() {
            return Counters.getTime(this.refreshTime);
        }

        public long getRefreshCount() {
            return this.refreshCount;
        }

        public Date getSaveTime() {
            return Counters.getTime(this.saveTime);
        }

        public long getSaveCount() {
            return this.saveCount;
        }

        public long getSecondsSinceLogin() {
            return TimeUnit.SECONDS.convert(this.clock.getTime() - this.loginTime, TimeUnit.MILLISECONDS);
        }

        private static Date getTime(long timestamp) {
            if (timestamp != 0L) {
                return new Date(timestamp);
            }
            return null;
        }
    }
}

