/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment.azure;

import com.google.common.base.Stopwatch;
import com.microsoft.azure.storage.StorageException;
import com.microsoft.azure.storage.blob.CloudBlob;
import com.microsoft.azure.storage.blob.CloudBlobDirectory;
import com.microsoft.azure.storage.blob.CloudBlockBlob;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.apache.jackrabbit.oak.commons.Buffer;
import org.apache.jackrabbit.oak.segment.azure.AzureBlobMetadata;
import org.apache.jackrabbit.oak.segment.azure.AzureSegmentArchiveEntry;
import org.apache.jackrabbit.oak.segment.azure.AzureUtilities;
import org.apache.jackrabbit.oak.segment.spi.monitor.IOMonitor;
import org.apache.jackrabbit.oak.segment.spi.persistence.SegmentArchiveEntry;
import org.apache.jackrabbit.oak.segment.spi.persistence.SegmentArchiveReader;

public class AzureSegmentArchiveReader
implements SegmentArchiveReader {
    static final boolean OFF_HEAP = Boolean.getBoolean("access.off.heap");
    private final CloudBlobDirectory archiveDirectory;
    private final IOMonitor ioMonitor;
    private final long length;
    private final Map<UUID, AzureSegmentArchiveEntry> index = new LinkedHashMap<UUID, AzureSegmentArchiveEntry>();
    private Boolean hasGraph;

    AzureSegmentArchiveReader(CloudBlobDirectory archiveDirectory, IOMonitor ioMonitor) throws IOException {
        this.archiveDirectory = archiveDirectory;
        this.ioMonitor = ioMonitor;
        long length = 0L;
        for (CloudBlob blob : AzureUtilities.getBlobs(archiveDirectory)) {
            HashMap<String, String> metadata = blob.getMetadata();
            if (AzureBlobMetadata.isSegment(metadata)) {
                AzureSegmentArchiveEntry indexEntry = AzureBlobMetadata.toIndexEntry(metadata, (int)blob.getProperties().getLength());
                this.index.put(new UUID(indexEntry.getMsb(), indexEntry.getLsb()), indexEntry);
            }
            length += blob.getProperties().getLength();
        }
        this.length = length;
    }

    public Buffer readSegment(long msb, long lsb) throws IOException {
        AzureSegmentArchiveEntry indexEntry = this.index.get(new UUID(msb, lsb));
        if (indexEntry == null) {
            return null;
        }
        Buffer buffer = OFF_HEAP ? Buffer.allocateDirect((int)indexEntry.getLength()) : Buffer.allocate((int)indexEntry.getLength());
        this.ioMonitor.beforeSegmentRead(this.pathAsFile(), msb, lsb, indexEntry.getLength());
        Stopwatch stopwatch = Stopwatch.createStarted();
        AzureUtilities.readBufferFully(this.getBlob(AzureUtilities.getSegmentFileName(indexEntry)), buffer);
        long elapsed = stopwatch.elapsed(TimeUnit.NANOSECONDS);
        this.ioMonitor.afterSegmentRead(this.pathAsFile(), msb, lsb, indexEntry.getLength(), elapsed);
        return buffer;
    }

    public boolean containsSegment(long msb, long lsb) {
        return this.index.containsKey(new UUID(msb, lsb));
    }

    public List<SegmentArchiveEntry> listSegments() {
        return new ArrayList<SegmentArchiveEntry>(this.index.values());
    }

    public Buffer getGraph() throws IOException {
        Buffer graph = this.readBlob(this.getName() + ".gph");
        this.hasGraph = graph != null;
        return graph;
    }

    public boolean hasGraph() {
        if (this.hasGraph == null) {
            try {
                this.getGraph();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return this.hasGraph;
    }

    public Buffer getBinaryReferences() throws IOException {
        return this.readBlob(this.getName() + ".brf");
    }

    public long length() {
        return this.length;
    }

    public String getName() {
        return AzureUtilities.getName(this.archiveDirectory);
    }

    public void close() {
    }

    public int getEntrySize(int size) {
        return size;
    }

    private File pathAsFile() {
        return new File(this.archiveDirectory.getUri().getPath());
    }

    private CloudBlockBlob getBlob(String name) throws IOException {
        try {
            return this.archiveDirectory.getBlockBlobReference(name);
        }
        catch (StorageException | URISyntaxException e) {
            throw new IOException(e);
        }
    }

    private Buffer readBlob(String name) throws IOException {
        try {
            CloudBlockBlob blob = this.getBlob(name);
            if (!blob.exists()) {
                return null;
            }
            long length = blob.getProperties().getLength();
            Buffer buffer = Buffer.allocate((int)((int)length));
            AzureUtilities.readBufferFully(blob, buffer);
            return buffer;
        }
        catch (StorageException e) {
            throw new IOException(e);
        }
    }
}

