/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudfiles;

import com.google.common.collect.ImmutableSet;
import com.google.inject.TypeLiteral;
import java.net.URI;
import java.util.Properties;
import java.util.Set;
import org.jclouds.apis.ApiMetadata;
import org.jclouds.blobstore.BlobRequestSigner;
import org.jclouds.cloudfiles.CloudFilesClient;
import org.jclouds.cloudfiles.blobstore.config.CloudFilesBlobStoreContextModule;
import org.jclouds.cloudfiles.config.CloudFilesHttpApiModule;
import org.jclouds.openstack.swift.SwiftApiMetadata;
import org.jclouds.openstack.swift.blobstore.SwiftBlobSigner;
import org.jclouds.openstack.swift.blobstore.config.TemporaryUrlExtensionModule;

public class CloudFilesApiMetadata
extends SwiftApiMetadata {
    public Builder toBuilder() {
        return (Builder)new Builder().fromApiMetadata((ApiMetadata)this);
    }

    public CloudFilesApiMetadata() {
        this(new Builder());
    }

    protected CloudFilesApiMetadata(Builder builder) {
        super((SwiftApiMetadata.Builder)builder);
    }

    public static Properties defaultProperties() {
        Properties properties = SwiftApiMetadata.defaultProperties();
        return properties;
    }

    public static class CloudFilesTemporaryUrlExtensionModule
    extends TemporaryUrlExtensionModule<CloudFilesClient> {
        protected void bindRequestSigner() {
            this.bind(BlobRequestSigner.class).to((TypeLiteral)new TypeLiteral<SwiftBlobSigner<CloudFilesClient>>(){});
        }
    }

    public static class Builder
    extends SwiftApiMetadata.Builder<CloudFilesClient, Builder> {
        protected Builder() {
            super(CloudFilesClient.class);
            ((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)this.id("cloudfiles")).name("Rackspace Cloud Files API")).identityName("Username")).credentialName("API Key")).documentation(URI.create("http://docs.rackspacecloud.com/files/api/v1/cfdevguide_d5/content/ch01.html"))).defaultProperties(CloudFilesApiMetadata.defaultProperties())).defaultModules((Set)ImmutableSet.builder().add(CloudFilesHttpApiModule.StorageAndCDNManagementEndpointModule.class).add(CloudFilesHttpApiModule.class).add(CloudFilesBlobStoreContextModule.class).add(CloudFilesTemporaryUrlExtensionModule.class).build());
        }

        public CloudFilesApiMetadata build() {
            return new CloudFilesApiMetadata(this);
        }

        protected Builder self() {
            return this;
        }
    }
}

